/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.translate.TranslateClient;
import software.amazon.awssdk.services.translate.internal.UserAgentUtils;
import software.amazon.awssdk.services.translate.model.ListTerminologiesRequest;
import software.amazon.awssdk.services.translate.model.ListTerminologiesResponse;

public class ListTerminologiesIterable
implements SdkIterable<ListTerminologiesResponse> {
    private final TranslateClient client;
    private final ListTerminologiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTerminologiesIterable(TranslateClient client, ListTerminologiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTerminologiesResponseFetcher();
    }

    public Iterator<ListTerminologiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTerminologiesResponseFetcher
    implements SyncPageFetcher<ListTerminologiesResponse> {
        private ListTerminologiesResponseFetcher() {
        }

        public boolean hasNextPage(ListTerminologiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTerminologiesResponse nextPage(ListTerminologiesResponse previousPage) {
            if (previousPage == null) {
                return ListTerminologiesIterable.this.client.listTerminologies(ListTerminologiesIterable.this.firstRequest);
            }
            return ListTerminologiesIterable.this.client.listTerminologies((ListTerminologiesRequest)((Object)ListTerminologiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

