/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Requested display language code is not supported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnsupportedDisplayLanguageCodeException extends TranslateException implements
        ToCopyableBuilder<UnsupportedDisplayLanguageCodeException.Builder, UnsupportedDisplayLanguageCodeException> {
    private static final SdkField<String> DISPLAY_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayLanguageCode").getter(getter(UnsupportedDisplayLanguageCodeException::displayLanguageCode))
            .setter(setter(Builder::displayLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayLanguageCode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_LANGUAGE_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String displayLanguageCode;

    private UnsupportedDisplayLanguageCodeException(BuilderImpl builder) {
        super(builder);
        this.displayLanguageCode = builder.displayLanguageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Language code passed in with the request.
     * </p>
     * 
     * @return Language code passed in with the request.
     */
    public String displayLanguageCode() {
        return displayLanguageCode;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UnsupportedDisplayLanguageCodeException, T> g) {
        return obj -> g.apply((UnsupportedDisplayLanguageCodeException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnsupportedDisplayLanguageCodeException>,
            TranslateException.Builder {
        /**
         * <p>
         * Language code passed in with the request.
         * </p>
         * 
         * @param displayLanguageCode
         *        Language code passed in with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayLanguageCode(String displayLanguageCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends TranslateException.BuilderImpl implements Builder {
        private String displayLanguageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UnsupportedDisplayLanguageCodeException model) {
            super(model);
            displayLanguageCode(model.displayLanguageCode);
        }

        public final String getDisplayLanguageCode() {
            return displayLanguageCode;
        }

        public final void setDisplayLanguageCode(String displayLanguageCode) {
            this.displayLanguageCode = displayLanguageCode;
        }

        @Override
        public final Builder displayLanguageCode(String displayLanguageCode) {
            this.displayLanguageCode = displayLanguageCode;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public UnsupportedDisplayLanguageCodeException build() {
            return new UnsupportedDisplayLanguageCodeException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
