/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WebAppEndpointType {
    PUBLIC("PUBLIC"),
    VPC("VPC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WebAppEndpointType> VALUE_MAP;
    private final String value;

    private WebAppEndpointType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WebAppEndpointType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WebAppEndpointType> knownValues() {
        EnumSet<WebAppEndpointType> knownValues = EnumSet.allOf(WebAppEndpointType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WebAppEndpointType.class, WebAppEndpointType::toString);
    }
}

