/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure for updating the egress configuration of an existing connector. Allows modification of how traffic is
 * routed from the connector to the SFTP server, including VPC_LATTICE settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectorEgressConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateConnectorEgressConfig.Builder, UpdateConnectorEgressConfig> {
    private static final SdkField<UpdateConnectorVpcLatticeEgressConfig> VPC_LATTICE_FIELD = SdkField
            .<UpdateConnectorVpcLatticeEgressConfig> builder(MarshallingType.SDK_POJO).memberName("VpcLattice")
            .getter(getter(UpdateConnectorEgressConfig::vpcLattice)).setter(setter(Builder::vpcLattice))
            .constructor(UpdateConnectorVpcLatticeEgressConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcLattice").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_LATTICE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UpdateConnectorVpcLatticeEgressConfig vpcLattice;

    private final Type type;

    private UpdateConnectorEgressConfig(BuilderImpl builder) {
        this.vpcLattice = builder.vpcLattice;
        this.type = builder.type;
    }

    /**
     * <p>
     * VPC_LATTICE configuration updates for the connector. Use this to modify the Resource Configuration ARN or port
     * number for VPC-based connectivity.
     * </p>
     * 
     * @return VPC_LATTICE configuration updates for the connector. Use this to modify the Resource Configuration ARN or
     *         port number for VPC-based connectivity.
     */
    public final UpdateConnectorVpcLatticeEgressConfig vpcLattice() {
        return vpcLattice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcLattice());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorEgressConfig)) {
            return false;
        }
        UpdateConnectorEgressConfig other = (UpdateConnectorEgressConfig) obj;
        return Objects.equals(vpcLattice(), other.vpcLattice());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectorEgressConfig").add("VpcLattice", vpcLattice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcLattice":
            return Optional.ofNullable(clazz.cast(vpcLattice()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #vpcLattice()} initialized to the given value.
     *
     * <p>
     * VPC_LATTICE configuration updates for the connector. Use this to modify the Resource Configuration ARN or port
     * number for VPC-based connectivity.
     * </p>
     * 
     * @param vpcLattice
     *        VPC_LATTICE configuration updates for the connector. Use this to modify the Resource Configuration ARN or
     *        port number for VPC-based connectivity.
     */
    public static UpdateConnectorEgressConfig fromVpcLattice(UpdateConnectorVpcLatticeEgressConfig vpcLattice) {
        return builder().vpcLattice(vpcLattice).build();
    }

    /**
     * Create an instance of this class with {@link #vpcLattice()} initialized to the given value.
     *
     * <p>
     * VPC_LATTICE configuration updates for the connector. Use this to modify the Resource Configuration ARN or port
     * number for VPC-based connectivity.
     * </p>
     * 
     * @param vpcLattice
     *        VPC_LATTICE configuration updates for the connector. Use this to modify the Resource Configuration ARN or
     *        port number for VPC-based connectivity.
     */
    public static UpdateConnectorEgressConfig fromVpcLattice(Consumer<UpdateConnectorVpcLatticeEgressConfig.Builder> vpcLattice) {
        UpdateConnectorVpcLatticeEgressConfig.Builder builder = UpdateConnectorVpcLatticeEgressConfig.builder();
        vpcLattice.accept(builder);
        return fromVpcLattice(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcLattice", VPC_LATTICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorEgressConfig, T> g) {
        return obj -> g.apply((UpdateConnectorEgressConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateConnectorEgressConfig> {
        /**
         * <p>
         * VPC_LATTICE configuration updates for the connector. Use this to modify the Resource Configuration ARN or
         * port number for VPC-based connectivity.
         * </p>
         * 
         * @param vpcLattice
         *        VPC_LATTICE configuration updates for the connector. Use this to modify the Resource Configuration ARN
         *        or port number for VPC-based connectivity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcLattice(UpdateConnectorVpcLatticeEgressConfig vpcLattice);

        /**
         * <p>
         * VPC_LATTICE configuration updates for the connector. Use this to modify the Resource Configuration ARN or
         * port number for VPC-based connectivity.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateConnectorVpcLatticeEgressConfig.Builder} avoiding the need to create one manually via
         * {@link UpdateConnectorVpcLatticeEgressConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateConnectorVpcLatticeEgressConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcLattice(UpdateConnectorVpcLatticeEgressConfig)}.
         * 
         * @param vpcLattice
         *        a consumer that will call methods on {@link UpdateConnectorVpcLatticeEgressConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcLattice(UpdateConnectorVpcLatticeEgressConfig)
         */
        default Builder vpcLattice(Consumer<UpdateConnectorVpcLatticeEgressConfig.Builder> vpcLattice) {
            return vpcLattice(UpdateConnectorVpcLatticeEgressConfig.builder().applyMutation(vpcLattice).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UpdateConnectorVpcLatticeEgressConfig vpcLattice;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorEgressConfig model) {
            vpcLattice(model.vpcLattice);
        }

        public final UpdateConnectorVpcLatticeEgressConfig.Builder getVpcLattice() {
            return vpcLattice != null ? vpcLattice.toBuilder() : null;
        }

        public final void setVpcLattice(UpdateConnectorVpcLatticeEgressConfig.BuilderImpl vpcLattice) {
            Object oldValue = this.vpcLattice;
            this.vpcLattice = vpcLattice != null ? vpcLattice.build() : null;
            handleUnionValueChange(Type.VPC_LATTICE, oldValue, this.vpcLattice);
        }

        @Override
        public final Builder vpcLattice(UpdateConnectorVpcLatticeEgressConfig vpcLattice) {
            Object oldValue = this.vpcLattice;
            this.vpcLattice = vpcLattice;
            handleUnionValueChange(Type.VPC_LATTICE, oldValue, this.vpcLattice);
            return this;
        }

        @Override
        public UpdateConnectorEgressConfig build() {
            return new UpdateConnectorEgressConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see UpdateConnectorEgressConfig#type()
     */
    public enum Type {
        VPC_LATTICE,

        UNKNOWN_TO_SDK_VERSION
    }
}
