/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDirectoryListingResponse extends TransferResponse implements
        ToCopyableBuilder<StartDirectoryListingResponse.Builder, StartDirectoryListingResponse> {
    private static final SdkField<String> LISTING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ListingId").getter(getter(StartDirectoryListingResponse::listingId)).setter(setter(Builder::listingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListingId").build()).build();

    private static final SdkField<String> OUTPUT_FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputFileName").getter(getter(StartDirectoryListingResponse::outputFileName))
            .setter(setter(Builder::outputFileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFileName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTING_ID_FIELD,
            OUTPUT_FILE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String listingId;

    private final String outputFileName;

    private StartDirectoryListingResponse(BuilderImpl builder) {
        super(builder);
        this.listingId = builder.listingId;
        this.outputFileName = builder.outputFileName;
    }

    /**
     * <p>
     * Returns a unique identifier for the directory listing call.
     * </p>
     * 
     * @return Returns a unique identifier for the directory listing call.
     */
    public final String listingId() {
        return listingId;
    }

    /**
     * <p>
     * Returns the file name where the results are stored. This is a combination of the connector ID and the listing ID:
     * <code>&lt;connector-id&gt;-&lt;listing-id&gt;.json</code>.
     * </p>
     * 
     * @return Returns the file name where the results are stored. This is a combination of the connector ID and the
     *         listing ID: <code>&lt;connector-id&gt;-&lt;listing-id&gt;.json</code>.
     */
    public final String outputFileName() {
        return outputFileName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listingId());
        hashCode = 31 * hashCode + Objects.hashCode(outputFileName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDirectoryListingResponse)) {
            return false;
        }
        StartDirectoryListingResponse other = (StartDirectoryListingResponse) obj;
        return Objects.equals(listingId(), other.listingId()) && Objects.equals(outputFileName(), other.outputFileName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDirectoryListingResponse").add("ListingId", listingId())
                .add("OutputFileName", outputFileName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListingId":
            return Optional.ofNullable(clazz.cast(listingId()));
        case "OutputFileName":
            return Optional.ofNullable(clazz.cast(outputFileName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ListingId", LISTING_ID_FIELD);
        map.put("OutputFileName", OUTPUT_FILE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDirectoryListingResponse, T> g) {
        return obj -> g.apply((StartDirectoryListingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartDirectoryListingResponse> {
        /**
         * <p>
         * Returns a unique identifier for the directory listing call.
         * </p>
         * 
         * @param listingId
         *        Returns a unique identifier for the directory listing call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingId(String listingId);

        /**
         * <p>
         * Returns the file name where the results are stored. This is a combination of the connector ID and the listing
         * ID: <code>&lt;connector-id&gt;-&lt;listing-id&gt;.json</code>.
         * </p>
         * 
         * @param outputFileName
         *        Returns the file name where the results are stored. This is a combination of the connector ID and the
         *        listing ID: <code>&lt;connector-id&gt;-&lt;listing-id&gt;.json</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputFileName(String outputFileName);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String listingId;

        private String outputFileName;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDirectoryListingResponse model) {
            super(model);
            listingId(model.listingId);
            outputFileName(model.outputFileName);
        }

        public final String getListingId() {
            return listingId;
        }

        public final void setListingId(String listingId) {
            this.listingId = listingId;
        }

        @Override
        public final Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public final String getOutputFileName() {
            return outputFileName;
        }

        public final void setOutputFileName(String outputFileName) {
            this.outputFileName = outputFileName;
        }

        @Override
        public final Builder outputFileName(String outputFileName) {
            this.outputFileName = outputFileName;
            return this;
        }

        @Override
        public StartDirectoryListingResponse build() {
            return new StartDirectoryListingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
