/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the details of the IAM Identity Center used for your web app. Returned during a call to
 * <code>DescribeWebApp</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribedIdentityCenterConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribedIdentityCenterConfig.Builder, DescribedIdentityCenterConfig> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationArn").getter(getter(DescribedIdentityCenterConfig::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(DescribedIdentityCenterConfig::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(DescribedIdentityCenterConfig::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            INSTANCE_ARN_FIELD, ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationArn;

    private final String instanceArn;

    private final String role;

    private DescribedIdentityCenterConfig(BuilderImpl builder) {
        this.applicationArn = builder.applicationArn;
        this.instanceArn = builder.instanceArn;
        this.role = builder.role;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the IAM Identity Center application: this value is set automatically when you
     * create your web app.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the IAM Identity Center application: this value is set automatically
     *         when you create your web app.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the IAM Identity Center used for the web app.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the IAM Identity Center used for the web app.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The IAM role in IAM Identity Center used for the web app.
     * </p>
     * 
     * @return The IAM role in IAM Identity Center used for the web app.
     */
    public final String role() {
        return role;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedIdentityCenterConfig)) {
            return false;
        }
        DescribedIdentityCenterConfig other = (DescribedIdentityCenterConfig) obj;
        return Objects.equals(applicationArn(), other.applicationArn()) && Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(role(), other.role());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribedIdentityCenterConfig").add("ApplicationArn", applicationArn())
                .add("InstanceArn", instanceArn()).add("Role", role()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("Role", ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribedIdentityCenterConfig, T> g) {
        return obj -> g.apply((DescribedIdentityCenterConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribedIdentityCenterConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the IAM Identity Center application: this value is set automatically when
         * you create your web app.
         * </p>
         * 
         * @param applicationArn
         *        The Amazon Resource Name (ARN) for the IAM Identity Center application: this value is set
         *        automatically when you create your web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the IAM Identity Center used for the web app.
         * </p>
         * 
         * @param instanceArn
         *        The Amazon Resource Name (ARN) for the IAM Identity Center used for the web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The IAM role in IAM Identity Center used for the web app.
         * </p>
         * 
         * @param role
         *        The IAM role in IAM Identity Center used for the web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);
    }

    static final class BuilderImpl implements Builder {
        private String applicationArn;

        private String instanceArn;

        private String role;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedIdentityCenterConfig model) {
            applicationArn(model.applicationArn);
            instanceArn(model.instanceArn);
            role(model.role);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public DescribedIdentityCenterConfig build() {
            return new DescribedIdentityCenterConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
