/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWebAppResponse extends TransferResponse implements
        ToCopyableBuilder<DescribeWebAppResponse.Builder, DescribeWebAppResponse> {
    private static final SdkField<DescribedWebApp> WEB_APP_FIELD = SdkField.<DescribedWebApp> builder(MarshallingType.SDK_POJO)
            .memberName("WebApp").getter(getter(DescribeWebAppResponse::webApp)).setter(setter(Builder::webApp))
            .constructor(DescribedWebApp::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebApp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_APP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DescribedWebApp webApp;

    private DescribeWebAppResponse(BuilderImpl builder) {
        super(builder);
        this.webApp = builder.webApp;
    }

    /**
     * <p>
     * Returns a structure that contains the details of the web app.
     * </p>
     * 
     * @return Returns a structure that contains the details of the web app.
     */
    public final DescribedWebApp webApp() {
        return webApp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webApp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWebAppResponse)) {
            return false;
        }
        DescribeWebAppResponse other = (DescribeWebAppResponse) obj;
        return Objects.equals(webApp(), other.webApp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWebAppResponse").add("WebApp", webApp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebApp":
            return Optional.ofNullable(clazz.cast(webApp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WebApp", WEB_APP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWebAppResponse, T> g) {
        return obj -> g.apply((DescribeWebAppResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeWebAppResponse> {
        /**
         * <p>
         * Returns a structure that contains the details of the web app.
         * </p>
         * 
         * @param webApp
         *        Returns a structure that contains the details of the web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webApp(DescribedWebApp webApp);

        /**
         * <p>
         * Returns a structure that contains the details of the web app.
         * </p>
         * This is a convenience method that creates an instance of the {@link DescribedWebApp.Builder} avoiding the
         * need to create one manually via {@link DescribedWebApp#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribedWebApp.Builder#build()} is called immediately and its
         * result is passed to {@link #webApp(DescribedWebApp)}.
         * 
         * @param webApp
         *        a consumer that will call methods on {@link DescribedWebApp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webApp(DescribedWebApp)
         */
        default Builder webApp(Consumer<DescribedWebApp.Builder> webApp) {
            return webApp(DescribedWebApp.builder().applyMutation(webApp).build());
        }
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private DescribedWebApp webApp;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWebAppResponse model) {
            super(model);
            webApp(model.webApp);
        }

        public final DescribedWebApp.Builder getWebApp() {
            return webApp != null ? webApp.toBuilder() : null;
        }

        public final void setWebApp(DescribedWebApp.BuilderImpl webApp) {
            this.webApp = webApp != null ? webApp.build() : null;
        }

        @Override
        public final Builder webApp(DescribedWebApp webApp) {
            this.webApp = webApp;
            return this;
        }

        @Override
        public DescribeWebAppResponse build() {
            return new DescribeWebAppResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
