/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.DescribedAccess;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccessResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, DescribeAccessResponse> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(DescribeAccessResponse.getter(DescribeAccessResponse::serverId)).setter(DescribeAccessResponse.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<DescribedAccess> ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Access").getter(DescribeAccessResponse.getter(DescribeAccessResponse::access)).setter(DescribeAccessResponse.setter(Builder::access)).constructor(DescribedAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Access").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD, ACCESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAccessResponse.memberNameToFieldInitializer();
    private final String serverId;
    private final DescribedAccess access;

    private DescribeAccessResponse(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.access = builder.access;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final DescribedAccess access() {
        return this.access;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.access());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccessResponse)) {
            return false;
        }
        DescribeAccessResponse other = (DescribeAccessResponse)((Object)obj);
        return Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.access(), other.access());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAccessResponse").add("ServerId", (Object)this.serverId()).add("Access", (Object)this.access()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "Access": {
                return Optional.ofNullable(clazz.cast(this.access()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServerId", SERVER_ID_FIELD);
        map.put("Access", ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccessResponse, T> g) {
        return obj -> g.apply((DescribeAccessResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String serverId;
        private DescribedAccess access;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccessResponse model) {
            super(model);
            this.serverId(model.serverId);
            this.access(model.access);
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final DescribedAccess.Builder getAccess() {
            return this.access != null ? this.access.toBuilder() : null;
        }

        public final void setAccess(DescribedAccess.BuilderImpl access) {
            this.access = access != null ? access.build() : null;
        }

        @Override
        public final Builder access(DescribedAccess access) {
            this.access = access;
            return this;
        }

        @Override
        public DescribeAccessResponse build() {
            return new DescribeAccessResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccessResponse> {
        public Builder serverId(String var1);

        public Builder access(DescribedAccess var1);

        default public Builder access(Consumer<DescribedAccess.Builder> access) {
            return this.access((DescribedAccess)((DescribedAccess.Builder)DescribedAccess.builder().applyMutation(access)).build());
        }
    }
}

