/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartRemoteMoveRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, StartRemoteMoveRequest> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorId").getter(StartRemoteMoveRequest.getter(StartRemoteMoveRequest::connectorId)).setter(StartRemoteMoveRequest.setter(Builder::connectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()}).build();
    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePath").getter(StartRemoteMoveRequest.getter(StartRemoteMoveRequest::sourcePath)).setter(StartRemoteMoveRequest.setter(Builder::sourcePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePath").build()}).build();
    private static final SdkField<String> TARGET_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetPath").getter(StartRemoteMoveRequest.getter(StartRemoteMoveRequest::targetPath)).setter(StartRemoteMoveRequest.setter(Builder::targetPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD, SOURCE_PATH_FIELD, TARGET_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartRemoteMoveRequest.memberNameToFieldInitializer();
    private final String connectorId;
    private final String sourcePath;
    private final String targetPath;

    private StartRemoteMoveRequest(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.sourcePath = builder.sourcePath;
        this.targetPath = builder.targetPath;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final String sourcePath() {
        return this.sourcePath;
    }

    public final String targetPath() {
        return this.targetPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRemoteMoveRequest)) {
            return false;
        }
        StartRemoteMoveRequest other = (StartRemoteMoveRequest)((Object)obj);
        return Objects.equals(this.connectorId(), other.connectorId()) && Objects.equals(this.sourcePath(), other.sourcePath()) && Objects.equals(this.targetPath(), other.targetPath());
    }

    public final String toString() {
        return ToString.builder((String)"StartRemoteMoveRequest").add("ConnectorId", (Object)this.connectorId()).add("SourcePath", (Object)this.sourcePath()).add("TargetPath", (Object)this.targetPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
            case "SourcePath": {
                return Optional.ofNullable(clazz.cast(this.sourcePath()));
            }
            case "TargetPath": {
                return Optional.ofNullable(clazz.cast(this.targetPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("SourcePath", SOURCE_PATH_FIELD);
        map.put("TargetPath", TARGET_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartRemoteMoveRequest, T> g) {
        return obj -> g.apply((StartRemoteMoveRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String connectorId;
        private String sourcePath;
        private String targetPath;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRemoteMoveRequest model) {
            super(model);
            this.connectorId(model.connectorId);
            this.sourcePath(model.sourcePath);
            this.targetPath(model.targetPath);
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getSourcePath() {
            return this.sourcePath;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final String getTargetPath() {
            return this.targetPath;
        }

        public final void setTargetPath(String targetPath) {
            this.targetPath = targetPath;
        }

        @Override
        public final Builder targetPath(String targetPath) {
            this.targetPath = targetPath;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRemoteMoveRequest build() {
            return new StartRemoteMoveRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartRemoteMoveRequest> {
        public Builder connectorId(String var1);

        public Builder sourcePath(String var1);

        public Builder targetPath(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

