/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartRemoteDeleteRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, StartRemoteDeleteRequest> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorId").getter(StartRemoteDeleteRequest.getter(StartRemoteDeleteRequest::connectorId)).setter(StartRemoteDeleteRequest.setter(Builder::connectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()}).build();
    private static final SdkField<String> DELETE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeletePath").getter(StartRemoteDeleteRequest.getter(StartRemoteDeleteRequest::deletePath)).setter(StartRemoteDeleteRequest.setter(Builder::deletePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD, DELETE_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartRemoteDeleteRequest.memberNameToFieldInitializer();
    private final String connectorId;
    private final String deletePath;

    private StartRemoteDeleteRequest(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.deletePath = builder.deletePath;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final String deletePath() {
        return this.deletePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletePath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRemoteDeleteRequest)) {
            return false;
        }
        StartRemoteDeleteRequest other = (StartRemoteDeleteRequest)((Object)obj);
        return Objects.equals(this.connectorId(), other.connectorId()) && Objects.equals(this.deletePath(), other.deletePath());
    }

    public final String toString() {
        return ToString.builder((String)"StartRemoteDeleteRequest").add("ConnectorId", (Object)this.connectorId()).add("DeletePath", (Object)this.deletePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
            case "DeletePath": {
                return Optional.ofNullable(clazz.cast(this.deletePath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("DeletePath", DELETE_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartRemoteDeleteRequest, T> g) {
        return obj -> g.apply((StartRemoteDeleteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String connectorId;
        private String deletePath;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRemoteDeleteRequest model) {
            super(model);
            this.connectorId(model.connectorId);
            this.deletePath(model.deletePath);
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final String getDeletePath() {
            return this.deletePath;
        }

        public final void setDeletePath(String deletePath) {
            this.deletePath = deletePath;
        }

        @Override
        public final Builder deletePath(String deletePath) {
            this.deletePath = deletePath;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRemoteDeleteRequest build() {
            return new StartRemoteDeleteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartRemoteDeleteRequest> {
        public Builder connectorId(String var1);

        public Builder deletePath(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

