/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.Tag;
import software.amazon.awssdk.services.transfer.model.TagsCopier;
import software.amazon.awssdk.services.transfer.model.WorkflowStep;
import software.amazon.awssdk.services.transfer.model.WorkflowStepsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedWorkflow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedWorkflow> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribedWorkflow.getter(DescribedWorkflow::arn)).setter(DescribedWorkflow.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribedWorkflow.getter(DescribedWorkflow::description)).setter(DescribedWorkflow.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<WorkflowStep>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Steps").getter(DescribedWorkflow.getter(DescribedWorkflow::steps)).setter(DescribedWorkflow.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<WorkflowStep>> ON_EXCEPTION_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OnExceptionSteps").getter(DescribedWorkflow.getter(DescribedWorkflow::onExceptionSteps)).setter(DescribedWorkflow.setter(Builder::onExceptionSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnExceptionSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowId").getter(DescribedWorkflow.getter(DescribedWorkflow::workflowId)).setter(DescribedWorkflow.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(DescribedWorkflow.getter(DescribedWorkflow::tags)).setter(DescribedWorkflow.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD, STEPS_FIELD, ON_EXCEPTION_STEPS_FIELD, WORKFLOW_ID_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribedWorkflow.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String description;
    private final List<WorkflowStep> steps;
    private final List<WorkflowStep> onExceptionSteps;
    private final String workflowId;
    private final List<Tag> tags;

    private DescribedWorkflow(BuilderImpl builder) {
        this.arn = builder.arn;
        this.description = builder.description;
        this.steps = builder.steps;
        this.onExceptionSteps = builder.onExceptionSteps;
        this.workflowId = builder.workflowId;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<WorkflowStep> steps() {
        return this.steps;
    }

    public final boolean hasOnExceptionSteps() {
        return this.onExceptionSteps != null && !(this.onExceptionSteps instanceof SdkAutoConstructList);
    }

    public final List<WorkflowStep> onExceptionSteps() {
        return this.onExceptionSteps;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOnExceptionSteps() ? this.onExceptionSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedWorkflow)) {
            return false;
        }
        DescribedWorkflow other = (DescribedWorkflow)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps()) && this.hasOnExceptionSteps() == other.hasOnExceptionSteps() && Objects.equals(this.onExceptionSteps(), other.onExceptionSteps()) && Objects.equals(this.workflowId(), other.workflowId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedWorkflow").add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("Steps", this.hasSteps() ? this.steps() : null).add("OnExceptionSteps", this.hasOnExceptionSteps() ? this.onExceptionSteps() : null).add("WorkflowId", (Object)this.workflowId()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "OnExceptionSteps": {
                return Optional.ofNullable(clazz.cast(this.onExceptionSteps()));
            }
            case "WorkflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Steps", STEPS_FIELD);
        map.put("OnExceptionSteps", ON_EXCEPTION_STEPS_FIELD);
        map.put("WorkflowId", WORKFLOW_ID_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribedWorkflow, T> g) {
        return obj -> g.apply((DescribedWorkflow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String description;
        private List<WorkflowStep> steps = DefaultSdkAutoConstructList.getInstance();
        private List<WorkflowStep> onExceptionSteps = DefaultSdkAutoConstructList.getInstance();
        private String workflowId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedWorkflow model) {
            this.arn(model.arn);
            this.description(model.description);
            this.steps(model.steps);
            this.onExceptionSteps(model.onExceptionSteps);
            this.workflowId(model.workflowId);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<WorkflowStep.Builder> getSteps() {
            List<WorkflowStep.Builder> result = WorkflowStepsCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<WorkflowStep.BuilderImpl> steps) {
            this.steps = WorkflowStepsCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<WorkflowStep> steps) {
            this.steps = WorkflowStepsCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(WorkflowStep ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<WorkflowStep.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (WorkflowStep)((WorkflowStep.Builder)WorkflowStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WorkflowStep.Builder> getOnExceptionSteps() {
            List<WorkflowStep.Builder> result = WorkflowStepsCopier.copyToBuilder(this.onExceptionSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnExceptionSteps(Collection<WorkflowStep.BuilderImpl> onExceptionSteps) {
            this.onExceptionSteps = WorkflowStepsCopier.copyFromBuilder(onExceptionSteps);
        }

        @Override
        public final Builder onExceptionSteps(Collection<WorkflowStep> onExceptionSteps) {
            this.onExceptionSteps = WorkflowStepsCopier.copy(onExceptionSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onExceptionSteps(WorkflowStep ... onExceptionSteps) {
            this.onExceptionSteps(Arrays.asList(onExceptionSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onExceptionSteps(Consumer<WorkflowStep.Builder> ... onExceptionSteps) {
            this.onExceptionSteps(Stream.of(onExceptionSteps).map(c -> (WorkflowStep)((WorkflowStep.Builder)WorkflowStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DescribedWorkflow build() {
            return new DescribedWorkflow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedWorkflow> {
        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder steps(Collection<WorkflowStep> var1);

        public Builder steps(WorkflowStep ... var1);

        public Builder steps(Consumer<WorkflowStep.Builder> ... var1);

        public Builder onExceptionSteps(Collection<WorkflowStep> var1);

        public Builder onExceptionSteps(WorkflowStep ... var1);

        public Builder onExceptionSteps(Consumer<WorkflowStep.Builder> ... var1);

        public Builder workflowId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

