/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.HomeDirectoryMapEntry;
import software.amazon.awssdk.services.transfer.model.HomeDirectoryMappingsCopier;
import software.amazon.awssdk.services.transfer.model.HomeDirectoryType;
import software.amazon.awssdk.services.transfer.model.PosixProfile;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedAccess
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedAccess> {
    private static final SdkField<String> HOME_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeDirectory").getter(DescribedAccess.getter(DescribedAccess::homeDirectory)).setter(DescribedAccess.setter(Builder::homeDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectory").build()}).build();
    private static final SdkField<List<HomeDirectoryMapEntry>> HOME_DIRECTORY_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HomeDirectoryMappings").getter(DescribedAccess.getter(DescribedAccess::homeDirectoryMappings)).setter(DescribedAccess.setter(Builder::homeDirectoryMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HomeDirectoryMapEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HOME_DIRECTORY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeDirectoryType").getter(DescribedAccess.getter(DescribedAccess::homeDirectoryTypeAsString)).setter(DescribedAccess.setter(Builder::homeDirectoryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryType").build()}).build();
    private static final SdkField<String> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Policy").getter(DescribedAccess.getter(DescribedAccess::policy)).setter(DescribedAccess.setter(Builder::policy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final SdkField<PosixProfile> POSIX_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PosixProfile").getter(DescribedAccess.getter(DescribedAccess::posixProfile)).setter(DescribedAccess.setter(Builder::posixProfile)).constructor(PosixProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixProfile").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(DescribedAccess.getter(DescribedAccess::role)).setter(DescribedAccess.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalId").getter(DescribedAccess.getter(DescribedAccess::externalId)).setter(DescribedAccess.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExternalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOME_DIRECTORY_FIELD, HOME_DIRECTORY_MAPPINGS_FIELD, HOME_DIRECTORY_TYPE_FIELD, POLICY_FIELD, POSIX_PROFILE_FIELD, ROLE_FIELD, EXTERNAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribedAccess.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String homeDirectory;
    private final List<HomeDirectoryMapEntry> homeDirectoryMappings;
    private final String homeDirectoryType;
    private final String policy;
    private final PosixProfile posixProfile;
    private final String role;
    private final String externalId;

    private DescribedAccess(BuilderImpl builder) {
        this.homeDirectory = builder.homeDirectory;
        this.homeDirectoryMappings = builder.homeDirectoryMappings;
        this.homeDirectoryType = builder.homeDirectoryType;
        this.policy = builder.policy;
        this.posixProfile = builder.posixProfile;
        this.role = builder.role;
        this.externalId = builder.externalId;
    }

    public final String homeDirectory() {
        return this.homeDirectory;
    }

    public final boolean hasHomeDirectoryMappings() {
        return this.homeDirectoryMappings != null && !(this.homeDirectoryMappings instanceof SdkAutoConstructList);
    }

    public final List<HomeDirectoryMapEntry> homeDirectoryMappings() {
        return this.homeDirectoryMappings;
    }

    public final HomeDirectoryType homeDirectoryType() {
        return HomeDirectoryType.fromValue(this.homeDirectoryType);
    }

    public final String homeDirectoryTypeAsString() {
        return this.homeDirectoryType;
    }

    public final String policy() {
        return this.policy;
    }

    public final PosixProfile posixProfile() {
        return this.posixProfile;
    }

    public final String role() {
        return this.role;
    }

    public final String externalId() {
        return this.externalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.homeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHomeDirectoryMappings() ? this.homeDirectoryMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.homeDirectoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.posixProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedAccess)) {
            return false;
        }
        DescribedAccess other = (DescribedAccess)obj;
        return Objects.equals(this.homeDirectory(), other.homeDirectory()) && this.hasHomeDirectoryMappings() == other.hasHomeDirectoryMappings() && Objects.equals(this.homeDirectoryMappings(), other.homeDirectoryMappings()) && Objects.equals(this.homeDirectoryTypeAsString(), other.homeDirectoryTypeAsString()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.posixProfile(), other.posixProfile()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.externalId(), other.externalId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedAccess").add("HomeDirectory", (Object)this.homeDirectory()).add("HomeDirectoryMappings", this.hasHomeDirectoryMappings() ? this.homeDirectoryMappings() : null).add("HomeDirectoryType", (Object)this.homeDirectoryTypeAsString()).add("Policy", (Object)this.policy()).add("PosixProfile", (Object)this.posixProfile()).add("Role", (Object)this.role()).add("ExternalId", (Object)this.externalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HomeDirectory": {
                return Optional.ofNullable(clazz.cast(this.homeDirectory()));
            }
            case "HomeDirectoryMappings": {
                return Optional.ofNullable(clazz.cast(this.homeDirectoryMappings()));
            }
            case "HomeDirectoryType": {
                return Optional.ofNullable(clazz.cast(this.homeDirectoryTypeAsString()));
            }
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "PosixProfile": {
                return Optional.ofNullable(clazz.cast(this.posixProfile()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "ExternalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HomeDirectory", HOME_DIRECTORY_FIELD);
        map.put("HomeDirectoryMappings", HOME_DIRECTORY_MAPPINGS_FIELD);
        map.put("HomeDirectoryType", HOME_DIRECTORY_TYPE_FIELD);
        map.put("Policy", POLICY_FIELD);
        map.put("PosixProfile", POSIX_PROFILE_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("ExternalId", EXTERNAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribedAccess, T> g) {
        return obj -> g.apply((DescribedAccess)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String homeDirectory;
        private List<HomeDirectoryMapEntry> homeDirectoryMappings = DefaultSdkAutoConstructList.getInstance();
        private String homeDirectoryType;
        private String policy;
        private PosixProfile posixProfile;
        private String role;
        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedAccess model) {
            this.homeDirectory(model.homeDirectory);
            this.homeDirectoryMappings(model.homeDirectoryMappings);
            this.homeDirectoryType(model.homeDirectoryType);
            this.policy(model.policy);
            this.posixProfile(model.posixProfile);
            this.role(model.role);
            this.externalId(model.externalId);
        }

        public final String getHomeDirectory() {
            return this.homeDirectory;
        }

        public final void setHomeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
        }

        @Override
        public final Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        public final List<HomeDirectoryMapEntry.Builder> getHomeDirectoryMappings() {
            List<HomeDirectoryMapEntry.Builder> result = HomeDirectoryMappingsCopier.copyToBuilder(this.homeDirectoryMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHomeDirectoryMappings(Collection<HomeDirectoryMapEntry.BuilderImpl> homeDirectoryMappings) {
            this.homeDirectoryMappings = HomeDirectoryMappingsCopier.copyFromBuilder(homeDirectoryMappings);
        }

        @Override
        public final Builder homeDirectoryMappings(Collection<HomeDirectoryMapEntry> homeDirectoryMappings) {
            this.homeDirectoryMappings = HomeDirectoryMappingsCopier.copy(homeDirectoryMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder homeDirectoryMappings(HomeDirectoryMapEntry ... homeDirectoryMappings) {
            this.homeDirectoryMappings(Arrays.asList(homeDirectoryMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder homeDirectoryMappings(Consumer<HomeDirectoryMapEntry.Builder> ... homeDirectoryMappings) {
            this.homeDirectoryMappings(Stream.of(homeDirectoryMappings).map(c -> (HomeDirectoryMapEntry)((HomeDirectoryMapEntry.Builder)HomeDirectoryMapEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getHomeDirectoryType() {
            return this.homeDirectoryType;
        }

        public final void setHomeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
        }

        @Override
        public final Builder homeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
            return this;
        }

        @Override
        public final Builder homeDirectoryType(HomeDirectoryType homeDirectoryType) {
            this.homeDirectoryType(homeDirectoryType == null ? null : homeDirectoryType.toString());
            return this;
        }

        public final String getPolicy() {
            return this.policy;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final PosixProfile.Builder getPosixProfile() {
            return this.posixProfile != null ? this.posixProfile.toBuilder() : null;
        }

        public final void setPosixProfile(PosixProfile.BuilderImpl posixProfile) {
            this.posixProfile = posixProfile != null ? posixProfile.build() : null;
        }

        @Override
        public final Builder posixProfile(PosixProfile posixProfile) {
            this.posixProfile = posixProfile;
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public DescribedAccess build() {
            return new DescribedAccess(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedAccess> {
        public Builder homeDirectory(String var1);

        public Builder homeDirectoryMappings(Collection<HomeDirectoryMapEntry> var1);

        public Builder homeDirectoryMappings(HomeDirectoryMapEntry ... var1);

        public Builder homeDirectoryMappings(Consumer<HomeDirectoryMapEntry.Builder> ... var1);

        public Builder homeDirectoryType(String var1);

        public Builder homeDirectoryType(HomeDirectoryType var1);

        public Builder policy(String var1);

        public Builder posixProfile(PosixProfile var1);

        default public Builder posixProfile(Consumer<PosixProfile.Builder> posixProfile) {
            return this.posixProfile((PosixProfile)((PosixProfile.Builder)PosixProfile.builder().applyMutation(posixProfile)).build());
        }

        public Builder role(String var1);

        public Builder externalId(String var1);
    }
}

