/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.EndpointDetails;
import software.amazon.awssdk.services.transfer.model.EndpointType;
import software.amazon.awssdk.services.transfer.model.IdentityProviderDetails;
import software.amazon.awssdk.services.transfer.model.Protocol;
import software.amazon.awssdk.services.transfer.model.ProtocolDetails;
import software.amazon.awssdk.services.transfer.model.ProtocolsCopier;
import software.amazon.awssdk.services.transfer.model.S3StorageOptions;
import software.amazon.awssdk.services.transfer.model.StructuredLogDestinationsCopier;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.services.transfer.model.WorkflowDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServerRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, UpdateServerRequest> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Certificate").getter(UpdateServerRequest.getter(UpdateServerRequest::certificate)).setter(UpdateServerRequest.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<ProtocolDetails> PROTOCOL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProtocolDetails").getter(UpdateServerRequest.getter(UpdateServerRequest::protocolDetails)).setter(UpdateServerRequest.setter(Builder::protocolDetails)).constructor(ProtocolDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtocolDetails").build()}).build();
    private static final SdkField<EndpointDetails> ENDPOINT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointDetails").getter(UpdateServerRequest.getter(UpdateServerRequest::endpointDetails)).setter(UpdateServerRequest.setter(Builder::endpointDetails)).constructor(EndpointDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDetails").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(UpdateServerRequest.getter(UpdateServerRequest::endpointTypeAsString)).setter(UpdateServerRequest.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> HOST_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostKey").getter(UpdateServerRequest.getter(UpdateServerRequest::hostKey)).setter(UpdateServerRequest.setter(Builder::hostKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKey").build()}).build();
    private static final SdkField<IdentityProviderDetails> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityProviderDetails").getter(UpdateServerRequest.getter(UpdateServerRequest::identityProviderDetails)).setter(UpdateServerRequest.setter(Builder::identityProviderDetails)).constructor(IdentityProviderDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderDetails").build()}).build();
    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingRole").getter(UpdateServerRequest.getter(UpdateServerRequest::loggingRole)).setter(UpdateServerRequest.setter(Builder::loggingRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()}).build();
    private static final SdkField<String> POST_AUTHENTICATION_LOGIN_BANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostAuthenticationLoginBanner").getter(UpdateServerRequest.getter(UpdateServerRequest::postAuthenticationLoginBanner)).setter(UpdateServerRequest.setter(Builder::postAuthenticationLoginBanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAuthenticationLoginBanner").build()}).build();
    private static final SdkField<String> PRE_AUTHENTICATION_LOGIN_BANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreAuthenticationLoginBanner").getter(UpdateServerRequest.getter(UpdateServerRequest::preAuthenticationLoginBanner)).setter(UpdateServerRequest.setter(Builder::preAuthenticationLoginBanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreAuthenticationLoginBanner").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(UpdateServerRequest.getter(UpdateServerRequest::protocolsAsStrings)).setter(UpdateServerRequest.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECURITY_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityPolicyName").getter(UpdateServerRequest.getter(UpdateServerRequest::securityPolicyName)).setter(UpdateServerRequest.setter(Builder::securityPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyName").build()}).build();
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(UpdateServerRequest.getter(UpdateServerRequest::serverId)).setter(UpdateServerRequest.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<WorkflowDetails> WORKFLOW_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WorkflowDetails").getter(UpdateServerRequest.getter(UpdateServerRequest::workflowDetails)).setter(UpdateServerRequest.setter(Builder::workflowDetails)).constructor(WorkflowDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowDetails").build()}).build();
    private static final SdkField<List<String>> STRUCTURED_LOG_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StructuredLogDestinations").getter(UpdateServerRequest.getter(UpdateServerRequest::structuredLogDestinations)).setter(UpdateServerRequest.setter(Builder::structuredLogDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StructuredLogDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<S3StorageOptions> S3_STORAGE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3StorageOptions").getter(UpdateServerRequest.getter(UpdateServerRequest::s3StorageOptions)).setter(UpdateServerRequest.setter(Builder::s3StorageOptions)).constructor(S3StorageOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StorageOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, PROTOCOL_DETAILS_FIELD, ENDPOINT_DETAILS_FIELD, ENDPOINT_TYPE_FIELD, HOST_KEY_FIELD, IDENTITY_PROVIDER_DETAILS_FIELD, LOGGING_ROLE_FIELD, POST_AUTHENTICATION_LOGIN_BANNER_FIELD, PRE_AUTHENTICATION_LOGIN_BANNER_FIELD, PROTOCOLS_FIELD, SECURITY_POLICY_NAME_FIELD, SERVER_ID_FIELD, WORKFLOW_DETAILS_FIELD, STRUCTURED_LOG_DESTINATIONS_FIELD, S3_STORAGE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateServerRequest.memberNameToFieldInitializer();
    private final String certificate;
    private final ProtocolDetails protocolDetails;
    private final EndpointDetails endpointDetails;
    private final String endpointType;
    private final String hostKey;
    private final IdentityProviderDetails identityProviderDetails;
    private final String loggingRole;
    private final String postAuthenticationLoginBanner;
    private final String preAuthenticationLoginBanner;
    private final List<String> protocols;
    private final String securityPolicyName;
    private final String serverId;
    private final WorkflowDetails workflowDetails;
    private final List<String> structuredLogDestinations;
    private final S3StorageOptions s3StorageOptions;

    private UpdateServerRequest(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
        this.protocolDetails = builder.protocolDetails;
        this.endpointDetails = builder.endpointDetails;
        this.endpointType = builder.endpointType;
        this.hostKey = builder.hostKey;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.loggingRole = builder.loggingRole;
        this.postAuthenticationLoginBanner = builder.postAuthenticationLoginBanner;
        this.preAuthenticationLoginBanner = builder.preAuthenticationLoginBanner;
        this.protocols = builder.protocols;
        this.securityPolicyName = builder.securityPolicyName;
        this.serverId = builder.serverId;
        this.workflowDetails = builder.workflowDetails;
        this.structuredLogDestinations = builder.structuredLogDestinations;
        this.s3StorageOptions = builder.s3StorageOptions;
    }

    public final String certificate() {
        return this.certificate;
    }

    public final ProtocolDetails protocolDetails() {
        return this.protocolDetails;
    }

    public final EndpointDetails endpointDetails() {
        return this.endpointDetails;
    }

    public final EndpointType endpointType() {
        return EndpointType.fromValue(this.endpointType);
    }

    public final String endpointTypeAsString() {
        return this.endpointType;
    }

    public final String hostKey() {
        return this.hostKey;
    }

    public final IdentityProviderDetails identityProviderDetails() {
        return this.identityProviderDetails;
    }

    public final String loggingRole() {
        return this.loggingRole;
    }

    public final String postAuthenticationLoginBanner() {
        return this.postAuthenticationLoginBanner;
    }

    public final String preAuthenticationLoginBanner() {
        return this.preAuthenticationLoginBanner;
    }

    public final List<Protocol> protocols() {
        return ProtocolsCopier.copyStringToEnum(this.protocols);
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsAsStrings() {
        return this.protocols;
    }

    public final String securityPolicyName() {
        return this.securityPolicyName;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final WorkflowDetails workflowDetails() {
        return this.workflowDetails;
    }

    public final boolean hasStructuredLogDestinations() {
        return this.structuredLogDestinations != null && !(this.structuredLogDestinations instanceof SdkAutoConstructList);
    }

    public final List<String> structuredLogDestinations() {
        return this.structuredLogDestinations;
    }

    public final S3StorageOptions s3StorageOptions() {
        return this.s3StorageOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.postAuthenticationLoginBanner());
        hashCode = 31 * hashCode + Objects.hashCode(this.preAuthenticationLoginBanner());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStructuredLogDestinations() ? this.structuredLogDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.s3StorageOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServerRequest)) {
            return false;
        }
        UpdateServerRequest other = (UpdateServerRequest)((Object)obj);
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.protocolDetails(), other.protocolDetails()) && Objects.equals(this.endpointDetails(), other.endpointDetails()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.hostKey(), other.hostKey()) && Objects.equals(this.identityProviderDetails(), other.identityProviderDetails()) && Objects.equals(this.loggingRole(), other.loggingRole()) && Objects.equals(this.postAuthenticationLoginBanner(), other.postAuthenticationLoginBanner()) && Objects.equals(this.preAuthenticationLoginBanner(), other.preAuthenticationLoginBanner()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings()) && Objects.equals(this.securityPolicyName(), other.securityPolicyName()) && Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.workflowDetails(), other.workflowDetails()) && this.hasStructuredLogDestinations() == other.hasStructuredLogDestinations() && Objects.equals(this.structuredLogDestinations(), other.structuredLogDestinations()) && Objects.equals(this.s3StorageOptions(), other.s3StorageOptions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateServerRequest").add("Certificate", (Object)this.certificate()).add("ProtocolDetails", (Object)this.protocolDetails()).add("EndpointDetails", (Object)this.endpointDetails()).add("EndpointType", (Object)this.endpointTypeAsString()).add("HostKey", (Object)(this.hostKey() == null ? null : "*** Sensitive Data Redacted ***")).add("IdentityProviderDetails", (Object)this.identityProviderDetails()).add("LoggingRole", (Object)this.loggingRole()).add("PostAuthenticationLoginBanner", (Object)this.postAuthenticationLoginBanner()).add("PreAuthenticationLoginBanner", (Object)this.preAuthenticationLoginBanner()).add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).add("SecurityPolicyName", (Object)this.securityPolicyName()).add("ServerId", (Object)this.serverId()).add("WorkflowDetails", (Object)this.workflowDetails()).add("StructuredLogDestinations", this.hasStructuredLogDestinations() ? this.structuredLogDestinations() : null).add("S3StorageOptions", (Object)this.s3StorageOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "ProtocolDetails": {
                return Optional.ofNullable(clazz.cast(this.protocolDetails()));
            }
            case "EndpointDetails": {
                return Optional.ofNullable(clazz.cast(this.endpointDetails()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "HostKey": {
                return Optional.ofNullable(clazz.cast(this.hostKey()));
            }
            case "IdentityProviderDetails": {
                return Optional.ofNullable(clazz.cast(this.identityProviderDetails()));
            }
            case "LoggingRole": {
                return Optional.ofNullable(clazz.cast(this.loggingRole()));
            }
            case "PostAuthenticationLoginBanner": {
                return Optional.ofNullable(clazz.cast(this.postAuthenticationLoginBanner()));
            }
            case "PreAuthenticationLoginBanner": {
                return Optional.ofNullable(clazz.cast(this.preAuthenticationLoginBanner()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
            case "SecurityPolicyName": {
                return Optional.ofNullable(clazz.cast(this.securityPolicyName()));
            }
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "WorkflowDetails": {
                return Optional.ofNullable(clazz.cast(this.workflowDetails()));
            }
            case "StructuredLogDestinations": {
                return Optional.ofNullable(clazz.cast(this.structuredLogDestinations()));
            }
            case "S3StorageOptions": {
                return Optional.ofNullable(clazz.cast(this.s3StorageOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Certificate", CERTIFICATE_FIELD);
        map.put("ProtocolDetails", PROTOCOL_DETAILS_FIELD);
        map.put("EndpointDetails", ENDPOINT_DETAILS_FIELD);
        map.put("EndpointType", ENDPOINT_TYPE_FIELD);
        map.put("HostKey", HOST_KEY_FIELD);
        map.put("IdentityProviderDetails", IDENTITY_PROVIDER_DETAILS_FIELD);
        map.put("LoggingRole", LOGGING_ROLE_FIELD);
        map.put("PostAuthenticationLoginBanner", POST_AUTHENTICATION_LOGIN_BANNER_FIELD);
        map.put("PreAuthenticationLoginBanner", PRE_AUTHENTICATION_LOGIN_BANNER_FIELD);
        map.put("Protocols", PROTOCOLS_FIELD);
        map.put("SecurityPolicyName", SECURITY_POLICY_NAME_FIELD);
        map.put("ServerId", SERVER_ID_FIELD);
        map.put("WorkflowDetails", WORKFLOW_DETAILS_FIELD);
        map.put("StructuredLogDestinations", STRUCTURED_LOG_DESTINATIONS_FIELD);
        map.put("S3StorageOptions", S3_STORAGE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateServerRequest, T> g) {
        return obj -> g.apply((UpdateServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String certificate;
        private ProtocolDetails protocolDetails;
        private EndpointDetails endpointDetails;
        private String endpointType;
        private String hostKey;
        private IdentityProviderDetails identityProviderDetails;
        private String loggingRole;
        private String postAuthenticationLoginBanner;
        private String preAuthenticationLoginBanner;
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();
        private String securityPolicyName;
        private String serverId;
        private WorkflowDetails workflowDetails;
        private List<String> structuredLogDestinations = DefaultSdkAutoConstructList.getInstance();
        private S3StorageOptions s3StorageOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServerRequest model) {
            super(model);
            this.certificate(model.certificate);
            this.protocolDetails(model.protocolDetails);
            this.endpointDetails(model.endpointDetails);
            this.endpointType(model.endpointType);
            this.hostKey(model.hostKey);
            this.identityProviderDetails(model.identityProviderDetails);
            this.loggingRole(model.loggingRole);
            this.postAuthenticationLoginBanner(model.postAuthenticationLoginBanner);
            this.preAuthenticationLoginBanner(model.preAuthenticationLoginBanner);
            this.protocolsWithStrings(model.protocols);
            this.securityPolicyName(model.securityPolicyName);
            this.serverId(model.serverId);
            this.workflowDetails(model.workflowDetails);
            this.structuredLogDestinations(model.structuredLogDestinations);
            this.s3StorageOptions(model.s3StorageOptions);
        }

        public final String getCertificate() {
            return this.certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final ProtocolDetails.Builder getProtocolDetails() {
            return this.protocolDetails != null ? this.protocolDetails.toBuilder() : null;
        }

        public final void setProtocolDetails(ProtocolDetails.BuilderImpl protocolDetails) {
            this.protocolDetails = protocolDetails != null ? protocolDetails.build() : null;
        }

        @Override
        public final Builder protocolDetails(ProtocolDetails protocolDetails) {
            this.protocolDetails = protocolDetails;
            return this;
        }

        public final EndpointDetails.Builder getEndpointDetails() {
            return this.endpointDetails != null ? this.endpointDetails.toBuilder() : null;
        }

        public final void setEndpointDetails(EndpointDetails.BuilderImpl endpointDetails) {
            this.endpointDetails = endpointDetails != null ? endpointDetails.build() : null;
        }

        @Override
        public final Builder endpointDetails(EndpointDetails endpointDetails) {
            this.endpointDetails = endpointDetails;
            return this;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final String getHostKey() {
            return this.hostKey;
        }

        public final void setHostKey(String hostKey) {
            this.hostKey = hostKey;
        }

        @Override
        public final Builder hostKey(String hostKey) {
            this.hostKey = hostKey;
            return this;
        }

        public final IdentityProviderDetails.Builder getIdentityProviderDetails() {
            return this.identityProviderDetails != null ? this.identityProviderDetails.toBuilder() : null;
        }

        public final void setIdentityProviderDetails(IdentityProviderDetails.BuilderImpl identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails != null ? identityProviderDetails.build() : null;
        }

        @Override
        public final Builder identityProviderDetails(IdentityProviderDetails identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        public final String getLoggingRole() {
            return this.loggingRole;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final String getPostAuthenticationLoginBanner() {
            return this.postAuthenticationLoginBanner;
        }

        public final void setPostAuthenticationLoginBanner(String postAuthenticationLoginBanner) {
            this.postAuthenticationLoginBanner = postAuthenticationLoginBanner;
        }

        @Override
        public final Builder postAuthenticationLoginBanner(String postAuthenticationLoginBanner) {
            this.postAuthenticationLoginBanner = postAuthenticationLoginBanner;
            return this;
        }

        public final String getPreAuthenticationLoginBanner() {
            return this.preAuthenticationLoginBanner;
        }

        public final void setPreAuthenticationLoginBanner(String preAuthenticationLoginBanner) {
            this.preAuthenticationLoginBanner = preAuthenticationLoginBanner;
        }

        @Override
        public final Builder preAuthenticationLoginBanner(String preAuthenticationLoginBanner) {
            this.preAuthenticationLoginBanner = preAuthenticationLoginBanner;
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolsCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Protocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final String getSecurityPolicyName() {
            return this.securityPolicyName;
        }

        public final void setSecurityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
        }

        @Override
        public final Builder securityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
            return this;
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final WorkflowDetails.Builder getWorkflowDetails() {
            return this.workflowDetails != null ? this.workflowDetails.toBuilder() : null;
        }

        public final void setWorkflowDetails(WorkflowDetails.BuilderImpl workflowDetails) {
            this.workflowDetails = workflowDetails != null ? workflowDetails.build() : null;
        }

        @Override
        public final Builder workflowDetails(WorkflowDetails workflowDetails) {
            this.workflowDetails = workflowDetails;
            return this;
        }

        public final Collection<String> getStructuredLogDestinations() {
            if (this.structuredLogDestinations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.structuredLogDestinations;
        }

        public final void setStructuredLogDestinations(Collection<String> structuredLogDestinations) {
            this.structuredLogDestinations = StructuredLogDestinationsCopier.copy(structuredLogDestinations);
        }

        @Override
        public final Builder structuredLogDestinations(Collection<String> structuredLogDestinations) {
            this.structuredLogDestinations = StructuredLogDestinationsCopier.copy(structuredLogDestinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder structuredLogDestinations(String ... structuredLogDestinations) {
            this.structuredLogDestinations(Arrays.asList(structuredLogDestinations));
            return this;
        }

        public final S3StorageOptions.Builder getS3StorageOptions() {
            return this.s3StorageOptions != null ? this.s3StorageOptions.toBuilder() : null;
        }

        public final void setS3StorageOptions(S3StorageOptions.BuilderImpl s3StorageOptions) {
            this.s3StorageOptions = s3StorageOptions != null ? s3StorageOptions.build() : null;
        }

        @Override
        public final Builder s3StorageOptions(S3StorageOptions s3StorageOptions) {
            this.s3StorageOptions = s3StorageOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServerRequest build() {
            return new UpdateServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServerRequest> {
        public Builder certificate(String var1);

        public Builder protocolDetails(ProtocolDetails var1);

        default public Builder protocolDetails(Consumer<ProtocolDetails.Builder> protocolDetails) {
            return this.protocolDetails((ProtocolDetails)((ProtocolDetails.Builder)ProtocolDetails.builder().applyMutation(protocolDetails)).build());
        }

        public Builder endpointDetails(EndpointDetails var1);

        default public Builder endpointDetails(Consumer<EndpointDetails.Builder> endpointDetails) {
            return this.endpointDetails((EndpointDetails)((EndpointDetails.Builder)EndpointDetails.builder().applyMutation(endpointDetails)).build());
        }

        public Builder endpointType(String var1);

        public Builder endpointType(EndpointType var1);

        public Builder hostKey(String var1);

        public Builder identityProviderDetails(IdentityProviderDetails var1);

        default public Builder identityProviderDetails(Consumer<IdentityProviderDetails.Builder> identityProviderDetails) {
            return this.identityProviderDetails((IdentityProviderDetails)((IdentityProviderDetails.Builder)IdentityProviderDetails.builder().applyMutation(identityProviderDetails)).build());
        }

        public Builder loggingRole(String var1);

        public Builder postAuthenticationLoginBanner(String var1);

        public Builder preAuthenticationLoginBanner(String var1);

        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<Protocol> var1);

        public Builder protocols(Protocol ... var1);

        public Builder securityPolicyName(String var1);

        public Builder serverId(String var1);

        public Builder workflowDetails(WorkflowDetails var1);

        default public Builder workflowDetails(Consumer<WorkflowDetails.Builder> workflowDetails) {
            return this.workflowDetails((WorkflowDetails)((WorkflowDetails.Builder)WorkflowDetails.builder().applyMutation(workflowDetails)).build());
        }

        public Builder structuredLogDestinations(Collection<String> var1);

        public Builder structuredLogDestinations(String ... var1);

        public Builder s3StorageOptions(S3StorageOptions var1);

        default public Builder s3StorageOptions(Consumer<S3StorageOptions.Builder> s3StorageOptions) {
            return this.s3StorageOptions((S3StorageOptions)((S3StorageOptions.Builder)S3StorageOptions.builder().applyMutation(s3StorageOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

