/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.SecurityPolicyOptionsCopier;
import software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocol;
import software.amazon.awssdk.services.transfer.model.SecurityPolicyProtocolsCopier;
import software.amazon.awssdk.services.transfer.model.SecurityPolicyResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedSecurityPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedSecurityPolicy> {
    private static final SdkField<Boolean> FIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Fips").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::fips)).setter(DescribedSecurityPolicy.setter(Builder::fips)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fips").build()}).build();
    private static final SdkField<String> SECURITY_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityPolicyName").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::securityPolicyName)).setter(DescribedSecurityPolicy.setter(Builder::securityPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyName").build()}).build();
    private static final SdkField<List<String>> SSH_CIPHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SshCiphers").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::sshCiphers)).setter(DescribedSecurityPolicy.setter(Builder::sshCiphers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshCiphers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SSH_KEXS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SshKexs").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::sshKexs)).setter(DescribedSecurityPolicy.setter(Builder::sshKexs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshKexs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SSH_MACS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SshMacs").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::sshMacs)).setter(DescribedSecurityPolicy.setter(Builder::sshMacs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshMacs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TLS_CIPHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TlsCiphers").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::tlsCiphers)).setter(DescribedSecurityPolicy.setter(Builder::tlsCiphers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TlsCiphers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SSH_HOST_KEY_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SshHostKeyAlgorithms").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::sshHostKeyAlgorithms)).setter(DescribedSecurityPolicy.setter(Builder::sshHostKeyAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshHostKeyAlgorithms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::typeAsString)).setter(DescribedSecurityPolicy.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(DescribedSecurityPolicy.getter(DescribedSecurityPolicy::protocolsAsStrings)).setter(DescribedSecurityPolicy.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIPS_FIELD, SECURITY_POLICY_NAME_FIELD, SSH_CIPHERS_FIELD, SSH_KEXS_FIELD, SSH_MACS_FIELD, TLS_CIPHERS_FIELD, SSH_HOST_KEY_ALGORITHMS_FIELD, TYPE_FIELD, PROTOCOLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribedSecurityPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean fips;
    private final String securityPolicyName;
    private final List<String> sshCiphers;
    private final List<String> sshKexs;
    private final List<String> sshMacs;
    private final List<String> tlsCiphers;
    private final List<String> sshHostKeyAlgorithms;
    private final String type;
    private final List<String> protocols;

    private DescribedSecurityPolicy(BuilderImpl builder) {
        this.fips = builder.fips;
        this.securityPolicyName = builder.securityPolicyName;
        this.sshCiphers = builder.sshCiphers;
        this.sshKexs = builder.sshKexs;
        this.sshMacs = builder.sshMacs;
        this.tlsCiphers = builder.tlsCiphers;
        this.sshHostKeyAlgorithms = builder.sshHostKeyAlgorithms;
        this.type = builder.type;
        this.protocols = builder.protocols;
    }

    public final Boolean fips() {
        return this.fips;
    }

    public final String securityPolicyName() {
        return this.securityPolicyName;
    }

    public final boolean hasSshCiphers() {
        return this.sshCiphers != null && !(this.sshCiphers instanceof SdkAutoConstructList);
    }

    public final List<String> sshCiphers() {
        return this.sshCiphers;
    }

    public final boolean hasSshKexs() {
        return this.sshKexs != null && !(this.sshKexs instanceof SdkAutoConstructList);
    }

    public final List<String> sshKexs() {
        return this.sshKexs;
    }

    public final boolean hasSshMacs() {
        return this.sshMacs != null && !(this.sshMacs instanceof SdkAutoConstructList);
    }

    public final List<String> sshMacs() {
        return this.sshMacs;
    }

    public final boolean hasTlsCiphers() {
        return this.tlsCiphers != null && !(this.tlsCiphers instanceof SdkAutoConstructList);
    }

    public final List<String> tlsCiphers() {
        return this.tlsCiphers;
    }

    public final boolean hasSshHostKeyAlgorithms() {
        return this.sshHostKeyAlgorithms != null && !(this.sshHostKeyAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<String> sshHostKeyAlgorithms() {
        return this.sshHostKeyAlgorithms;
    }

    public final SecurityPolicyResourceType type() {
        return SecurityPolicyResourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final List<SecurityPolicyProtocol> protocols() {
        return SecurityPolicyProtocolsCopier.copyStringToEnum(this.protocols);
    }

    public final boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public final List<String> protocolsAsStrings() {
        return this.protocols;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fips());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSshCiphers() ? this.sshCiphers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSshKexs() ? this.sshKexs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSshMacs() ? this.sshMacs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTlsCiphers() ? this.tlsCiphers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSshHostKeyAlgorithms() ? this.sshHostKeyAlgorithms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedSecurityPolicy)) {
            return false;
        }
        DescribedSecurityPolicy other = (DescribedSecurityPolicy)obj;
        return Objects.equals(this.fips(), other.fips()) && Objects.equals(this.securityPolicyName(), other.securityPolicyName()) && this.hasSshCiphers() == other.hasSshCiphers() && Objects.equals(this.sshCiphers(), other.sshCiphers()) && this.hasSshKexs() == other.hasSshKexs() && Objects.equals(this.sshKexs(), other.sshKexs()) && this.hasSshMacs() == other.hasSshMacs() && Objects.equals(this.sshMacs(), other.sshMacs()) && this.hasTlsCiphers() == other.hasTlsCiphers() && Objects.equals(this.tlsCiphers(), other.tlsCiphers()) && this.hasSshHostKeyAlgorithms() == other.hasSshHostKeyAlgorithms() && Objects.equals(this.sshHostKeyAlgorithms(), other.sshHostKeyAlgorithms()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedSecurityPolicy").add("Fips", (Object)this.fips()).add("SecurityPolicyName", (Object)this.securityPolicyName()).add("SshCiphers", this.hasSshCiphers() ? this.sshCiphers() : null).add("SshKexs", this.hasSshKexs() ? this.sshKexs() : null).add("SshMacs", this.hasSshMacs() ? this.sshMacs() : null).add("TlsCiphers", this.hasTlsCiphers() ? this.tlsCiphers() : null).add("SshHostKeyAlgorithms", this.hasSshHostKeyAlgorithms() ? this.sshHostKeyAlgorithms() : null).add("Type", (Object)this.typeAsString()).add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fips": {
                return Optional.ofNullable(clazz.cast(this.fips()));
            }
            case "SecurityPolicyName": {
                return Optional.ofNullable(clazz.cast(this.securityPolicyName()));
            }
            case "SshCiphers": {
                return Optional.ofNullable(clazz.cast(this.sshCiphers()));
            }
            case "SshKexs": {
                return Optional.ofNullable(clazz.cast(this.sshKexs()));
            }
            case "SshMacs": {
                return Optional.ofNullable(clazz.cast(this.sshMacs()));
            }
            case "TlsCiphers": {
                return Optional.ofNullable(clazz.cast(this.tlsCiphers()));
            }
            case "SshHostKeyAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.sshHostKeyAlgorithms()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Fips", FIPS_FIELD);
        map.put("SecurityPolicyName", SECURITY_POLICY_NAME_FIELD);
        map.put("SshCiphers", SSH_CIPHERS_FIELD);
        map.put("SshKexs", SSH_KEXS_FIELD);
        map.put("SshMacs", SSH_MACS_FIELD);
        map.put("TlsCiphers", TLS_CIPHERS_FIELD);
        map.put("SshHostKeyAlgorithms", SSH_HOST_KEY_ALGORITHMS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Protocols", PROTOCOLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribedSecurityPolicy, T> g) {
        return obj -> g.apply((DescribedSecurityPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean fips;
        private String securityPolicyName;
        private List<String> sshCiphers = DefaultSdkAutoConstructList.getInstance();
        private List<String> sshKexs = DefaultSdkAutoConstructList.getInstance();
        private List<String> sshMacs = DefaultSdkAutoConstructList.getInstance();
        private List<String> tlsCiphers = DefaultSdkAutoConstructList.getInstance();
        private List<String> sshHostKeyAlgorithms = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedSecurityPolicy model) {
            this.fips(model.fips);
            this.securityPolicyName(model.securityPolicyName);
            this.sshCiphers(model.sshCiphers);
            this.sshKexs(model.sshKexs);
            this.sshMacs(model.sshMacs);
            this.tlsCiphers(model.tlsCiphers);
            this.sshHostKeyAlgorithms(model.sshHostKeyAlgorithms);
            this.type(model.type);
            this.protocolsWithStrings(model.protocols);
        }

        public final Boolean getFips() {
            return this.fips;
        }

        public final void setFips(Boolean fips) {
            this.fips = fips;
        }

        @Override
        public final Builder fips(Boolean fips) {
            this.fips = fips;
            return this;
        }

        public final String getSecurityPolicyName() {
            return this.securityPolicyName;
        }

        public final void setSecurityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
        }

        @Override
        public final Builder securityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
            return this;
        }

        public final Collection<String> getSshCiphers() {
            if (this.sshCiphers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sshCiphers;
        }

        public final void setSshCiphers(Collection<String> sshCiphers) {
            this.sshCiphers = SecurityPolicyOptionsCopier.copy(sshCiphers);
        }

        @Override
        public final Builder sshCiphers(Collection<String> sshCiphers) {
            this.sshCiphers = SecurityPolicyOptionsCopier.copy(sshCiphers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshCiphers(String ... sshCiphers) {
            this.sshCiphers(Arrays.asList(sshCiphers));
            return this;
        }

        public final Collection<String> getSshKexs() {
            if (this.sshKexs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sshKexs;
        }

        public final void setSshKexs(Collection<String> sshKexs) {
            this.sshKexs = SecurityPolicyOptionsCopier.copy(sshKexs);
        }

        @Override
        public final Builder sshKexs(Collection<String> sshKexs) {
            this.sshKexs = SecurityPolicyOptionsCopier.copy(sshKexs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshKexs(String ... sshKexs) {
            this.sshKexs(Arrays.asList(sshKexs));
            return this;
        }

        public final Collection<String> getSshMacs() {
            if (this.sshMacs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sshMacs;
        }

        public final void setSshMacs(Collection<String> sshMacs) {
            this.sshMacs = SecurityPolicyOptionsCopier.copy(sshMacs);
        }

        @Override
        public final Builder sshMacs(Collection<String> sshMacs) {
            this.sshMacs = SecurityPolicyOptionsCopier.copy(sshMacs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshMacs(String ... sshMacs) {
            this.sshMacs(Arrays.asList(sshMacs));
            return this;
        }

        public final Collection<String> getTlsCiphers() {
            if (this.tlsCiphers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tlsCiphers;
        }

        public final void setTlsCiphers(Collection<String> tlsCiphers) {
            this.tlsCiphers = SecurityPolicyOptionsCopier.copy(tlsCiphers);
        }

        @Override
        public final Builder tlsCiphers(Collection<String> tlsCiphers) {
            this.tlsCiphers = SecurityPolicyOptionsCopier.copy(tlsCiphers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tlsCiphers(String ... tlsCiphers) {
            this.tlsCiphers(Arrays.asList(tlsCiphers));
            return this;
        }

        public final Collection<String> getSshHostKeyAlgorithms() {
            if (this.sshHostKeyAlgorithms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sshHostKeyAlgorithms;
        }

        public final void setSshHostKeyAlgorithms(Collection<String> sshHostKeyAlgorithms) {
            this.sshHostKeyAlgorithms = SecurityPolicyOptionsCopier.copy(sshHostKeyAlgorithms);
        }

        @Override
        public final Builder sshHostKeyAlgorithms(Collection<String> sshHostKeyAlgorithms) {
            this.sshHostKeyAlgorithms = SecurityPolicyOptionsCopier.copy(sshHostKeyAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshHostKeyAlgorithms(String ... sshHostKeyAlgorithms) {
            this.sshHostKeyAlgorithms(Arrays.asList(sshHostKeyAlgorithms));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SecurityPolicyResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = SecurityPolicyProtocolsCopier.copy(protocols);
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = SecurityPolicyProtocolsCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<SecurityPolicyProtocol> protocols) {
            this.protocols = SecurityPolicyProtocolsCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(SecurityPolicyProtocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public DescribedSecurityPolicy build() {
            return new DescribedSecurityPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedSecurityPolicy> {
        public Builder fips(Boolean var1);

        public Builder securityPolicyName(String var1);

        public Builder sshCiphers(Collection<String> var1);

        public Builder sshCiphers(String ... var1);

        public Builder sshKexs(Collection<String> var1);

        public Builder sshKexs(String ... var1);

        public Builder sshMacs(Collection<String> var1);

        public Builder sshMacs(String ... var1);

        public Builder tlsCiphers(Collection<String> var1);

        public Builder tlsCiphers(String ... var1);

        public Builder sshHostKeyAlgorithms(Collection<String> var1);

        public Builder sshHostKeyAlgorithms(String ... var1);

        public Builder type(String var1);

        public Builder type(SecurityPolicyResourceType var1);

        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<SecurityPolicyProtocol> var1);

        public Builder protocols(SecurityPolicyProtocol ... var1);
    }
}

