/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.FilePathsCopier;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartFileTransferRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, StartFileTransferRequest> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorId").getter(StartFileTransferRequest.getter(StartFileTransferRequest::connectorId)).setter(StartFileTransferRequest.setter(Builder::connectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()}).build();
    private static final SdkField<List<String>> SEND_FILE_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SendFilePaths").getter(StartFileTransferRequest.getter(StartFileTransferRequest::sendFilePaths)).setter(StartFileTransferRequest.setter(Builder::sendFilePaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendFilePaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RETRIEVE_FILE_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RetrieveFilePaths").getter(StartFileTransferRequest.getter(StartFileTransferRequest::retrieveFilePaths)).setter(StartFileTransferRequest.setter(Builder::retrieveFilePaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrieveFilePaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOCAL_DIRECTORY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalDirectoryPath").getter(StartFileTransferRequest.getter(StartFileTransferRequest::localDirectoryPath)).setter(StartFileTransferRequest.setter(Builder::localDirectoryPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDirectoryPath").build()}).build();
    private static final SdkField<String> REMOTE_DIRECTORY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RemoteDirectoryPath").getter(StartFileTransferRequest.getter(StartFileTransferRequest::remoteDirectoryPath)).setter(StartFileTransferRequest.setter(Builder::remoteDirectoryPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDirectoryPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD, SEND_FILE_PATHS_FIELD, RETRIEVE_FILE_PATHS_FIELD, LOCAL_DIRECTORY_PATH_FIELD, REMOTE_DIRECTORY_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartFileTransferRequest.memberNameToFieldInitializer();
    private final String connectorId;
    private final List<String> sendFilePaths;
    private final List<String> retrieveFilePaths;
    private final String localDirectoryPath;
    private final String remoteDirectoryPath;

    private StartFileTransferRequest(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.sendFilePaths = builder.sendFilePaths;
        this.retrieveFilePaths = builder.retrieveFilePaths;
        this.localDirectoryPath = builder.localDirectoryPath;
        this.remoteDirectoryPath = builder.remoteDirectoryPath;
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final boolean hasSendFilePaths() {
        return this.sendFilePaths != null && !(this.sendFilePaths instanceof SdkAutoConstructList);
    }

    public final List<String> sendFilePaths() {
        return this.sendFilePaths;
    }

    public final boolean hasRetrieveFilePaths() {
        return this.retrieveFilePaths != null && !(this.retrieveFilePaths instanceof SdkAutoConstructList);
    }

    public final List<String> retrieveFilePaths() {
        return this.retrieveFilePaths;
    }

    public final String localDirectoryPath() {
        return this.localDirectoryPath;
    }

    public final String remoteDirectoryPath() {
        return this.remoteDirectoryPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSendFilePaths() ? this.sendFilePaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRetrieveFilePaths() ? this.retrieveFilePaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.localDirectoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDirectoryPath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFileTransferRequest)) {
            return false;
        }
        StartFileTransferRequest other = (StartFileTransferRequest)((Object)obj);
        return Objects.equals(this.connectorId(), other.connectorId()) && this.hasSendFilePaths() == other.hasSendFilePaths() && Objects.equals(this.sendFilePaths(), other.sendFilePaths()) && this.hasRetrieveFilePaths() == other.hasRetrieveFilePaths() && Objects.equals(this.retrieveFilePaths(), other.retrieveFilePaths()) && Objects.equals(this.localDirectoryPath(), other.localDirectoryPath()) && Objects.equals(this.remoteDirectoryPath(), other.remoteDirectoryPath());
    }

    public final String toString() {
        return ToString.builder((String)"StartFileTransferRequest").add("ConnectorId", (Object)this.connectorId()).add("SendFilePaths", this.hasSendFilePaths() ? this.sendFilePaths() : null).add("RetrieveFilePaths", this.hasRetrieveFilePaths() ? this.retrieveFilePaths() : null).add("LocalDirectoryPath", (Object)this.localDirectoryPath()).add("RemoteDirectoryPath", (Object)this.remoteDirectoryPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorId": {
                return Optional.ofNullable(clazz.cast(this.connectorId()));
            }
            case "SendFilePaths": {
                return Optional.ofNullable(clazz.cast(this.sendFilePaths()));
            }
            case "RetrieveFilePaths": {
                return Optional.ofNullable(clazz.cast(this.retrieveFilePaths()));
            }
            case "LocalDirectoryPath": {
                return Optional.ofNullable(clazz.cast(this.localDirectoryPath()));
            }
            case "RemoteDirectoryPath": {
                return Optional.ofNullable(clazz.cast(this.remoteDirectoryPath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConnectorId", CONNECTOR_ID_FIELD);
        map.put("SendFilePaths", SEND_FILE_PATHS_FIELD);
        map.put("RetrieveFilePaths", RETRIEVE_FILE_PATHS_FIELD);
        map.put("LocalDirectoryPath", LOCAL_DIRECTORY_PATH_FIELD);
        map.put("RemoteDirectoryPath", REMOTE_DIRECTORY_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartFileTransferRequest, T> g) {
        return obj -> g.apply((StartFileTransferRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String connectorId;
        private List<String> sendFilePaths = DefaultSdkAutoConstructList.getInstance();
        private List<String> retrieveFilePaths = DefaultSdkAutoConstructList.getInstance();
        private String localDirectoryPath;
        private String remoteDirectoryPath;

        private BuilderImpl() {
        }

        private BuilderImpl(StartFileTransferRequest model) {
            super(model);
            this.connectorId(model.connectorId);
            this.sendFilePaths(model.sendFilePaths);
            this.retrieveFilePaths(model.retrieveFilePaths);
            this.localDirectoryPath(model.localDirectoryPath);
            this.remoteDirectoryPath(model.remoteDirectoryPath);
        }

        public final String getConnectorId() {
            return this.connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final Collection<String> getSendFilePaths() {
            if (this.sendFilePaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sendFilePaths;
        }

        public final void setSendFilePaths(Collection<String> sendFilePaths) {
            this.sendFilePaths = FilePathsCopier.copy(sendFilePaths);
        }

        @Override
        public final Builder sendFilePaths(Collection<String> sendFilePaths) {
            this.sendFilePaths = FilePathsCopier.copy(sendFilePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendFilePaths(String ... sendFilePaths) {
            this.sendFilePaths(Arrays.asList(sendFilePaths));
            return this;
        }

        public final Collection<String> getRetrieveFilePaths() {
            if (this.retrieveFilePaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.retrieveFilePaths;
        }

        public final void setRetrieveFilePaths(Collection<String> retrieveFilePaths) {
            this.retrieveFilePaths = FilePathsCopier.copy(retrieveFilePaths);
        }

        @Override
        public final Builder retrieveFilePaths(Collection<String> retrieveFilePaths) {
            this.retrieveFilePaths = FilePathsCopier.copy(retrieveFilePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrieveFilePaths(String ... retrieveFilePaths) {
            this.retrieveFilePaths(Arrays.asList(retrieveFilePaths));
            return this;
        }

        public final String getLocalDirectoryPath() {
            return this.localDirectoryPath;
        }

        public final void setLocalDirectoryPath(String localDirectoryPath) {
            this.localDirectoryPath = localDirectoryPath;
        }

        @Override
        public final Builder localDirectoryPath(String localDirectoryPath) {
            this.localDirectoryPath = localDirectoryPath;
            return this;
        }

        public final String getRemoteDirectoryPath() {
            return this.remoteDirectoryPath;
        }

        public final void setRemoteDirectoryPath(String remoteDirectoryPath) {
            this.remoteDirectoryPath = remoteDirectoryPath;
        }

        @Override
        public final Builder remoteDirectoryPath(String remoteDirectoryPath) {
            this.remoteDirectoryPath = remoteDirectoryPath;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartFileTransferRequest build() {
            return new StartFileTransferRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartFileTransferRequest> {
        public Builder connectorId(String var1);

        public Builder sendFilePaths(Collection<String> var1);

        public Builder sendFilePaths(String ... var1);

        public Builder retrieveFilePaths(Collection<String> var1);

        public Builder retrieveFilePaths(String ... var1);

        public Builder localDirectoryPath(String var1);

        public Builder remoteDirectoryPath(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

