/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.OnPartialUploadWorkflowDetailsCopier;
import software.amazon.awssdk.services.transfer.model.OnUploadWorkflowDetailsCopier;
import software.amazon.awssdk.services.transfer.model.WorkflowDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowDetails> {
    private static final SdkField<List<WorkflowDetail>> ON_UPLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OnUpload").getter(WorkflowDetails.getter(WorkflowDetails::onUpload)).setter(WorkflowDetails.setter(Builder::onUpload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnUpload").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<WorkflowDetail>> ON_PARTIAL_UPLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OnPartialUpload").getter(WorkflowDetails.getter(WorkflowDetails::onPartialUpload)).setter(WorkflowDetails.setter(Builder::onPartialUpload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPartialUpload").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ON_UPLOAD_FIELD, ON_PARTIAL_UPLOAD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OnUpload", ON_UPLOAD_FIELD);
            this.put("OnPartialUpload", ON_PARTIAL_UPLOAD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<WorkflowDetail> onUpload;
    private final List<WorkflowDetail> onPartialUpload;

    private WorkflowDetails(BuilderImpl builder) {
        this.onUpload = builder.onUpload;
        this.onPartialUpload = builder.onPartialUpload;
    }

    public final boolean hasOnUpload() {
        return this.onUpload != null && !(this.onUpload instanceof SdkAutoConstructList);
    }

    public final List<WorkflowDetail> onUpload() {
        return this.onUpload;
    }

    public final boolean hasOnPartialUpload() {
        return this.onPartialUpload != null && !(this.onPartialUpload instanceof SdkAutoConstructList);
    }

    public final List<WorkflowDetail> onPartialUpload() {
        return this.onPartialUpload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOnUpload() ? this.onUpload() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOnPartialUpload() ? this.onPartialUpload() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowDetails)) {
            return false;
        }
        WorkflowDetails other = (WorkflowDetails)obj;
        return this.hasOnUpload() == other.hasOnUpload() && Objects.equals(this.onUpload(), other.onUpload()) && this.hasOnPartialUpload() == other.hasOnPartialUpload() && Objects.equals(this.onPartialUpload(), other.onPartialUpload());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowDetails").add("OnUpload", this.hasOnUpload() ? this.onUpload() : null).add("OnPartialUpload", this.hasOnPartialUpload() ? this.onPartialUpload() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OnUpload": {
                return Optional.ofNullable(clazz.cast(this.onUpload()));
            }
            case "OnPartialUpload": {
                return Optional.ofNullable(clazz.cast(this.onPartialUpload()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowDetails, T> g) {
        return obj -> g.apply((WorkflowDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<WorkflowDetail> onUpload = DefaultSdkAutoConstructList.getInstance();
        private List<WorkflowDetail> onPartialUpload = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowDetails model) {
            this.onUpload(model.onUpload);
            this.onPartialUpload(model.onPartialUpload);
        }

        public final List<WorkflowDetail.Builder> getOnUpload() {
            List<WorkflowDetail.Builder> result = OnUploadWorkflowDetailsCopier.copyToBuilder(this.onUpload);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnUpload(Collection<WorkflowDetail.BuilderImpl> onUpload) {
            this.onUpload = OnUploadWorkflowDetailsCopier.copyFromBuilder(onUpload);
        }

        @Override
        public final Builder onUpload(Collection<WorkflowDetail> onUpload) {
            this.onUpload = OnUploadWorkflowDetailsCopier.copy(onUpload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onUpload(WorkflowDetail ... onUpload) {
            this.onUpload(Arrays.asList(onUpload));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onUpload(Consumer<WorkflowDetail.Builder> ... onUpload) {
            this.onUpload(Stream.of(onUpload).map(c -> (WorkflowDetail)((WorkflowDetail.Builder)WorkflowDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<WorkflowDetail.Builder> getOnPartialUpload() {
            List<WorkflowDetail.Builder> result = OnPartialUploadWorkflowDetailsCopier.copyToBuilder(this.onPartialUpload);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnPartialUpload(Collection<WorkflowDetail.BuilderImpl> onPartialUpload) {
            this.onPartialUpload = OnPartialUploadWorkflowDetailsCopier.copyFromBuilder(onPartialUpload);
        }

        @Override
        public final Builder onPartialUpload(Collection<WorkflowDetail> onPartialUpload) {
            this.onPartialUpload = OnPartialUploadWorkflowDetailsCopier.copy(onPartialUpload);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPartialUpload(WorkflowDetail ... onPartialUpload) {
            this.onPartialUpload(Arrays.asList(onPartialUpload));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPartialUpload(Consumer<WorkflowDetail.Builder> ... onPartialUpload) {
            this.onPartialUpload(Stream.of(onPartialUpload).map(c -> (WorkflowDetail)((WorkflowDetail.Builder)WorkflowDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public WorkflowDetails build() {
            return new WorkflowDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowDetails> {
        public Builder onUpload(Collection<WorkflowDetail> var1);

        public Builder onUpload(WorkflowDetail ... var1);

        public Builder onUpload(Consumer<WorkflowDetail.Builder> ... var1);

        public Builder onPartialUpload(Collection<WorkflowDetail> var1);

        public Builder onPartialUpload(WorkflowDetail ... var1);

        public Builder onPartialUpload(Consumer<WorkflowDetail.Builder> ... var1);
    }
}

