/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.ListedCertificate;
import software.amazon.awssdk.services.transfer.model.ListedCertificatesCopier;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCertificatesResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, ListCertificatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCertificatesResponse.getter(ListCertificatesResponse::nextToken)).setter(ListCertificatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ListedCertificate>> CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Certificates").getter(ListCertificatesResponse.getter(ListCertificatesResponse::certificates)).setter(ListCertificatesResponse.setter(Builder::certificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CERTIFICATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Certificates", CERTIFICATES_FIELD);
        }
    });
    private final String nextToken;
    private final List<ListedCertificate> certificates;

    private ListCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.certificates = builder.certificates;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCertificates() {
        return this.certificates != null && !(this.certificates instanceof SdkAutoConstructList);
    }

    public final List<ListedCertificate> certificates() {
        return this.certificates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCertificates() ? this.certificates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesResponse)) {
            return false;
        }
        ListCertificatesResponse other = (ListCertificatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCertificates() == other.hasCertificates() && Objects.equals(this.certificates(), other.certificates());
    }

    public final String toString() {
        return ToString.builder((String)"ListCertificatesResponse").add("NextToken", (Object)this.nextToken()).add("Certificates", this.hasCertificates() ? this.certificates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Certificates": {
                return Optional.ofNullable(clazz.cast(this.certificates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCertificatesResponse, T> g) {
        return obj -> g.apply((ListCertificatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListedCertificate> certificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.certificates(model.certificates);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListedCertificate.Builder> getCertificates() {
            List<ListedCertificate.Builder> result = ListedCertificatesCopier.copyToBuilder(this.certificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCertificates(Collection<ListedCertificate.BuilderImpl> certificates) {
            this.certificates = ListedCertificatesCopier.copyFromBuilder(certificates);
        }

        @Override
        public final Builder certificates(Collection<ListedCertificate> certificates) {
            this.certificates = ListedCertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(ListedCertificate ... certificates) {
            this.certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<ListedCertificate.Builder> ... certificates) {
            this.certificates(Stream.of(certificates).map(c -> (ListedCertificate)((ListedCertificate.Builder)ListedCertificate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCertificatesResponse build() {
            return new ListCertificatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCertificatesResponse> {
        public Builder nextToken(String var1);

        public Builder certificates(Collection<ListedCertificate> var1);

        public Builder certificates(ListedCertificate ... var1);

        public Builder certificates(Consumer<ListedCertificate.Builder> ... var1);
    }
}

