/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.AgreementStatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedAgreement
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedAgreement> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListedAgreement.getter(ListedAgreement::arn)).setter(ListedAgreement.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> AGREEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AgreementId").getter(ListedAgreement.getter(ListedAgreement::agreementId)).setter(ListedAgreement.setter(Builder::agreementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgreementId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ListedAgreement.getter(ListedAgreement::description)).setter(ListedAgreement.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListedAgreement.getter(ListedAgreement::statusAsString)).setter(ListedAgreement.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(ListedAgreement.getter(ListedAgreement::serverId)).setter(ListedAgreement.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<String> LOCAL_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalProfileId").getter(ListedAgreement.getter(ListedAgreement::localProfileId)).setter(ListedAgreement.setter(Builder::localProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalProfileId").build()}).build();
    private static final SdkField<String> PARTNER_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerProfileId").getter(ListedAgreement.getter(ListedAgreement::partnerProfileId)).setter(ListedAgreement.setter(Builder::partnerProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerProfileId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AGREEMENT_ID_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, SERVER_ID_FIELD, LOCAL_PROFILE_ID_FIELD, PARTNER_PROFILE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("AgreementId", AGREEMENT_ID_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("ServerId", SERVER_ID_FIELD);
            this.put("LocalProfileId", LOCAL_PROFILE_ID_FIELD);
            this.put("PartnerProfileId", PARTNER_PROFILE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String agreementId;
    private final String description;
    private final String status;
    private final String serverId;
    private final String localProfileId;
    private final String partnerProfileId;

    private ListedAgreement(BuilderImpl builder) {
        this.arn = builder.arn;
        this.agreementId = builder.agreementId;
        this.description = builder.description;
        this.status = builder.status;
        this.serverId = builder.serverId;
        this.localProfileId = builder.localProfileId;
        this.partnerProfileId = builder.partnerProfileId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String agreementId() {
        return this.agreementId;
    }

    public final String description() {
        return this.description;
    }

    public final AgreementStatusType status() {
        return AgreementStatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final String localProfileId() {
        return this.localProfileId;
    }

    public final String partnerProfileId() {
        return this.partnerProfileId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.agreementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.localProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerProfileId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedAgreement)) {
            return false;
        }
        ListedAgreement other = (ListedAgreement)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.agreementId(), other.agreementId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.serverId(), other.serverId()) && Objects.equals(this.localProfileId(), other.localProfileId()) && Objects.equals(this.partnerProfileId(), other.partnerProfileId());
    }

    public final String toString() {
        return ToString.builder((String)"ListedAgreement").add("Arn", (Object)this.arn()).add("AgreementId", (Object)this.agreementId()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("ServerId", (Object)this.serverId()).add("LocalProfileId", (Object)this.localProfileId()).add("PartnerProfileId", (Object)this.partnerProfileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AgreementId": {
                return Optional.ofNullable(clazz.cast(this.agreementId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "LocalProfileId": {
                return Optional.ofNullable(clazz.cast(this.localProfileId()));
            }
            case "PartnerProfileId": {
                return Optional.ofNullable(clazz.cast(this.partnerProfileId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListedAgreement, T> g) {
        return obj -> g.apply((ListedAgreement)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String agreementId;
        private String description;
        private String status;
        private String serverId;
        private String localProfileId;
        private String partnerProfileId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedAgreement model) {
            this.arn(model.arn);
            this.agreementId(model.agreementId);
            this.description(model.description);
            this.status(model.status);
            this.serverId(model.serverId);
            this.localProfileId(model.localProfileId);
            this.partnerProfileId(model.partnerProfileId);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAgreementId() {
            return this.agreementId;
        }

        public final void setAgreementId(String agreementId) {
            this.agreementId = agreementId;
        }

        @Override
        public final Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgreementStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getLocalProfileId() {
            return this.localProfileId;
        }

        public final void setLocalProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
        }

        @Override
        public final Builder localProfileId(String localProfileId) {
            this.localProfileId = localProfileId;
            return this;
        }

        public final String getPartnerProfileId() {
            return this.partnerProfileId;
        }

        public final void setPartnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
        }

        @Override
        public final Builder partnerProfileId(String partnerProfileId) {
            this.partnerProfileId = partnerProfileId;
            return this;
        }

        public ListedAgreement build() {
            return new ListedAgreement(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedAgreement> {
        public Builder arn(String var1);

        public Builder agreementId(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(AgreementStatusType var1);

        public Builder serverId(String var1);

        public Builder localProfileId(String var1);

        public Builder partnerProfileId(String var1);
    }
}

