/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateWebAppCustomizationRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, UpdateWebAppCustomizationRequest> {
    private static final SdkField<String> WEB_APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebAppId").getter(UpdateWebAppCustomizationRequest.getter(UpdateWebAppCustomizationRequest::webAppId)).setter(UpdateWebAppCustomizationRequest.setter(Builder::webAppId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(UpdateWebAppCustomizationRequest.getter(UpdateWebAppCustomizationRequest::title)).setter(UpdateWebAppCustomizationRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<SdkBytes> LOGO_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("LogoFile").getter(UpdateWebAppCustomizationRequest.getter(UpdateWebAppCustomizationRequest::logoFile)).setter(UpdateWebAppCustomizationRequest.setter(Builder::logoFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoFile").build()}).build();
    private static final SdkField<SdkBytes> FAVICON_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("FaviconFile").getter(UpdateWebAppCustomizationRequest.getter(UpdateWebAppCustomizationRequest::faviconFile)).setter(UpdateWebAppCustomizationRequest.setter(Builder::faviconFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaviconFile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_APP_ID_FIELD, TITLE_FIELD, LOGO_FILE_FIELD, FAVICON_FILE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WebAppId", WEB_APP_ID_FIELD);
            this.put("Title", TITLE_FIELD);
            this.put("LogoFile", LOGO_FILE_FIELD);
            this.put("FaviconFile", FAVICON_FILE_FIELD);
        }
    });
    private final String webAppId;
    private final String title;
    private final SdkBytes logoFile;
    private final SdkBytes faviconFile;

    private UpdateWebAppCustomizationRequest(BuilderImpl builder) {
        super(builder);
        this.webAppId = builder.webAppId;
        this.title = builder.title;
        this.logoFile = builder.logoFile;
        this.faviconFile = builder.faviconFile;
    }

    public final String webAppId() {
        return this.webAppId;
    }

    public final String title() {
        return this.title;
    }

    public final SdkBytes logoFile() {
        return this.logoFile;
    }

    public final SdkBytes faviconFile() {
        return this.faviconFile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.webAppId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.logoFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.faviconFile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebAppCustomizationRequest)) {
            return false;
        }
        UpdateWebAppCustomizationRequest other = (UpdateWebAppCustomizationRequest)((Object)obj);
        return Objects.equals(this.webAppId(), other.webAppId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.logoFile(), other.logoFile()) && Objects.equals(this.faviconFile(), other.faviconFile());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateWebAppCustomizationRequest").add("WebAppId", (Object)this.webAppId()).add("Title", (Object)this.title()).add("LogoFile", (Object)(this.logoFile() == null ? null : "*** Sensitive Data Redacted ***")).add("FaviconFile", (Object)(this.faviconFile() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebAppId": {
                return Optional.ofNullable(clazz.cast(this.webAppId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "LogoFile": {
                return Optional.ofNullable(clazz.cast(this.logoFile()));
            }
            case "FaviconFile": {
                return Optional.ofNullable(clazz.cast(this.faviconFile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebAppCustomizationRequest, T> g) {
        return obj -> g.apply((UpdateWebAppCustomizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String webAppId;
        private String title;
        private SdkBytes logoFile;
        private SdkBytes faviconFile;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebAppCustomizationRequest model) {
            super(model);
            this.webAppId(model.webAppId);
            this.title(model.title);
            this.logoFile(model.logoFile);
            this.faviconFile(model.faviconFile);
        }

        public final String getWebAppId() {
            return this.webAppId;
        }

        public final void setWebAppId(String webAppId) {
            this.webAppId = webAppId;
        }

        @Override
        public final Builder webAppId(String webAppId) {
            this.webAppId = webAppId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final ByteBuffer getLogoFile() {
            return this.logoFile == null ? null : this.logoFile.asByteBuffer();
        }

        public final void setLogoFile(ByteBuffer logoFile) {
            this.logoFile(logoFile == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)logoFile));
        }

        @Override
        public final Builder logoFile(SdkBytes logoFile) {
            this.logoFile = logoFile;
            return this;
        }

        public final ByteBuffer getFaviconFile() {
            return this.faviconFile == null ? null : this.faviconFile.asByteBuffer();
        }

        public final void setFaviconFile(ByteBuffer faviconFile) {
            this.faviconFile(faviconFile == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)faviconFile));
        }

        @Override
        public final Builder faviconFile(SdkBytes faviconFile) {
            this.faviconFile = faviconFile;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebAppCustomizationRequest build() {
            return new UpdateWebAppCustomizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateWebAppCustomizationRequest> {
        public Builder webAppId(String var1);

        public Builder title(String var1);

        public Builder logoFile(SdkBytes var1);

        public Builder faviconFile(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

