/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.ListedHostKey;
import software.amazon.awssdk.services.transfer.model.ListedHostKeysCopier;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHostKeysResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, ListHostKeysResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHostKeysResponse.getter(ListHostKeysResponse::nextToken)).setter(ListHostKeysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(ListHostKeysResponse.getter(ListHostKeysResponse::serverId)).setter(ListHostKeysResponse.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final SdkField<List<ListedHostKey>> HOST_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HostKeys").getter(ListHostKeysResponse.getter(ListHostKeysResponse::hostKeys)).setter(ListHostKeysResponse.setter(Builder::hostKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedHostKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVER_ID_FIELD, HOST_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("ServerId", SERVER_ID_FIELD);
            this.put("HostKeys", HOST_KEYS_FIELD);
        }
    });
    private final String nextToken;
    private final String serverId;
    private final List<ListedHostKey> hostKeys;

    private ListHostKeysResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serverId = builder.serverId;
        this.hostKeys = builder.hostKeys;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String serverId() {
        return this.serverId;
    }

    public final boolean hasHostKeys() {
        return this.hostKeys != null && !(this.hostKeys instanceof SdkAutoConstructList);
    }

    public final List<ListedHostKey> hostKeys() {
        return this.hostKeys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHostKeys() ? this.hostKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostKeysResponse)) {
            return false;
        }
        ListHostKeysResponse other = (ListHostKeysResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.serverId(), other.serverId()) && this.hasHostKeys() == other.hasHostKeys() && Objects.equals(this.hostKeys(), other.hostKeys());
    }

    public final String toString() {
        return ToString.builder((String)"ListHostKeysResponse").add("NextToken", (Object)this.nextToken()).add("ServerId", (Object)this.serverId()).add("HostKeys", this.hasHostKeys() ? this.hostKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
            case "HostKeys": {
                return Optional.ofNullable(clazz.cast(this.hostKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListHostKeysResponse, T> g) {
        return obj -> g.apply((ListHostKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private String serverId;
        private List<ListedHostKey> hostKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostKeysResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.serverId(model.serverId);
            this.hostKeys(model.hostKeys);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final List<ListedHostKey.Builder> getHostKeys() {
            List<ListedHostKey.Builder> result = ListedHostKeysCopier.copyToBuilder(this.hostKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHostKeys(Collection<ListedHostKey.BuilderImpl> hostKeys) {
            this.hostKeys = ListedHostKeysCopier.copyFromBuilder(hostKeys);
        }

        @Override
        public final Builder hostKeys(Collection<ListedHostKey> hostKeys) {
            this.hostKeys = ListedHostKeysCopier.copy(hostKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostKeys(ListedHostKey ... hostKeys) {
            this.hostKeys(Arrays.asList(hostKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostKeys(Consumer<ListedHostKey.Builder> ... hostKeys) {
            this.hostKeys(Stream.of(hostKeys).map(c -> (ListedHostKey)((ListedHostKey.Builder)ListedHostKey.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListHostKeysResponse build() {
            return new ListHostKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHostKeysResponse> {
        public Builder nextToken(String var1);

        public Builder serverId(String var1);

        public Builder hostKeys(Collection<ListedHostKey> var1);

        public Builder hostKeys(ListedHostKey ... var1);

        public Builder hostKeys(Consumer<ListedHostKey.Builder> ... var1);
    }
}

