/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedHostKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedHostKey> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListedHostKey.getter(ListedHostKey::arn)).setter(ListedHostKey.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> HOST_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostKeyId").getter(ListedHostKey.getter(ListedHostKey::hostKeyId)).setter(ListedHostKey.setter(Builder::hostKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKeyId").build()}).build();
    private static final SdkField<String> FINGERPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Fingerprint").getter(ListedHostKey.getter(ListedHostKey::fingerprint)).setter(ListedHostKey.setter(Builder::fingerprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fingerprint").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ListedHostKey.getter(ListedHostKey::description)).setter(ListedHostKey.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ListedHostKey.getter(ListedHostKey::type)).setter(ListedHostKey.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Instant> DATE_IMPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DateImported").getter(ListedHostKey.getter(ListedHostKey::dateImported)).setter(ListedHostKey.setter(Builder::dateImported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateImported").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, HOST_KEY_ID_FIELD, FINGERPRINT_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, DATE_IMPORTED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String hostKeyId;
    private final String fingerprint;
    private final String description;
    private final String type;
    private final Instant dateImported;

    private ListedHostKey(BuilderImpl builder) {
        this.arn = builder.arn;
        this.hostKeyId = builder.hostKeyId;
        this.fingerprint = builder.fingerprint;
        this.description = builder.description;
        this.type = builder.type;
        this.dateImported = builder.dateImported;
    }

    public final String arn() {
        return this.arn;
    }

    public final String hostKeyId() {
        return this.hostKeyId;
    }

    public final String fingerprint() {
        return this.fingerprint;
    }

    public final String description() {
        return this.description;
    }

    public final String type() {
        return this.type;
    }

    public final Instant dateImported() {
        return this.dateImported;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateImported());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedHostKey)) {
            return false;
        }
        ListedHostKey other = (ListedHostKey)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.hostKeyId(), other.hostKeyId()) && Objects.equals(this.fingerprint(), other.fingerprint()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.dateImported(), other.dateImported());
    }

    public final String toString() {
        return ToString.builder((String)"ListedHostKey").add("Arn", (Object)this.arn()).add("HostKeyId", (Object)this.hostKeyId()).add("Fingerprint", (Object)this.fingerprint()).add("Description", (Object)this.description()).add("Type", (Object)this.type()).add("DateImported", (Object)this.dateImported()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "HostKeyId": {
                return Optional.ofNullable(clazz.cast(this.hostKeyId()));
            }
            case "Fingerprint": {
                return Optional.ofNullable(clazz.cast(this.fingerprint()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "DateImported": {
                return Optional.ofNullable(clazz.cast(this.dateImported()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedHostKey, T> g) {
        return obj -> g.apply((ListedHostKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String hostKeyId;
        private String fingerprint;
        private String description;
        private String type;
        private Instant dateImported;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedHostKey model) {
            this.arn(model.arn);
            this.hostKeyId(model.hostKeyId);
            this.fingerprint(model.fingerprint);
            this.description(model.description);
            this.type(model.type);
            this.dateImported(model.dateImported);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getHostKeyId() {
            return this.hostKeyId;
        }

        public final void setHostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
        }

        @Override
        public final Builder hostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
            return this;
        }

        public final String getFingerprint() {
            return this.fingerprint;
        }

        public final void setFingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
        }

        @Override
        public final Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getDateImported() {
            return this.dateImported;
        }

        public final void setDateImported(Instant dateImported) {
            this.dateImported = dateImported;
        }

        @Override
        public final Builder dateImported(Instant dateImported) {
            this.dateImported = dateImported;
            return this;
        }

        public ListedHostKey build() {
            return new ListedHostKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedHostKey> {
        public Builder arn(String var1);

        public Builder hostKeyId(String var1);

        public Builder fingerprint(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder dateImported(Instant var1);
    }
}

