/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MapType {
    FILE("FILE"),
    DIRECTORY("DIRECTORY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MapType> VALUE_MAP;
    private final String value;

    private MapType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MapType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MapType> knownValues() {
        EnumSet<MapType> knownValues = EnumSet.allOf(MapType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MapType.class, MapType::toString);
    }
}

