/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.InputFileLocation;
import software.amazon.awssdk.services.transfer.model.OverwriteExisting;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyStepDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CopyStepDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CopyStepDetails.getter(CopyStepDetails::name)).setter(CopyStepDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<InputFileLocation> DESTINATION_FILE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationFileLocation").getter(CopyStepDetails.getter(CopyStepDetails::destinationFileLocation)).setter(CopyStepDetails.setter(Builder::destinationFileLocation)).constructor(InputFileLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationFileLocation").build()}).build();
    private static final SdkField<String> OVERWRITE_EXISTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OverwriteExisting").getter(CopyStepDetails.getter(CopyStepDetails::overwriteExistingAsString)).setter(CopyStepDetails.setter(Builder::overwriteExisting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverwriteExisting").build()}).build();
    private static final SdkField<String> SOURCE_FILE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFileLocation").getter(CopyStepDetails.getter(CopyStepDetails::sourceFileLocation)).setter(CopyStepDetails.setter(Builder::sourceFileLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESTINATION_FILE_LOCATION_FIELD, OVERWRITE_EXISTING_FIELD, SOURCE_FILE_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final InputFileLocation destinationFileLocation;
    private final String overwriteExisting;
    private final String sourceFileLocation;

    private CopyStepDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.destinationFileLocation = builder.destinationFileLocation;
        this.overwriteExisting = builder.overwriteExisting;
        this.sourceFileLocation = builder.sourceFileLocation;
    }

    public final String name() {
        return this.name;
    }

    public final InputFileLocation destinationFileLocation() {
        return this.destinationFileLocation;
    }

    public final OverwriteExisting overwriteExisting() {
        return OverwriteExisting.fromValue(this.overwriteExisting);
    }

    public final String overwriteExistingAsString() {
        return this.overwriteExisting;
    }

    public final String sourceFileLocation() {
        return this.sourceFileLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationFileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.overwriteExistingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFileLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyStepDetails)) {
            return false;
        }
        CopyStepDetails other = (CopyStepDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.destinationFileLocation(), other.destinationFileLocation()) && Objects.equals(this.overwriteExistingAsString(), other.overwriteExistingAsString()) && Objects.equals(this.sourceFileLocation(), other.sourceFileLocation());
    }

    public final String toString() {
        return ToString.builder((String)"CopyStepDetails").add("Name", (Object)this.name()).add("DestinationFileLocation", (Object)this.destinationFileLocation()).add("OverwriteExisting", (Object)this.overwriteExistingAsString()).add("SourceFileLocation", (Object)this.sourceFileLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DestinationFileLocation": {
                return Optional.ofNullable(clazz.cast(this.destinationFileLocation()));
            }
            case "OverwriteExisting": {
                return Optional.ofNullable(clazz.cast(this.overwriteExistingAsString()));
            }
            case "SourceFileLocation": {
                return Optional.ofNullable(clazz.cast(this.sourceFileLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyStepDetails, T> g) {
        return obj -> g.apply((CopyStepDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private InputFileLocation destinationFileLocation;
        private String overwriteExisting;
        private String sourceFileLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyStepDetails model) {
            this.name(model.name);
            this.destinationFileLocation(model.destinationFileLocation);
            this.overwriteExisting(model.overwriteExisting);
            this.sourceFileLocation(model.sourceFileLocation);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final InputFileLocation.Builder getDestinationFileLocation() {
            return this.destinationFileLocation != null ? this.destinationFileLocation.toBuilder() : null;
        }

        public final void setDestinationFileLocation(InputFileLocation.BuilderImpl destinationFileLocation) {
            this.destinationFileLocation = destinationFileLocation != null ? destinationFileLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder destinationFileLocation(InputFileLocation destinationFileLocation) {
            this.destinationFileLocation = destinationFileLocation;
            return this;
        }

        public final String getOverwriteExisting() {
            return this.overwriteExisting;
        }

        public final void setOverwriteExisting(String overwriteExisting) {
            this.overwriteExisting = overwriteExisting;
        }

        @Override
        @Transient
        public final Builder overwriteExisting(String overwriteExisting) {
            this.overwriteExisting = overwriteExisting;
            return this;
        }

        @Override
        @Transient
        public final Builder overwriteExisting(OverwriteExisting overwriteExisting) {
            this.overwriteExisting(overwriteExisting == null ? null : overwriteExisting.toString());
            return this;
        }

        public final String getSourceFileLocation() {
            return this.sourceFileLocation;
        }

        public final void setSourceFileLocation(String sourceFileLocation) {
            this.sourceFileLocation = sourceFileLocation;
        }

        @Override
        @Transient
        public final Builder sourceFileLocation(String sourceFileLocation) {
            this.sourceFileLocation = sourceFileLocation;
            return this;
        }

        public CopyStepDetails build() {
            return new CopyStepDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CopyStepDetails> {
        public Builder name(String var1);

        public Builder destinationFileLocation(InputFileLocation var1);

        default public Builder destinationFileLocation(Consumer<InputFileLocation.Builder> destinationFileLocation) {
            return this.destinationFileLocation((InputFileLocation)((InputFileLocation.Builder)InputFileLocation.builder().applyMutation(destinationFileLocation)).build());
        }

        public Builder overwriteExisting(String var1);

        public Builder overwriteExisting(OverwriteExisting var1);

        public Builder sourceFileLocation(String var1);
    }
}

