/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.DescribedExecution;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExecutionResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, DescribeExecutionResponse> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkflowId").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::workflowId)).setter(DescribeExecutionResponse.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()}).build();
    private static final SdkField<DescribedExecution> EXECUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Execution").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::execution)).setter(DescribeExecutionResponse.setter(Builder::execution)).constructor(DescribedExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Execution").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD, EXECUTION_FIELD));
    private final String workflowId;
    private final DescribedExecution execution;

    private DescribeExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.execution = builder.execution;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final DescribedExecution execution() {
        return this.execution;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.execution());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExecutionResponse)) {
            return false;
        }
        DescribeExecutionResponse other = (DescribeExecutionResponse)((Object)obj);
        return Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.execution(), other.execution());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExecutionResponse").add("WorkflowId", (Object)this.workflowId()).add("Execution", (Object)this.execution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "Execution": {
                return Optional.ofNullable(clazz.cast(this.execution()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeExecutionResponse, T> g) {
        return obj -> g.apply((DescribeExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String workflowId;
        private DescribedExecution execution;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExecutionResponse model) {
            super(model);
            this.workflowId(model.workflowId);
            this.execution(model.execution);
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        @Transient
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final DescribedExecution.Builder getExecution() {
            return this.execution != null ? this.execution.toBuilder() : null;
        }

        public final void setExecution(DescribedExecution.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        @Override
        @Transient
        public final Builder execution(DescribedExecution execution) {
            this.execution = execution;
            return this;
        }

        @Override
        public DescribeExecutionResponse build() {
            return new DescribeExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExecutionResponse> {
        public Builder workflowId(String var1);

        public Builder execution(DescribedExecution var1);

        default public Builder execution(Consumer<DescribedExecution.Builder> execution) {
            return this.execution((DescribedExecution)((DescribedExecution.Builder)DescribedExecution.builder().applyMutation(execution)).build());
        }
    }
}

