/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.EndpointDetails;
import software.amazon.awssdk.services.transfer.model.EndpointType;
import software.amazon.awssdk.services.transfer.model.IdentityProviderDetails;
import software.amazon.awssdk.services.transfer.model.Protocol;
import software.amazon.awssdk.services.transfer.model.ProtocolsCopier;
import software.amazon.awssdk.services.transfer.model.TransferRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateServerRequest
extends TransferRequest
implements ToCopyableBuilder<Builder, UpdateServerRequest> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Certificate").getter(UpdateServerRequest.getter(UpdateServerRequest::certificate)).setter(UpdateServerRequest.setter(Builder::certificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()}).build();
    private static final SdkField<EndpointDetails> ENDPOINT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointDetails").getter(UpdateServerRequest.getter(UpdateServerRequest::endpointDetails)).setter(UpdateServerRequest.setter(Builder::endpointDetails)).constructor(EndpointDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDetails").build()}).build();
    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointType").getter(UpdateServerRequest.getter(UpdateServerRequest::endpointTypeAsString)).setter(UpdateServerRequest.setter(Builder::endpointType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()}).build();
    private static final SdkField<String> HOST_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostKey").getter(UpdateServerRequest.getter(UpdateServerRequest::hostKey)).setter(UpdateServerRequest.setter(Builder::hostKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKey").build()}).build();
    private static final SdkField<IdentityProviderDetails> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IdentityProviderDetails").getter(UpdateServerRequest.getter(UpdateServerRequest::identityProviderDetails)).setter(UpdateServerRequest.setter(Builder::identityProviderDetails)).constructor(IdentityProviderDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderDetails").build()}).build();
    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoggingRole").getter(UpdateServerRequest.getter(UpdateServerRequest::loggingRole)).setter(UpdateServerRequest.setter(Builder::loggingRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()}).build();
    private static final SdkField<List<String>> PROTOCOLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Protocols").getter(UpdateServerRequest.getter(UpdateServerRequest::protocolsAsStrings)).setter(UpdateServerRequest.setter(Builder::protocolsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocols").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SECURITY_POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityPolicyName").getter(UpdateServerRequest.getter(UpdateServerRequest::securityPolicyName)).setter(UpdateServerRequest.setter(Builder::securityPolicyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyName").build()}).build();
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerId").getter(UpdateServerRequest.getter(UpdateServerRequest::serverId)).setter(UpdateServerRequest.setter(Builder::serverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD, ENDPOINT_DETAILS_FIELD, ENDPOINT_TYPE_FIELD, HOST_KEY_FIELD, IDENTITY_PROVIDER_DETAILS_FIELD, LOGGING_ROLE_FIELD, PROTOCOLS_FIELD, SECURITY_POLICY_NAME_FIELD, SERVER_ID_FIELD));
    private final String certificate;
    private final EndpointDetails endpointDetails;
    private final String endpointType;
    private final String hostKey;
    private final IdentityProviderDetails identityProviderDetails;
    private final String loggingRole;
    private final List<String> protocols;
    private final String securityPolicyName;
    private final String serverId;

    private UpdateServerRequest(BuilderImpl builder) {
        super(builder);
        this.certificate = builder.certificate;
        this.endpointDetails = builder.endpointDetails;
        this.endpointType = builder.endpointType;
        this.hostKey = builder.hostKey;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.loggingRole = builder.loggingRole;
        this.protocols = builder.protocols;
        this.securityPolicyName = builder.securityPolicyName;
        this.serverId = builder.serverId;
    }

    public String certificate() {
        return this.certificate;
    }

    public EndpointDetails endpointDetails() {
        return this.endpointDetails;
    }

    public EndpointType endpointType() {
        return EndpointType.fromValue(this.endpointType);
    }

    public String endpointTypeAsString() {
        return this.endpointType;
    }

    public String hostKey() {
        return this.hostKey;
    }

    public IdentityProviderDetails identityProviderDetails() {
        return this.identityProviderDetails;
    }

    public String loggingRole() {
        return this.loggingRole;
    }

    public List<Protocol> protocols() {
        return ProtocolsCopier.copyStringToEnum(this.protocols);
    }

    public boolean hasProtocols() {
        return this.protocols != null && !(this.protocols instanceof SdkAutoConstructList);
    }

    public List<String> protocolsAsStrings() {
        return this.protocols;
    }

    public String securityPolicyName() {
        return this.securityPolicyName;
    }

    public String serverId() {
        return this.serverId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocols() ? this.protocolsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityPolicyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServerRequest)) {
            return false;
        }
        UpdateServerRequest other = (UpdateServerRequest)((Object)obj);
        return Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.endpointDetails(), other.endpointDetails()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.hostKey(), other.hostKey()) && Objects.equals(this.identityProviderDetails(), other.identityProviderDetails()) && Objects.equals(this.loggingRole(), other.loggingRole()) && this.hasProtocols() == other.hasProtocols() && Objects.equals(this.protocolsAsStrings(), other.protocolsAsStrings()) && Objects.equals(this.securityPolicyName(), other.securityPolicyName()) && Objects.equals(this.serverId(), other.serverId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateServerRequest").add("Certificate", (Object)this.certificate()).add("EndpointDetails", (Object)this.endpointDetails()).add("EndpointType", (Object)this.endpointTypeAsString()).add("HostKey", (Object)(this.hostKey() == null ? null : "*** Sensitive Data Redacted ***")).add("IdentityProviderDetails", (Object)this.identityProviderDetails()).add("LoggingRole", (Object)this.loggingRole()).add("Protocols", this.hasProtocols() ? this.protocolsAsStrings() : null).add("SecurityPolicyName", (Object)this.securityPolicyName()).add("ServerId", (Object)this.serverId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Certificate": {
                return Optional.ofNullable(clazz.cast(this.certificate()));
            }
            case "EndpointDetails": {
                return Optional.ofNullable(clazz.cast(this.endpointDetails()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "HostKey": {
                return Optional.ofNullable(clazz.cast(this.hostKey()));
            }
            case "IdentityProviderDetails": {
                return Optional.ofNullable(clazz.cast(this.identityProviderDetails()));
            }
            case "LoggingRole": {
                return Optional.ofNullable(clazz.cast(this.loggingRole()));
            }
            case "Protocols": {
                return Optional.ofNullable(clazz.cast(this.protocolsAsStrings()));
            }
            case "SecurityPolicyName": {
                return Optional.ofNullable(clazz.cast(this.securityPolicyName()));
            }
            case "ServerId": {
                return Optional.ofNullable(clazz.cast(this.serverId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServerRequest, T> g) {
        return obj -> g.apply((UpdateServerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferRequest.BuilderImpl
    implements Builder {
        private String certificate;
        private EndpointDetails endpointDetails;
        private String endpointType;
        private String hostKey;
        private IdentityProviderDetails identityProviderDetails;
        private String loggingRole;
        private List<String> protocols = DefaultSdkAutoConstructList.getInstance();
        private String securityPolicyName;
        private String serverId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServerRequest model) {
            super(model);
            this.certificate(model.certificate);
            this.endpointDetails(model.endpointDetails);
            this.endpointType(model.endpointType);
            this.hostKey(model.hostKey);
            this.identityProviderDetails(model.identityProviderDetails);
            this.loggingRole(model.loggingRole);
            this.protocolsWithStrings(model.protocols);
            this.securityPolicyName(model.securityPolicyName);
            this.serverId(model.serverId);
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final EndpointDetails.Builder getEndpointDetails() {
            return this.endpointDetails != null ? this.endpointDetails.toBuilder() : null;
        }

        @Override
        public final Builder endpointDetails(EndpointDetails endpointDetails) {
            this.endpointDetails = endpointDetails;
            return this;
        }

        public final void setEndpointDetails(EndpointDetails.BuilderImpl endpointDetails) {
            this.endpointDetails = endpointDetails != null ? endpointDetails.build() : null;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType == null ? null : endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getHostKey() {
            return this.hostKey;
        }

        @Override
        public final Builder hostKey(String hostKey) {
            this.hostKey = hostKey;
            return this;
        }

        public final void setHostKey(String hostKey) {
            this.hostKey = hostKey;
        }

        public final IdentityProviderDetails.Builder getIdentityProviderDetails() {
            return this.identityProviderDetails != null ? this.identityProviderDetails.toBuilder() : null;
        }

        @Override
        public final Builder identityProviderDetails(IdentityProviderDetails identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        public final void setIdentityProviderDetails(IdentityProviderDetails.BuilderImpl identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails != null ? identityProviderDetails.build() : null;
        }

        public final String getLoggingRole() {
            return this.loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        public final Collection<String> getProtocols() {
            if (this.protocols instanceof SdkAutoConstructList) {
                return null;
            }
            return this.protocols;
        }

        @Override
        public final Builder protocolsWithStrings(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolsWithStrings(String ... protocols) {
            this.protocolsWithStrings(Arrays.asList(protocols));
            return this;
        }

        @Override
        public final Builder protocols(Collection<Protocol> protocols) {
            this.protocols = ProtocolsCopier.copyEnumToString(protocols);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocols(Protocol ... protocols) {
            this.protocols(Arrays.asList(protocols));
            return this;
        }

        public final void setProtocols(Collection<String> protocols) {
            this.protocols = ProtocolsCopier.copy(protocols);
        }

        public final String getSecurityPolicyName() {
            return this.securityPolicyName;
        }

        @Override
        public final Builder securityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
            return this;
        }

        public final void setSecurityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
        }

        public final String getServerId() {
            return this.serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServerRequest build() {
            return new UpdateServerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateServerRequest> {
        public Builder certificate(String var1);

        public Builder endpointDetails(EndpointDetails var1);

        default public Builder endpointDetails(Consumer<EndpointDetails.Builder> endpointDetails) {
            return this.endpointDetails((EndpointDetails)((EndpointDetails.Builder)EndpointDetails.builder().applyMutation(endpointDetails)).build());
        }

        public Builder endpointType(String var1);

        public Builder endpointType(EndpointType var1);

        public Builder hostKey(String var1);

        public Builder identityProviderDetails(IdentityProviderDetails var1);

        default public Builder identityProviderDetails(Consumer<IdentityProviderDetails.Builder> identityProviderDetails) {
            return this.identityProviderDetails((IdentityProviderDetails)((IdentityProviderDetails.Builder)IdentityProviderDetails.builder().applyMutation(identityProviderDetails)).build());
        }

        public Builder loggingRole(String var1);

        public Builder protocolsWithStrings(Collection<String> var1);

        public Builder protocolsWithStrings(String ... var1);

        public Builder protocols(Collection<Protocol> var1);

        public Builder protocols(Protocol ... var1);

        public Builder securityPolicyName(String var1);

        public Builder serverId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

