/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transfer.model.ListedServer;
import software.amazon.awssdk.services.transfer.model.ListedServersCopier;
import software.amazon.awssdk.services.transfer.model.TransferResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServersResponse
extends TransferResponse
implements ToCopyableBuilder<Builder, ListServersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServersResponse.getter(ListServersResponse::nextToken)).setter(ListServersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ListedServer>> SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Servers").getter(ListServersResponse.getter(ListServersResponse::servers)).setter(ListServersResponse.setter(Builder::servers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Servers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedServer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVERS_FIELD));
    private final String nextToken;
    private final List<ListedServer> servers;

    private ListServersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.servers = builder.servers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasServers() {
        return this.servers != null && !(this.servers instanceof SdkAutoConstructList);
    }

    public List<ListedServer> servers() {
        return this.servers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.servers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServersResponse)) {
            return false;
        }
        ListServersResponse other = (ListServersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.servers(), other.servers());
    }

    public String toString() {
        return ToString.builder((String)"ListServersResponse").add("NextToken", (Object)this.nextToken()).add("Servers", this.servers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Servers": {
                return Optional.ofNullable(clazz.cast(this.servers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServersResponse, T> g) {
        return obj -> g.apply((ListServersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TransferResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ListedServer> servers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.servers(model.servers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ListedServer.Builder> getServers() {
            return this.servers != null ? (Collection)this.servers.stream().map(ListedServer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder servers(Collection<ListedServer> servers) {
            this.servers = ListedServersCopier.copy(servers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servers(ListedServer ... servers) {
            this.servers(Arrays.asList(servers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servers(Consumer<ListedServer.Builder> ... servers) {
            this.servers(Stream.of(servers).map(c -> (ListedServer)((ListedServer.Builder)ListedServer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServers(Collection<ListedServer.BuilderImpl> servers) {
            this.servers = ListedServersCopier.copyFromBuilder(servers);
        }

        @Override
        public ListServersResponse build() {
            return new ListServersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TransferResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServersResponse> {
        public Builder nextToken(String var1);

        public Builder servers(Collection<ListedServer> var1);

        public Builder servers(ListedServer ... var1);

        public Builder servers(Consumer<ListedServer.Builder> ... var1);
    }
}

