/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transfer.model.HomeDirectoryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedUser
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedUser> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListedUser.getter(ListedUser::arn)).setter(ListedUser.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> HOME_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListedUser.getter(ListedUser::homeDirectory)).setter(ListedUser.setter(Builder::homeDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectory").build()}).build();
    private static final SdkField<String> HOME_DIRECTORY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListedUser.getter(ListedUser::homeDirectoryTypeAsString)).setter(ListedUser.setter(Builder::homeDirectoryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryType").build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListedUser.getter(ListedUser::role)).setter(ListedUser.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<Integer> SSH_PUBLIC_KEY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListedUser.getter(ListedUser::sshPublicKeyCount)).setter(ListedUser.setter(Builder::sshPublicKeyCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeyCount").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListedUser.getter(ListedUser::userName)).setter(ListedUser.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, HOME_DIRECTORY_FIELD, HOME_DIRECTORY_TYPE_FIELD, ROLE_FIELD, SSH_PUBLIC_KEY_COUNT_FIELD, USER_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String homeDirectory;
    private final String homeDirectoryType;
    private final String role;
    private final Integer sshPublicKeyCount;
    private final String userName;

    private ListedUser(BuilderImpl builder) {
        this.arn = builder.arn;
        this.homeDirectory = builder.homeDirectory;
        this.homeDirectoryType = builder.homeDirectoryType;
        this.role = builder.role;
        this.sshPublicKeyCount = builder.sshPublicKeyCount;
        this.userName = builder.userName;
    }

    public String arn() {
        return this.arn;
    }

    public String homeDirectory() {
        return this.homeDirectory;
    }

    public HomeDirectoryType homeDirectoryType() {
        return HomeDirectoryType.fromValue(this.homeDirectoryType);
    }

    public String homeDirectoryTypeAsString() {
        return this.homeDirectoryType;
    }

    public String role() {
        return this.role;
    }

    public Integer sshPublicKeyCount() {
        return this.sshPublicKeyCount;
    }

    public String userName() {
        return this.userName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeDirectoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeyCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedUser)) {
            return false;
        }
        ListedUser other = (ListedUser)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.homeDirectory(), other.homeDirectory()) && Objects.equals(this.homeDirectoryTypeAsString(), other.homeDirectoryTypeAsString()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.sshPublicKeyCount(), other.sshPublicKeyCount()) && Objects.equals(this.userName(), other.userName());
    }

    public String toString() {
        return ToString.builder((String)"ListedUser").add("Arn", (Object)this.arn()).add("HomeDirectory", (Object)this.homeDirectory()).add("HomeDirectoryType", (Object)this.homeDirectoryTypeAsString()).add("Role", (Object)this.role()).add("SshPublicKeyCount", (Object)this.sshPublicKeyCount()).add("UserName", (Object)this.userName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "HomeDirectory": {
                return Optional.ofNullable(clazz.cast(this.homeDirectory()));
            }
            case "HomeDirectoryType": {
                return Optional.ofNullable(clazz.cast(this.homeDirectoryTypeAsString()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "SshPublicKeyCount": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKeyCount()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedUser, T> g) {
        return obj -> g.apply((ListedUser)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String homeDirectory;
        private String homeDirectoryType;
        private String role;
        private Integer sshPublicKeyCount;
        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedUser model) {
            this.arn(model.arn);
            this.homeDirectory(model.homeDirectory);
            this.homeDirectoryType(model.homeDirectoryType);
            this.role(model.role);
            this.sshPublicKeyCount(model.sshPublicKeyCount);
            this.userName(model.userName);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getHomeDirectory() {
            return this.homeDirectory;
        }

        @Override
        public final Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        public final void setHomeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
        }

        public final String getHomeDirectoryType() {
            return this.homeDirectoryType;
        }

        @Override
        public final Builder homeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
            return this;
        }

        @Override
        public final Builder homeDirectoryType(HomeDirectoryType homeDirectoryType) {
            this.homeDirectoryType(homeDirectoryType == null ? null : homeDirectoryType.toString());
            return this;
        }

        public final void setHomeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
        }

        public final String getRole() {
            return this.role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final Integer getSshPublicKeyCount() {
            return this.sshPublicKeyCount;
        }

        @Override
        public final Builder sshPublicKeyCount(Integer sshPublicKeyCount) {
            this.sshPublicKeyCount = sshPublicKeyCount;
            return this;
        }

        public final void setSshPublicKeyCount(Integer sshPublicKeyCount) {
            this.sshPublicKeyCount = sshPublicKeyCount;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public ListedUser build() {
            return new ListedUser(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedUser> {
        public Builder arn(String var1);

        public Builder homeDirectory(String var1);

        public Builder homeDirectoryType(String var1);

        public Builder homeDirectoryType(HomeDirectoryType var1);

        public Builder role(String var1);

        public Builder sshPublicKeyCount(Integer var1);

        public Builder userName(String var1);
    }
}

