/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model.medicalscribeinputstream;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeAudioEvent;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeInputStream;

/**
 * A specialization of {@code software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeAudioEvent} that
 * represents the {@code MedicalScribeInputStream$AudioEvent} event. Do not use this class directly. Instead, use the
 * static builder methods on {@link software.amazon.awssdk.services.transcribestreaming.model.MedicalScribeInputStream}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultAudioEvent extends MedicalScribeAudioEvent {
    private static final long serialVersionUID = 1L;

    DefaultAudioEvent(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public MedicalScribeInputStream.EventType sdkEventType() {
        return MedicalScribeInputStream.EventType.AUDIO_EVENT;
    }

    public interface Builder extends MedicalScribeAudioEvent.Builder {
        @Override
        DefaultAudioEvent build();
    }

    private static final class BuilderImpl extends MedicalScribeAudioEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultAudioEvent event) {
            super(event);
        }

        @Override
        public DefaultAudioEvent build() {
            return new DefaultAudioEvent(this);
        }
    }
}
