/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultStartMedicalStreamTranscriptionVisitorBuilder implements
        StartMedicalStreamTranscriptionResponseHandler.Visitor.Builder {
    private Consumer<MedicalTranscriptResultStream> onDefault;

    private Consumer<MedicalTranscriptEvent> onMedicalTranscriptEvent;

    @Override
    public StartMedicalStreamTranscriptionResponseHandler.Visitor.Builder onDefault(Consumer<MedicalTranscriptResultStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public StartMedicalStreamTranscriptionResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public StartMedicalStreamTranscriptionResponseHandler.Visitor.Builder onMedicalTranscriptEvent(
            Consumer<MedicalTranscriptEvent> c) {
        this.onMedicalTranscriptEvent = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    static class VisitorFromBuilder implements StartMedicalStreamTranscriptionResponseHandler.Visitor {
        private final Consumer<MedicalTranscriptResultStream> onDefault;

        private final Consumer<MedicalTranscriptEvent> onMedicalTranscriptEvent;

        VisitorFromBuilder(DefaultStartMedicalStreamTranscriptionVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : StartMedicalStreamTranscriptionResponseHandler.Visitor.super::visitDefault;
            this.onMedicalTranscriptEvent = builder.onMedicalTranscriptEvent != null ? builder.onMedicalTranscriptEvent
                    : StartMedicalStreamTranscriptionResponseHandler.Visitor.super::visit;
        }

        @Override
        public void visitDefault(MedicalTranscriptResultStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visit(MedicalTranscriptEvent event) {
            onMedicalTranscriptEvent.accept(event);
        }
    }
}
