/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribestreaming.model.ItemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CallAnalyticsItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CallAnalyticsItem> {
    private static final SdkField<Long> BEGIN_OFFSET_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BeginOffsetMillis").getter(CallAnalyticsItem.getter(CallAnalyticsItem::beginOffsetMillis)).setter(CallAnalyticsItem.setter(Builder::beginOffsetMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffsetMillis").build()}).build();
    private static final SdkField<Long> END_OFFSET_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EndOffsetMillis").getter(CallAnalyticsItem.getter(CallAnalyticsItem::endOffsetMillis)).setter(CallAnalyticsItem.setter(Builder::endOffsetMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffsetMillis").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CallAnalyticsItem.getter(CallAnalyticsItem::typeAsString)).setter(CallAnalyticsItem.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(CallAnalyticsItem.getter(CallAnalyticsItem::content)).setter(CallAnalyticsItem.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Confidence").getter(CallAnalyticsItem.getter(CallAnalyticsItem::confidence)).setter(CallAnalyticsItem.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final SdkField<Boolean> VOCABULARY_FILTER_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("VocabularyFilterMatch").getter(CallAnalyticsItem.getter(CallAnalyticsItem::vocabularyFilterMatch)).setter(CallAnalyticsItem.setter(Builder::vocabularyFilterMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMatch").build()}).build();
    private static final SdkField<Boolean> STABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Stable").getter(CallAnalyticsItem.getter(CallAnalyticsItem::stable)).setter(CallAnalyticsItem.setter(Builder::stable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stable").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_MILLIS_FIELD, END_OFFSET_MILLIS_FIELD, TYPE_FIELD, CONTENT_FIELD, CONFIDENCE_FIELD, VOCABULARY_FILTER_MATCH_FIELD, STABLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CallAnalyticsItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long beginOffsetMillis;
    private final Long endOffsetMillis;
    private final String type;
    private final String content;
    private final Double confidence;
    private final Boolean vocabularyFilterMatch;
    private final Boolean stable;

    private CallAnalyticsItem(BuilderImpl builder) {
        this.beginOffsetMillis = builder.beginOffsetMillis;
        this.endOffsetMillis = builder.endOffsetMillis;
        this.type = builder.type;
        this.content = builder.content;
        this.confidence = builder.confidence;
        this.vocabularyFilterMatch = builder.vocabularyFilterMatch;
        this.stable = builder.stable;
    }

    public final Long beginOffsetMillis() {
        return this.beginOffsetMillis;
    }

    public final Long endOffsetMillis() {
        return this.endOffsetMillis;
    }

    public final ItemType type() {
        return ItemType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String content() {
        return this.content;
    }

    public final Double confidence() {
        return this.confidence;
    }

    public final Boolean vocabularyFilterMatch() {
        return this.vocabularyFilterMatch;
    }

    public final Boolean stable() {
        return this.stable;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.beginOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.endOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.stable());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallAnalyticsItem)) {
            return false;
        }
        CallAnalyticsItem other = (CallAnalyticsItem)obj;
        return Objects.equals(this.beginOffsetMillis(), other.beginOffsetMillis()) && Objects.equals(this.endOffsetMillis(), other.endOffsetMillis()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.confidence(), other.confidence()) && Objects.equals(this.vocabularyFilterMatch(), other.vocabularyFilterMatch()) && Objects.equals(this.stable(), other.stable());
    }

    public final String toString() {
        return ToString.builder((String)"CallAnalyticsItem").add("BeginOffsetMillis", (Object)this.beginOffsetMillis()).add("EndOffsetMillis", (Object)this.endOffsetMillis()).add("Type", (Object)this.typeAsString()).add("Content", (Object)this.content()).add("Confidence", (Object)this.confidence()).add("VocabularyFilterMatch", (Object)this.vocabularyFilterMatch()).add("Stable", (Object)this.stable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BeginOffsetMillis": {
                return Optional.ofNullable(clazz.cast(this.beginOffsetMillis()));
            }
            case "EndOffsetMillis": {
                return Optional.ofNullable(clazz.cast(this.endOffsetMillis()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
            case "VocabularyFilterMatch": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMatch()));
            }
            case "Stable": {
                return Optional.ofNullable(clazz.cast(this.stable()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BeginOffsetMillis", BEGIN_OFFSET_MILLIS_FIELD);
        map.put("EndOffsetMillis", END_OFFSET_MILLIS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("VocabularyFilterMatch", VOCABULARY_FILTER_MATCH_FIELD);
        map.put("Stable", STABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CallAnalyticsItem, T> g) {
        return obj -> g.apply((CallAnalyticsItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long beginOffsetMillis;
        private Long endOffsetMillis;
        private String type;
        private String content;
        private Double confidence;
        private Boolean vocabularyFilterMatch;
        private Boolean stable;

        private BuilderImpl() {
        }

        private BuilderImpl(CallAnalyticsItem model) {
            this.beginOffsetMillis(model.beginOffsetMillis);
            this.endOffsetMillis(model.endOffsetMillis);
            this.type(model.type);
            this.content(model.content);
            this.confidence(model.confidence);
            this.vocabularyFilterMatch(model.vocabularyFilterMatch);
            this.stable(model.stable);
        }

        public final Long getBeginOffsetMillis() {
            return this.beginOffsetMillis;
        }

        public final void setBeginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
        }

        @Override
        public final Builder beginOffsetMillis(Long beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
            return this;
        }

        public final Long getEndOffsetMillis() {
            return this.endOffsetMillis;
        }

        public final void setEndOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
        }

        @Override
        public final Builder endOffsetMillis(Long endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getContent() {
            return this.content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Double getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Boolean getVocabularyFilterMatch() {
            return this.vocabularyFilterMatch;
        }

        public final void setVocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
        }

        @Override
        public final Builder vocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
            return this;
        }

        public final Boolean getStable() {
            return this.stable;
        }

        public final void setStable(Boolean stable) {
            this.stable = stable;
        }

        @Override
        public final Builder stable(Boolean stable) {
            this.stable = stable;
            return this;
        }

        public CallAnalyticsItem build() {
            return new CallAnalyticsItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CallAnalyticsItem> {
        public Builder beginOffsetMillis(Long var1);

        public Builder endOffsetMillis(Long var1);

        public Builder type(String var1);

        public Builder type(ItemType var1);

        public Builder content(String var1);

        public Builder confidence(Double var1);

        public Builder vocabularyFilterMatch(Boolean var1);

        public Builder stable(Boolean var1);
    }
}

