/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribestreaming.model.Alternative;
import software.amazon.awssdk.services.transcribestreaming.model.AlternativeListCopier;
import software.amazon.awssdk.services.transcribestreaming.model.LanguageCode;
import software.amazon.awssdk.services.transcribestreaming.model.LanguageIdentificationCopier;
import software.amazon.awssdk.services.transcribestreaming.model.LanguageWithScore;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Result
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Result> {
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultId").getter(Result.getter(Result::resultId)).setter(Result.setter(Builder::resultId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultId").build()}).build();
    private static final SdkField<Double> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("StartTime").getter(Result.getter(Result::startTime)).setter(Result.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Double> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("EndTime").getter(Result.getter(Result::endTime)).setter(Result.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Boolean> IS_PARTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsPartial").getter(Result.getter(Result::isPartial)).setter(Result.setter(Builder::isPartial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartial").build()}).build();
    private static final SdkField<List<Alternative>> ALTERNATIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Alternatives").getter(Result.getter(Result::alternatives)).setter(Result.setter(Builder::alternatives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alternatives").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Alternative::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(Result.getter(Result::channelId)).setter(Result.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(Result.getter(Result::languageCodeAsString)).setter(Result.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<List<LanguageWithScore>> LANGUAGE_IDENTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LanguageIdentification").getter(Result.getter(Result::languageIdentification)).setter(Result.setter(Builder::languageIdentification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageIdentification").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LanguageWithScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, IS_PARTIAL_FIELD, ALTERNATIVES_FIELD, CHANNEL_ID_FIELD, LANGUAGE_CODE_FIELD, LANGUAGE_IDENTIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Result.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resultId;
    private final Double startTime;
    private final Double endTime;
    private final Boolean isPartial;
    private final List<Alternative> alternatives;
    private final String channelId;
    private final String languageCode;
    private final List<LanguageWithScore> languageIdentification;

    private Result(BuilderImpl builder) {
        this.resultId = builder.resultId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.isPartial = builder.isPartial;
        this.alternatives = builder.alternatives;
        this.channelId = builder.channelId;
        this.languageCode = builder.languageCode;
        this.languageIdentification = builder.languageIdentification;
    }

    public final String resultId() {
        return this.resultId;
    }

    public final Double startTime() {
        return this.startTime;
    }

    public final Double endTime() {
        return this.endTime;
    }

    public final Boolean isPartial() {
        return this.isPartial;
    }

    public final boolean hasAlternatives() {
        return this.alternatives != null && !(this.alternatives instanceof SdkAutoConstructList);
    }

    public final List<Alternative> alternatives() {
        return this.alternatives;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final boolean hasLanguageIdentification() {
        return this.languageIdentification != null && !(this.languageIdentification instanceof SdkAutoConstructList);
    }

    public final List<LanguageWithScore> languageIdentification() {
        return this.languageIdentification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPartial());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlternatives() ? this.alternatives() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLanguageIdentification() ? this.languageIdentification() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Result)) {
            return false;
        }
        Result other = (Result)obj;
        return Objects.equals(this.resultId(), other.resultId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.isPartial(), other.isPartial()) && this.hasAlternatives() == other.hasAlternatives() && Objects.equals(this.alternatives(), other.alternatives()) && Objects.equals(this.channelId(), other.channelId()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && this.hasLanguageIdentification() == other.hasLanguageIdentification() && Objects.equals(this.languageIdentification(), other.languageIdentification());
    }

    public final String toString() {
        return ToString.builder((String)"Result").add("ResultId", (Object)this.resultId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("IsPartial", (Object)this.isPartial()).add("Alternatives", this.hasAlternatives() ? this.alternatives() : null).add("ChannelId", (Object)this.channelId()).add("LanguageCode", (Object)this.languageCodeAsString()).add("LanguageIdentification", this.hasLanguageIdentification() ? this.languageIdentification() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultId": {
                return Optional.ofNullable(clazz.cast(this.resultId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "IsPartial": {
                return Optional.ofNullable(clazz.cast(this.isPartial()));
            }
            case "Alternatives": {
                return Optional.ofNullable(clazz.cast(this.alternatives()));
            }
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "LanguageIdentification": {
                return Optional.ofNullable(clazz.cast(this.languageIdentification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResultId", RESULT_ID_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("IsPartial", IS_PARTIAL_FIELD);
        map.put("Alternatives", ALTERNATIVES_FIELD);
        map.put("ChannelId", CHANNEL_ID_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("LanguageIdentification", LANGUAGE_IDENTIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Result, T> g) {
        return obj -> g.apply((Result)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resultId;
        private Double startTime;
        private Double endTime;
        private Boolean isPartial;
        private List<Alternative> alternatives = DefaultSdkAutoConstructList.getInstance();
        private String channelId;
        private String languageCode;
        private List<LanguageWithScore> languageIdentification = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Result model) {
            this.resultId(model.resultId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.isPartial(model.isPartial);
            this.alternatives(model.alternatives);
            this.channelId(model.channelId);
            this.languageCode(model.languageCode);
            this.languageIdentification(model.languageIdentification);
        }

        public final String getResultId() {
            return this.resultId;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final Double getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Double startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Double startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Double getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Double endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Double endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Boolean getIsPartial() {
            return this.isPartial;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        @Override
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final List<Alternative.Builder> getAlternatives() {
            List<Alternative.Builder> result = AlternativeListCopier.copyToBuilder(this.alternatives);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlternatives(Collection<Alternative.BuilderImpl> alternatives) {
            this.alternatives = AlternativeListCopier.copyFromBuilder(alternatives);
        }

        @Override
        public final Builder alternatives(Collection<Alternative> alternatives) {
            this.alternatives = AlternativeListCopier.copy(alternatives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternatives(Alternative ... alternatives) {
            this.alternatives(Arrays.asList(alternatives));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternatives(Consumer<Alternative.Builder> ... alternatives) {
            this.alternatives(Stream.of(alternatives).map(c -> (Alternative)((Alternative.Builder)Alternative.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final List<LanguageWithScore.Builder> getLanguageIdentification() {
            List<LanguageWithScore.Builder> result = LanguageIdentificationCopier.copyToBuilder(this.languageIdentification);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLanguageIdentification(Collection<LanguageWithScore.BuilderImpl> languageIdentification) {
            this.languageIdentification = LanguageIdentificationCopier.copyFromBuilder(languageIdentification);
        }

        @Override
        public final Builder languageIdentification(Collection<LanguageWithScore> languageIdentification) {
            this.languageIdentification = LanguageIdentificationCopier.copy(languageIdentification);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languageIdentification(LanguageWithScore ... languageIdentification) {
            this.languageIdentification(Arrays.asList(languageIdentification));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languageIdentification(Consumer<LanguageWithScore.Builder> ... languageIdentification) {
            this.languageIdentification(Stream.of(languageIdentification).map(c -> (LanguageWithScore)((LanguageWithScore.Builder)LanguageWithScore.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Result build() {
            return new Result(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Result> {
        public Builder resultId(String var1);

        public Builder startTime(Double var1);

        public Builder endTime(Double var1);

        public Builder isPartial(Boolean var1);

        public Builder alternatives(Collection<Alternative> var1);

        public Builder alternatives(Alternative ... var1);

        public Builder alternatives(Consumer<Alternative.Builder> ... var1);

        public Builder channelId(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder languageIdentification(Collection<LanguageWithScore> var1);

        public Builder languageIdentification(LanguageWithScore ... var1);

        public Builder languageIdentification(Consumer<LanguageWithScore.Builder> ... var1);
    }
}

