/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribestreaming.model.ClinicalNoteGenerationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClinicalNoteGenerationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClinicalNoteGenerationResult> {
    private static final SdkField<String> CLINICAL_NOTE_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClinicalNoteOutputLocation").getter(ClinicalNoteGenerationResult.getter(ClinicalNoteGenerationResult::clinicalNoteOutputLocation)).setter(ClinicalNoteGenerationResult.setter(Builder::clinicalNoteOutputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClinicalNoteOutputLocation").build()}).build();
    private static final SdkField<String> TRANSCRIPT_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscriptOutputLocation").getter(ClinicalNoteGenerationResult.getter(ClinicalNoteGenerationResult::transcriptOutputLocation)).setter(ClinicalNoteGenerationResult.setter(Builder::transcriptOutputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscriptOutputLocation").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ClinicalNoteGenerationResult.getter(ClinicalNoteGenerationResult::statusAsString)).setter(ClinicalNoteGenerationResult.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(ClinicalNoteGenerationResult.getter(ClinicalNoteGenerationResult::failureReason)).setter(ClinicalNoteGenerationResult.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLINICAL_NOTE_OUTPUT_LOCATION_FIELD, TRANSCRIPT_OUTPUT_LOCATION_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClinicalNoteGenerationResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clinicalNoteOutputLocation;
    private final String transcriptOutputLocation;
    private final String status;
    private final String failureReason;

    private ClinicalNoteGenerationResult(BuilderImpl builder) {
        this.clinicalNoteOutputLocation = builder.clinicalNoteOutputLocation;
        this.transcriptOutputLocation = builder.transcriptOutputLocation;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
    }

    public final String clinicalNoteOutputLocation() {
        return this.clinicalNoteOutputLocation;
    }

    public final String transcriptOutputLocation() {
        return this.transcriptOutputLocation;
    }

    public final ClinicalNoteGenerationStatus status() {
        return ClinicalNoteGenerationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clinicalNoteOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.transcriptOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClinicalNoteGenerationResult)) {
            return false;
        }
        ClinicalNoteGenerationResult other = (ClinicalNoteGenerationResult)obj;
        return Objects.equals(this.clinicalNoteOutputLocation(), other.clinicalNoteOutputLocation()) && Objects.equals(this.transcriptOutputLocation(), other.transcriptOutputLocation()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"ClinicalNoteGenerationResult").add("ClinicalNoteOutputLocation", (Object)this.clinicalNoteOutputLocation()).add("TranscriptOutputLocation", (Object)this.transcriptOutputLocation()).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClinicalNoteOutputLocation": {
                return Optional.ofNullable(clazz.cast(this.clinicalNoteOutputLocation()));
            }
            case "TranscriptOutputLocation": {
                return Optional.ofNullable(clazz.cast(this.transcriptOutputLocation()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ClinicalNoteOutputLocation", CLINICAL_NOTE_OUTPUT_LOCATION_FIELD);
        map.put("TranscriptOutputLocation", TRANSCRIPT_OUTPUT_LOCATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClinicalNoteGenerationResult, T> g) {
        return obj -> g.apply((ClinicalNoteGenerationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clinicalNoteOutputLocation;
        private String transcriptOutputLocation;
        private String status;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ClinicalNoteGenerationResult model) {
            this.clinicalNoteOutputLocation(model.clinicalNoteOutputLocation);
            this.transcriptOutputLocation(model.transcriptOutputLocation);
            this.status(model.status);
            this.failureReason(model.failureReason);
        }

        public final String getClinicalNoteOutputLocation() {
            return this.clinicalNoteOutputLocation;
        }

        public final void setClinicalNoteOutputLocation(String clinicalNoteOutputLocation) {
            this.clinicalNoteOutputLocation = clinicalNoteOutputLocation;
        }

        @Override
        public final Builder clinicalNoteOutputLocation(String clinicalNoteOutputLocation) {
            this.clinicalNoteOutputLocation = clinicalNoteOutputLocation;
            return this;
        }

        public final String getTranscriptOutputLocation() {
            return this.transcriptOutputLocation;
        }

        public final void setTranscriptOutputLocation(String transcriptOutputLocation) {
            this.transcriptOutputLocation = transcriptOutputLocation;
        }

        @Override
        public final Builder transcriptOutputLocation(String transcriptOutputLocation) {
            this.transcriptOutputLocation = transcriptOutputLocation;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClinicalNoteGenerationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public ClinicalNoteGenerationResult build() {
            return new ClinicalNoteGenerationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClinicalNoteGenerationResult> {
        public Builder clinicalNoteOutputLocation(String var1);

        public Builder transcriptOutputLocation(String var1);

        public Builder status(String var1);

        public Builder status(ClinicalNoteGenerationStatus var1);

        public Builder failureReason(String var1);
    }
}

