/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A word, phrase, or punctuation mark in your transcription output, along with various associated attributes, such as
 * confidence score, type, and start and end times.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Item implements SdkPojo, Serializable, ToCopyableBuilder<Item.Builder, Item> {
    private static final SdkField<Double> START_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("StartTime").getter(getter(Item::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Double> END_TIME_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("EndTime").getter(getter(Item::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Item::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(Item::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<Boolean> VOCABULARY_FILTER_MATCH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("VocabularyFilterMatch").getter(getter(Item::vocabularyFilterMatch))
            .setter(setter(Builder::vocabularyFilterMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMatch").build())
            .build();

    private static final SdkField<String> SPEAKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Speaker")
            .getter(getter(Item::speaker)).setter(setter(Builder::speaker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Speaker").build()).build();

    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Confidence").getter(getter(Item::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<Boolean> STABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Stable").getter(getter(Item::stable)).setter(setter(Builder::stable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, TYPE_FIELD, CONTENT_FIELD, VOCABULARY_FILTER_MATCH_FIELD, SPEAKER_FIELD, CONFIDENCE_FIELD,
            STABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double startTime;

    private final Double endTime;

    private final String type;

    private final String content;

    private final Boolean vocabularyFilterMatch;

    private final String speaker;

    private final Double confidence;

    private final Boolean stable;

    private Item(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.type = builder.type;
        this.content = builder.content;
        this.vocabularyFilterMatch = builder.vocabularyFilterMatch;
        this.speaker = builder.speaker;
        this.confidence = builder.confidence;
        this.stable = builder.stable;
    }

    /**
     * <p>
     * The start time, in milliseconds, of the transcribed item.
     * </p>
     * 
     * @return The start time, in milliseconds, of the transcribed item.
     */
    public final Double startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time, in milliseconds, of the transcribed item.
     * </p>
     * 
     * @return The end time, in milliseconds, of the transcribed item.
     */
    public final Double endTime() {
        return endTime;
    }

    /**
     * <p>
     * The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
     *         <code>PUNCTUATION</code>.
     * @see ItemType
     */
    public final ItemType type() {
        return ItemType.fromValue(type);
    }

    /**
     * <p>
     * The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and <code>PUNCTUATION</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ItemType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
     *         <code>PUNCTUATION</code>.
     * @see ItemType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The word or punctuation that was transcribed.
     * </p>
     * 
     * @return The word or punctuation that was transcribed.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * Indicates whether the specified item matches a word in the vocabulary filter included in your request. If
     * <code>true</code>, there is a vocabulary filter match.
     * </p>
     * 
     * @return Indicates whether the specified item matches a word in the vocabulary filter included in your request. If
     *         <code>true</code>, there is a vocabulary filter match.
     */
    public final Boolean vocabularyFilterMatch() {
        return vocabularyFilterMatch;
    }

    /**
     * <p>
     * If speaker partitioning is enabled, <code>Speaker</code> labels the speaker of the specified item.
     * </p>
     * 
     * @return If speaker partitioning is enabled, <code>Speaker</code> labels the speaker of the specified item.
     */
    public final String speaker() {
        return speaker;
    }

    /**
     * <p>
     * The confidence score associated with a word or phrase in your transcript.
     * </p>
     * <p>
     * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified
     * item correctly matches the item spoken in your media.
     * </p>
     * 
     * @return The confidence score associated with a word or phrase in your transcript.</p>
     *         <p>
     *         Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the
     *         identified item correctly matches the item spoken in your media.
     */
    public final Double confidence() {
        return confidence;
    }

    /**
     * <p>
     * If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item is stable (
     * <code>true</code>) or if it may change when the segment is complete (<code>false</code>).
     * </p>
     * 
     * @return If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item is
     *         stable (<code>true</code>) or if it may change when the segment is complete (<code>false</code>).
     */
    public final Boolean stable() {
        return stable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(vocabularyFilterMatch());
        hashCode = 31 * hashCode + Objects.hashCode(speaker());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(stable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(content(), other.content())
                && Objects.equals(vocabularyFilterMatch(), other.vocabularyFilterMatch())
                && Objects.equals(speaker(), other.speaker()) && Objects.equals(confidence(), other.confidence())
                && Objects.equals(stable(), other.stable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Item").add("StartTime", startTime()).add("EndTime", endTime()).add("Type", typeAsString())
                .add("Content", content()).add("VocabularyFilterMatch", vocabularyFilterMatch()).add("Speaker", speaker())
                .add("Confidence", confidence()).add("Stable", stable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "VocabularyFilterMatch":
            return Optional.ofNullable(clazz.cast(vocabularyFilterMatch()));
        case "Speaker":
            return Optional.ofNullable(clazz.cast(speaker()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Stable":
            return Optional.ofNullable(clazz.cast(stable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Item, T> g) {
        return obj -> g.apply((Item) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Item> {
        /**
         * <p>
         * The start time, in milliseconds, of the transcribed item.
         * </p>
         * 
         * @param startTime
         *        The start time, in milliseconds, of the transcribed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Double startTime);

        /**
         * <p>
         * The end time, in milliseconds, of the transcribed item.
         * </p>
         * 
         * @param endTime
         *        The end time, in milliseconds, of the transcribed item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Double endTime);

        /**
         * <p>
         * The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
         * <code>PUNCTUATION</code>.
         * </p>
         * 
         * @param type
         *        The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
         *        <code>PUNCTUATION</code>.
         * @see ItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ItemType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
         * <code>PUNCTUATION</code>.
         * </p>
         * 
         * @param type
         *        The type of item identified. Options are: <code>PRONUNCIATION</code> (spoken words) and
         *        <code>PUNCTUATION</code>.
         * @see ItemType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ItemType
         */
        Builder type(ItemType type);

        /**
         * <p>
         * The word or punctuation that was transcribed.
         * </p>
         * 
         * @param content
         *        The word or punctuation that was transcribed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * Indicates whether the specified item matches a word in the vocabulary filter included in your request. If
         * <code>true</code>, there is a vocabulary filter match.
         * </p>
         * 
         * @param vocabularyFilterMatch
         *        Indicates whether the specified item matches a word in the vocabulary filter included in your request.
         *        If <code>true</code>, there is a vocabulary filter match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vocabularyFilterMatch(Boolean vocabularyFilterMatch);

        /**
         * <p>
         * If speaker partitioning is enabled, <code>Speaker</code> labels the speaker of the specified item.
         * </p>
         * 
         * @param speaker
         *        If speaker partitioning is enabled, <code>Speaker</code> labels the speaker of the specified item.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speaker(String speaker);

        /**
         * <p>
         * The confidence score associated with a word or phrase in your transcript.
         * </p>
         * <p>
         * Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the
         * identified item correctly matches the item spoken in your media.
         * </p>
         * 
         * @param confidence
         *        The confidence score associated with a word or phrase in your transcript.</p>
         *        <p>
         *        Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the
         *        identified item correctly matches the item spoken in your media.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Double confidence);

        /**
         * <p>
         * If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item is
         * stable (<code>true</code>) or if it may change when the segment is complete (<code>false</code>).
         * </p>
         * 
         * @param stable
         *        If partial result stabilization is enabled, <code>Stable</code> indicates whether the specified item
         *        is stable (<code>true</code>) or if it may change when the segment is complete (<code>false</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stable(Boolean stable);
    }

    static final class BuilderImpl implements Builder {
        private Double startTime;

        private Double endTime;

        private String type;

        private String content;

        private Boolean vocabularyFilterMatch;

        private String speaker;

        private Double confidence;

        private Boolean stable;

        private BuilderImpl() {
        }

        private BuilderImpl(Item model) {
            startTime(model.startTime);
            endTime(model.endTime);
            type(model.type);
            content(model.content);
            vocabularyFilterMatch(model.vocabularyFilterMatch);
            speaker(model.speaker);
            confidence(model.confidence);
            stable(model.stable);
        }

        public final Double getStartTime() {
            return startTime;
        }

        public final void setStartTime(Double startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Double startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Double getEndTime() {
            return endTime;
        }

        public final void setEndTime(Double endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Double endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final Boolean getVocabularyFilterMatch() {
            return vocabularyFilterMatch;
        }

        public final void setVocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
        }

        @Override
        public final Builder vocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
            return this;
        }

        public final String getSpeaker() {
            return speaker;
        }

        public final void setSpeaker(String speaker) {
            this.speaker = speaker;
        }

        @Override
        public final Builder speaker(String speaker) {
            this.speaker = speaker;
            return this;
        }

        public final Double getConfidence() {
            return confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Boolean getStable() {
            return stable;
        }

        public final void setStable(Boolean stable) {
            this.stable = stable;
        }

        @Override
        public final Builder stable(Boolean stable) {
            this.stable = stable;
            return this;
        }

        @Override
        public Item build() {
            return new Item(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
