/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribestreaming.model.LanguageCode;
import software.amazon.awssdk.services.transcribestreaming.model.MediaEncoding;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalContentIdentificationType;
import software.amazon.awssdk.services.transcribestreaming.model.Specialty;
import software.amazon.awssdk.services.transcribestreaming.model.TranscribeStreamingRequest;
import software.amazon.awssdk.services.transcribestreaming.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMedicalStreamTranscriptionRequest
extends TranscribeStreamingRequest
implements ToCopyableBuilder<Builder, StartMedicalStreamTranscriptionRequest> {
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(StartMedicalStreamTranscriptionRequest.getter(StartMedicalStreamTranscriptionRequest::languageCodeAsString)).setter(StartMedicalStreamTranscriptionRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-language-code").build()}).build();
    private static final SdkField<Integer> MEDIA_SAMPLE_RATE_HERTZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MediaSampleRateHertz").getter(StartMedicalStreamTranscriptionRequest.getter(StartMedicalStreamTranscriptionRequest::mediaSampleRateHertz)).setter(StartMedicalStreamTranscriptionRequest.setter(Builder::mediaSampleRateHertz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-sample-rate").build()}).build();
    private static final SdkField<String> MEDIA_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaEncoding").getter(StartMedicalStreamTranscriptionRequest.getter(StartMedicalStreamTranscriptionRequest::mediaEncodingAsString)).setter(StartMedicalStreamTranscriptionRequest.setter(Builder::mediaEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-media-encoding").build()}).build();
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(StartMedicalStreamTranscriptionRequest.getter(StartMedicalStreamTranscriptionRequest::vocabularyName)).setter(StartMedicalStreamTranscriptionRequest.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-vocabulary-name").build()}).build();
    private static final SdkField<String> SPECIALTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Specialty").getter(StartMedicalStreamTranscriptionRequest.getter(StartMedicalStreamTranscriptionRequest::specialtyAsString)).setter(StartMedicalStreamTranscriptionRequest.setter(Builder::specialty)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-specialty").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(StartMedicalStreamTranscriptionRequest.getter(StartMedicalStreamTranscriptionRequest::typeAsString)).setter(StartMedicalStreamTranscriptionRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-type").build()}).build();
    private static final SdkField<Boolean> SHOW_SPEAKER_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ShowSpeakerLabel").getter(StartMedicalStreamTranscriptionRequest.getter(StartMedicalStreamTranscriptionRequest::showSpeakerLabel)).setter(StartMedicalStreamTranscriptionRequest.setter(Builder::showSpeakerLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-show-speaker-label").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(StartMedicalStreamTranscriptionRequest.getter(StartMedicalStreamTranscriptionRequest::sessionId)).setter(StartMedicalStreamTranscriptionRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-session-id").build()}).build();
    private static final SdkField<Boolean> ENABLE_CHANNEL_IDENTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableChannelIdentification").getter(StartMedicalStreamTranscriptionRequest.getter(StartMedicalStreamTranscriptionRequest::enableChannelIdentification)).setter(StartMedicalStreamTranscriptionRequest.setter(Builder::enableChannelIdentification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-enable-channel-identification").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_CHANNELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfChannels").getter(StartMedicalStreamTranscriptionRequest.getter(StartMedicalStreamTranscriptionRequest::numberOfChannels)).setter(StartMedicalStreamTranscriptionRequest.setter(Builder::numberOfChannels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-number-of-channels").build()}).build();
    private static final SdkField<String> CONTENT_IDENTIFICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentIdentificationType").getter(StartMedicalStreamTranscriptionRequest.getter(StartMedicalStreamTranscriptionRequest::contentIdentificationTypeAsString)).setter(StartMedicalStreamTranscriptionRequest.setter(Builder::contentIdentificationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-transcribe-content-identification-type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_CODE_FIELD, MEDIA_SAMPLE_RATE_HERTZ_FIELD, MEDIA_ENCODING_FIELD, VOCABULARY_NAME_FIELD, SPECIALTY_FIELD, TYPE_FIELD, SHOW_SPEAKER_LABEL_FIELD, SESSION_ID_FIELD, ENABLE_CHANNEL_IDENTIFICATION_FIELD, NUMBER_OF_CHANNELS_FIELD, CONTENT_IDENTIFICATION_TYPE_FIELD));
    private final String languageCode;
    private final Integer mediaSampleRateHertz;
    private final String mediaEncoding;
    private final String vocabularyName;
    private final String specialty;
    private final String type;
    private final Boolean showSpeakerLabel;
    private final String sessionId;
    private final Boolean enableChannelIdentification;
    private final Integer numberOfChannels;
    private final String contentIdentificationType;

    private StartMedicalStreamTranscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.languageCode = builder.languageCode;
        this.mediaSampleRateHertz = builder.mediaSampleRateHertz;
        this.mediaEncoding = builder.mediaEncoding;
        this.vocabularyName = builder.vocabularyName;
        this.specialty = builder.specialty;
        this.type = builder.type;
        this.showSpeakerLabel = builder.showSpeakerLabel;
        this.sessionId = builder.sessionId;
        this.enableChannelIdentification = builder.enableChannelIdentification;
        this.numberOfChannels = builder.numberOfChannels;
        this.contentIdentificationType = builder.contentIdentificationType;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Integer mediaSampleRateHertz() {
        return this.mediaSampleRateHertz;
    }

    public final MediaEncoding mediaEncoding() {
        return MediaEncoding.fromValue(this.mediaEncoding);
    }

    public final String mediaEncodingAsString() {
        return this.mediaEncoding;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final Specialty specialty() {
        return Specialty.fromValue(this.specialty);
    }

    public final String specialtyAsString() {
        return this.specialty;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Boolean showSpeakerLabel() {
        return this.showSpeakerLabel;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Boolean enableChannelIdentification() {
        return this.enableChannelIdentification;
    }

    public final Integer numberOfChannels() {
        return this.numberOfChannels;
    }

    public final MedicalContentIdentificationType contentIdentificationType() {
        return MedicalContentIdentificationType.fromValue(this.contentIdentificationType);
    }

    public final String contentIdentificationTypeAsString() {
        return this.contentIdentificationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaSampleRateHertz());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.specialtyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.showSpeakerLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableChannelIdentification());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfChannels());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentIdentificationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMedicalStreamTranscriptionRequest)) {
            return false;
        }
        StartMedicalStreamTranscriptionRequest other = (StartMedicalStreamTranscriptionRequest)((Object)obj);
        return Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.mediaSampleRateHertz(), other.mediaSampleRateHertz()) && Objects.equals(this.mediaEncodingAsString(), other.mediaEncodingAsString()) && Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.specialtyAsString(), other.specialtyAsString()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.showSpeakerLabel(), other.showSpeakerLabel()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.enableChannelIdentification(), other.enableChannelIdentification()) && Objects.equals(this.numberOfChannels(), other.numberOfChannels()) && Objects.equals(this.contentIdentificationTypeAsString(), other.contentIdentificationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartMedicalStreamTranscriptionRequest").add("LanguageCode", (Object)this.languageCodeAsString()).add("MediaSampleRateHertz", (Object)this.mediaSampleRateHertz()).add("MediaEncoding", (Object)this.mediaEncodingAsString()).add("VocabularyName", (Object)this.vocabularyName()).add("Specialty", (Object)this.specialtyAsString()).add("Type", (Object)this.typeAsString()).add("ShowSpeakerLabel", (Object)this.showSpeakerLabel()).add("SessionId", (Object)this.sessionId()).add("EnableChannelIdentification", (Object)this.enableChannelIdentification()).add("NumberOfChannels", (Object)this.numberOfChannels()).add("ContentIdentificationType", (Object)this.contentIdentificationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "MediaSampleRateHertz": {
                return Optional.ofNullable(clazz.cast(this.mediaSampleRateHertz()));
            }
            case "MediaEncoding": {
                return Optional.ofNullable(clazz.cast(this.mediaEncodingAsString()));
            }
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "Specialty": {
                return Optional.ofNullable(clazz.cast(this.specialtyAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ShowSpeakerLabel": {
                return Optional.ofNullable(clazz.cast(this.showSpeakerLabel()));
            }
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "EnableChannelIdentification": {
                return Optional.ofNullable(clazz.cast(this.enableChannelIdentification()));
            }
            case "NumberOfChannels": {
                return Optional.ofNullable(clazz.cast(this.numberOfChannels()));
            }
            case "ContentIdentificationType": {
                return Optional.ofNullable(clazz.cast(this.contentIdentificationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMedicalStreamTranscriptionRequest, T> g) {
        return obj -> g.apply((StartMedicalStreamTranscriptionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeStreamingRequest.BuilderImpl
    implements Builder {
        private String languageCode;
        private Integer mediaSampleRateHertz;
        private String mediaEncoding;
        private String vocabularyName;
        private String specialty;
        private String type;
        private Boolean showSpeakerLabel;
        private String sessionId;
        private Boolean enableChannelIdentification;
        private Integer numberOfChannels;
        private String contentIdentificationType;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMedicalStreamTranscriptionRequest model) {
            super(model);
            this.languageCode(model.languageCode);
            this.mediaSampleRateHertz(model.mediaSampleRateHertz);
            this.mediaEncoding(model.mediaEncoding);
            this.vocabularyName(model.vocabularyName);
            this.specialty(model.specialty);
            this.type(model.type);
            this.showSpeakerLabel(model.showSpeakerLabel);
            this.sessionId(model.sessionId);
            this.enableChannelIdentification(model.enableChannelIdentification);
            this.numberOfChannels(model.numberOfChannels);
            this.contentIdentificationType(model.contentIdentificationType);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        @Transient
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        @Transient
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getMediaSampleRateHertz() {
            return this.mediaSampleRateHertz;
        }

        public final void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
        }

        @Override
        @Transient
        public final Builder mediaSampleRateHertz(Integer mediaSampleRateHertz) {
            this.mediaSampleRateHertz = mediaSampleRateHertz;
            return this;
        }

        public final String getMediaEncoding() {
            return this.mediaEncoding;
        }

        public final void setMediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
        }

        @Override
        @Transient
        public final Builder mediaEncoding(String mediaEncoding) {
            this.mediaEncoding = mediaEncoding;
            return this;
        }

        @Override
        @Transient
        public final Builder mediaEncoding(MediaEncoding mediaEncoding) {
            this.mediaEncoding(mediaEncoding == null ? null : mediaEncoding.toString());
            return this;
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        @Transient
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getSpecialty() {
            return this.specialty;
        }

        public final void setSpecialty(String specialty) {
            this.specialty = specialty;
        }

        @Override
        @Transient
        public final Builder specialty(String specialty) {
            this.specialty = specialty;
            return this;
        }

        @Override
        @Transient
        public final Builder specialty(Specialty specialty) {
            this.specialty(specialty == null ? null : specialty.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Boolean getShowSpeakerLabel() {
            return this.showSpeakerLabel;
        }

        public final void setShowSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
        }

        @Override
        @Transient
        public final Builder showSpeakerLabel(Boolean showSpeakerLabel) {
            this.showSpeakerLabel = showSpeakerLabel;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        @Transient
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Boolean getEnableChannelIdentification() {
            return this.enableChannelIdentification;
        }

        public final void setEnableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
        }

        @Override
        @Transient
        public final Builder enableChannelIdentification(Boolean enableChannelIdentification) {
            this.enableChannelIdentification = enableChannelIdentification;
            return this;
        }

        public final Integer getNumberOfChannels() {
            return this.numberOfChannels;
        }

        public final void setNumberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
        }

        @Override
        @Transient
        public final Builder numberOfChannels(Integer numberOfChannels) {
            this.numberOfChannels = numberOfChannels;
            return this;
        }

        public final String getContentIdentificationType() {
            return this.contentIdentificationType;
        }

        public final void setContentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(String contentIdentificationType) {
            this.contentIdentificationType = contentIdentificationType;
            return this;
        }

        @Override
        @Transient
        public final Builder contentIdentificationType(MedicalContentIdentificationType contentIdentificationType) {
            this.contentIdentificationType(contentIdentificationType == null ? null : contentIdentificationType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMedicalStreamTranscriptionRequest build() {
            return new StartMedicalStreamTranscriptionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeStreamingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMedicalStreamTranscriptionRequest> {
        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder mediaSampleRateHertz(Integer var1);

        public Builder mediaEncoding(String var1);

        public Builder mediaEncoding(MediaEncoding var1);

        public Builder vocabularyName(String var1);

        public Builder specialty(String var1);

        public Builder specialty(Specialty var1);

        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder showSpeakerLabel(Boolean var1);

        public Builder sessionId(String var1);

        public Builder enableChannelIdentification(Boolean var1);

        public Builder numberOfChannels(Integer var1);

        public Builder contentIdentificationType(String var1);

        public Builder contentIdentificationType(MedicalContentIdentificationType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

