/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribestreaming.model.ItemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Item
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Item> {
    private static final SdkField<Double> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("StartTime").getter(Item.getter(Item::startTime)).setter(Item.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Double> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("EndTime").getter(Item.getter(Item::endTime)).setter(Item.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Item.getter(Item::typeAsString)).setter(Item.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Content").getter(Item.getter(Item::content)).setter(Item.setter(Builder::content)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()}).build();
    private static final SdkField<Boolean> VOCABULARY_FILTER_MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("VocabularyFilterMatch").getter(Item.getter(Item::vocabularyFilterMatch)).setter(Item.setter(Builder::vocabularyFilterMatch)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterMatch").build()}).build();
    private static final SdkField<String> SPEAKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Speaker").getter(Item.getter(Item::speaker)).setter(Item.setter(Builder::speaker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Speaker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, END_TIME_FIELD, TYPE_FIELD, CONTENT_FIELD, VOCABULARY_FILTER_MATCH_FIELD, SPEAKER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double startTime;
    private final Double endTime;
    private final String type;
    private final String content;
    private final Boolean vocabularyFilterMatch;
    private final String speaker;

    private Item(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.type = builder.type;
        this.content = builder.content;
        this.vocabularyFilterMatch = builder.vocabularyFilterMatch;
        this.speaker = builder.speaker;
    }

    public final Double startTime() {
        return this.startTime;
    }

    public final Double endTime() {
        return this.endTime;
    }

    public final ItemType type() {
        return ItemType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String content() {
        return this.content;
    }

    public final Boolean vocabularyFilterMatch() {
        return this.vocabularyFilterMatch;
    }

    public final String speaker() {
        return this.speaker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterMatch());
        hashCode = 31 * hashCode + Objects.hashCode(this.speaker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Item)) {
            return false;
        }
        Item other = (Item)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.content(), other.content()) && Objects.equals(this.vocabularyFilterMatch(), other.vocabularyFilterMatch()) && Objects.equals(this.speaker(), other.speaker());
    }

    public final String toString() {
        return ToString.builder((String)"Item").add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Type", (Object)this.typeAsString()).add("Content", (Object)this.content()).add("VocabularyFilterMatch", (Object)this.vocabularyFilterMatch()).add("Speaker", (Object)this.speaker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "VocabularyFilterMatch": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterMatch()));
            }
            case "Speaker": {
                return Optional.ofNullable(clazz.cast(this.speaker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Item, T> g) {
        return obj -> g.apply((Item)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double startTime;
        private Double endTime;
        private String type;
        private String content;
        private Boolean vocabularyFilterMatch;
        private String speaker;

        private BuilderImpl() {
        }

        private BuilderImpl(Item model) {
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.type(model.type);
            this.content(model.content);
            this.vocabularyFilterMatch(model.vocabularyFilterMatch);
            this.speaker(model.speaker);
        }

        public final Double getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Double startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Double startTime) {
            this.startTime = startTime;
        }

        public final Double getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Double endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Double endTime) {
            this.endTime = endTime;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ItemType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getContent() {
            return this.content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final Boolean getVocabularyFilterMatch() {
            return this.vocabularyFilterMatch;
        }

        @Override
        public final Builder vocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
            return this;
        }

        public final void setVocabularyFilterMatch(Boolean vocabularyFilterMatch) {
            this.vocabularyFilterMatch = vocabularyFilterMatch;
        }

        public final String getSpeaker() {
            return this.speaker;
        }

        @Override
        public final Builder speaker(String speaker) {
            this.speaker = speaker;
            return this;
        }

        public final void setSpeaker(String speaker) {
            this.speaker = speaker;
        }

        public Item build() {
            return new Item(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Item> {
        public Builder startTime(Double var1);

        public Builder endTime(Double var1);

        public Builder type(String var1);

        public Builder type(ItemType var1);

        public Builder content(String var1);

        public Builder vocabularyFilterMatch(Boolean var1);

        public Builder speaker(String var1);
    }
}

