/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribestreaming.model.AudioStream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioEvent>,
AudioStream {
    private static final SdkField<SdkBytes> AUDIO_CHUNK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(AudioEvent.getter(AudioEvent::audioChunk)).setter(AudioEvent.setter(Builder::audioChunk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudioChunk").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_CHUNK_FIELD));
    private static final long serialVersionUID = 1L;
    private final SdkBytes audioChunk;

    private AudioEvent(BuilderImpl builder) {
        this.audioChunk = builder.audioChunk;
    }

    public SdkBytes audioChunk() {
        return this.audioChunk;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioChunk());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioEvent)) {
            return false;
        }
        AudioEvent other = (AudioEvent)obj;
        return Objects.equals(this.audioChunk(), other.audioChunk());
    }

    public String toString() {
        return ToString.builder((String)"AudioEvent").add("AudioChunk", (Object)this.audioChunk()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioChunk": {
                return Optional.ofNullable(clazz.cast(this.audioChunk()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AudioEvent, T> g) {
        return obj -> g.apply((AudioEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SdkBytes audioChunk;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioEvent model) {
            this.audioChunk(model.audioChunk);
        }

        public final ByteBuffer getAudioChunk() {
            return this.audioChunk == null ? null : this.audioChunk.asByteBuffer();
        }

        @Override
        public final Builder audioChunk(SdkBytes audioChunk) {
            this.audioChunk = StandardMemberCopier.copy((SdkBytes)audioChunk);
            return this;
        }

        public final void setAudioChunk(ByteBuffer audioChunk) {
            this.audioChunk(audioChunk == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)audioChunk));
        }

        public AudioEvent build() {
            return new AudioEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioEvent> {
        public Builder audioChunk(SdkBytes var1);
    }
}

