/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.SubtitleFormat;
import software.amazon.awssdk.services.transcribe.model.SubtitleFormatsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subtitles
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subtitles> {
    private static final SdkField<List<String>> FORMATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Formats").getter(Subtitles.getter(Subtitles::formatsAsStrings)).setter(Subtitles.setter(Builder::formatsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Formats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> OUTPUT_START_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("OutputStartIndex").getter(Subtitles.getter(Subtitles::outputStartIndex)).setter(Subtitles.setter(Builder::outputStartIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputStartIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMATS_FIELD, OUTPUT_START_INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Subtitles.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> formats;
    private final Integer outputStartIndex;

    private Subtitles(BuilderImpl builder) {
        this.formats = builder.formats;
        this.outputStartIndex = builder.outputStartIndex;
    }

    public final List<SubtitleFormat> formats() {
        return SubtitleFormatsCopier.copyStringToEnum(this.formats);
    }

    public final boolean hasFormats() {
        return this.formats != null && !(this.formats instanceof SdkAutoConstructList);
    }

    public final List<String> formatsAsStrings() {
        return this.formats;
    }

    public final Integer outputStartIndex() {
        return this.outputStartIndex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormats() ? this.formatsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputStartIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subtitles)) {
            return false;
        }
        Subtitles other = (Subtitles)obj;
        return this.hasFormats() == other.hasFormats() && Objects.equals(this.formatsAsStrings(), other.formatsAsStrings()) && Objects.equals(this.outputStartIndex(), other.outputStartIndex());
    }

    public final String toString() {
        return ToString.builder((String)"Subtitles").add("Formats", this.hasFormats() ? this.formatsAsStrings() : null).add("OutputStartIndex", (Object)this.outputStartIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Formats": {
                return Optional.ofNullable(clazz.cast(this.formatsAsStrings()));
            }
            case "OutputStartIndex": {
                return Optional.ofNullable(clazz.cast(this.outputStartIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Formats", FORMATS_FIELD);
        map.put("OutputStartIndex", OUTPUT_START_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Subtitles, T> g) {
        return obj -> g.apply((Subtitles)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> formats = DefaultSdkAutoConstructList.getInstance();
        private Integer outputStartIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(Subtitles model) {
            this.formatsWithStrings(model.formats);
            this.outputStartIndex(model.outputStartIndex);
        }

        public final Collection<String> getFormats() {
            if (this.formats instanceof SdkAutoConstructList) {
                return null;
            }
            return this.formats;
        }

        public final void setFormats(Collection<String> formats) {
            this.formats = SubtitleFormatsCopier.copy(formats);
        }

        @Override
        public final Builder formatsWithStrings(Collection<String> formats) {
            this.formats = SubtitleFormatsCopier.copy(formats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formatsWithStrings(String ... formats) {
            this.formatsWithStrings(Arrays.asList(formats));
            return this;
        }

        @Override
        public final Builder formats(Collection<SubtitleFormat> formats) {
            this.formats = SubtitleFormatsCopier.copyEnumToString(formats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formats(SubtitleFormat ... formats) {
            this.formats(Arrays.asList(formats));
            return this;
        }

        public final Integer getOutputStartIndex() {
            return this.outputStartIndex;
        }

        public final void setOutputStartIndex(Integer outputStartIndex) {
            this.outputStartIndex = outputStartIndex;
        }

        @Override
        public final Builder outputStartIndex(Integer outputStartIndex) {
            this.outputStartIndex = outputStartIndex;
            return this;
        }

        public Subtitles build() {
            return new Subtitles(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subtitles> {
        public Builder formatsWithStrings(Collection<String> var1);

        public Builder formatsWithStrings(String ... var1);

        public Builder formats(Collection<SubtitleFormat> var1);

        public Builder formats(SubtitleFormat ... var1);

        public Builder outputStartIndex(Integer var1);
    }
}

