/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.Tag;
import software.amazon.awssdk.services.transcribe.model.TagListCopier;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMedicalVocabularyRequest
extends TranscribeRequest
implements ToCopyableBuilder<Builder, CreateMedicalVocabularyRequest> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(CreateMedicalVocabularyRequest.getter(CreateMedicalVocabularyRequest::vocabularyName)).setter(CreateMedicalVocabularyRequest.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(CreateMedicalVocabularyRequest.getter(CreateMedicalVocabularyRequest::languageCodeAsString)).setter(CreateMedicalVocabularyRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<String> VOCABULARY_FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFileUri").getter(CreateMedicalVocabularyRequest.getter(CreateMedicalVocabularyRequest::vocabularyFileUri)).setter(CreateMedicalVocabularyRequest.setter(Builder::vocabularyFileUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFileUri").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMedicalVocabularyRequest.getter(CreateMedicalVocabularyRequest::tags)).setter(CreateMedicalVocabularyRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD, LANGUAGE_CODE_FIELD, VOCABULARY_FILE_URI_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMedicalVocabularyRequest.memberNameToFieldInitializer();
    private final String vocabularyName;
    private final String languageCode;
    private final String vocabularyFileUri;
    private final List<Tag> tags;

    private CreateMedicalVocabularyRequest(BuilderImpl builder) {
        super(builder);
        this.vocabularyName = builder.vocabularyName;
        this.languageCode = builder.languageCode;
        this.vocabularyFileUri = builder.vocabularyFileUri;
        this.tags = builder.tags;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final String vocabularyFileUri() {
        return this.vocabularyFileUri;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFileUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMedicalVocabularyRequest)) {
            return false;
        }
        CreateMedicalVocabularyRequest other = (CreateMedicalVocabularyRequest)((Object)obj);
        return Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.vocabularyFileUri(), other.vocabularyFileUri()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMedicalVocabularyRequest").add("VocabularyName", (Object)this.vocabularyName()).add("LanguageCode", (Object)this.languageCodeAsString()).add("VocabularyFileUri", (Object)this.vocabularyFileUri()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "VocabularyFileUri": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFileUri()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VocabularyName", VOCABULARY_NAME_FIELD);
        map.put("LanguageCode", LANGUAGE_CODE_FIELD);
        map.put("VocabularyFileUri", VOCABULARY_FILE_URI_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMedicalVocabularyRequest, T> g) {
        return obj -> g.apply((CreateMedicalVocabularyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeRequest.BuilderImpl
    implements Builder {
        private String vocabularyName;
        private String languageCode;
        private String vocabularyFileUri;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMedicalVocabularyRequest model) {
            super(model);
            this.vocabularyName(model.vocabularyName);
            this.languageCode(model.languageCode);
            this.vocabularyFileUri(model.vocabularyFileUri);
            this.tags(model.tags);
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getVocabularyFileUri() {
            return this.vocabularyFileUri;
        }

        public final void setVocabularyFileUri(String vocabularyFileUri) {
            this.vocabularyFileUri = vocabularyFileUri;
        }

        @Override
        public final Builder vocabularyFileUri(String vocabularyFileUri) {
            this.vocabularyFileUri = vocabularyFileUri;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMedicalVocabularyRequest build() {
            return new CreateMedicalVocabularyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TranscribeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMedicalVocabularyRequest> {
        public Builder vocabularyName(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder vocabularyFileUri(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

