/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.Tag;
import software.amazon.awssdk.services.transcribe.model.TagListCopier;
import software.amazon.awssdk.services.transcribe.model.TranscribeRequest;
import software.amazon.awssdk.services.transcribe.model.WordsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVocabularyFilterRequest
extends TranscribeRequest
implements ToCopyableBuilder<Builder, CreateVocabularyFilterRequest> {
    private static final SdkField<String> VOCABULARY_FILTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterName").getter(CreateVocabularyFilterRequest.getter(CreateVocabularyFilterRequest::vocabularyFilterName)).setter(CreateVocabularyFilterRequest.setter(Builder::vocabularyFilterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterName").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(CreateVocabularyFilterRequest.getter(CreateVocabularyFilterRequest::languageCodeAsString)).setter(CreateVocabularyFilterRequest.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<List<String>> WORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Words").getter(CreateVocabularyFilterRequest.getter(CreateVocabularyFilterRequest::words)).setter(CreateVocabularyFilterRequest.setter(Builder::words)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Words").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VOCABULARY_FILTER_FILE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyFilterFileUri").getter(CreateVocabularyFilterRequest.getter(CreateVocabularyFilterRequest::vocabularyFilterFileUri)).setter(CreateVocabularyFilterRequest.setter(Builder::vocabularyFilterFileUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyFilterFileUri").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateVocabularyFilterRequest.getter(CreateVocabularyFilterRequest::tags)).setter(CreateVocabularyFilterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_FILTER_NAME_FIELD, LANGUAGE_CODE_FIELD, WORDS_FIELD, VOCABULARY_FILTER_FILE_URI_FIELD, TAGS_FIELD));
    private final String vocabularyFilterName;
    private final String languageCode;
    private final List<String> words;
    private final String vocabularyFilterFileUri;
    private final List<Tag> tags;

    private CreateVocabularyFilterRequest(BuilderImpl builder) {
        super(builder);
        this.vocabularyFilterName = builder.vocabularyFilterName;
        this.languageCode = builder.languageCode;
        this.words = builder.words;
        this.vocabularyFilterFileUri = builder.vocabularyFilterFileUri;
        this.tags = builder.tags;
    }

    public final String vocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final boolean hasWords() {
        return this.words != null && !(this.words instanceof SdkAutoConstructList);
    }

    public final List<String> words() {
        return this.words;
    }

    public final String vocabularyFilterFileUri() {
        return this.vocabularyFilterFileUri;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWords() ? this.words() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyFilterFileUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVocabularyFilterRequest)) {
            return false;
        }
        CreateVocabularyFilterRequest other = (CreateVocabularyFilterRequest)((Object)obj);
        return Objects.equals(this.vocabularyFilterName(), other.vocabularyFilterName()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && this.hasWords() == other.hasWords() && Objects.equals(this.words(), other.words()) && Objects.equals(this.vocabularyFilterFileUri(), other.vocabularyFilterFileUri()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVocabularyFilterRequest").add("VocabularyFilterName", (Object)this.vocabularyFilterName()).add("LanguageCode", (Object)this.languageCodeAsString()).add("Words", this.hasWords() ? this.words() : null).add("VocabularyFilterFileUri", (Object)this.vocabularyFilterFileUri()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularyFilterName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterName()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "Words": {
                return Optional.ofNullable(clazz.cast(this.words()));
            }
            case "VocabularyFilterFileUri": {
                return Optional.ofNullable(clazz.cast(this.vocabularyFilterFileUri()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVocabularyFilterRequest, T> g) {
        return obj -> g.apply((CreateVocabularyFilterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranscribeRequest.BuilderImpl
    implements Builder {
        private String vocabularyFilterName;
        private String languageCode;
        private List<String> words = DefaultSdkAutoConstructList.getInstance();
        private String vocabularyFilterFileUri;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVocabularyFilterRequest model) {
            super(model);
            this.vocabularyFilterName(model.vocabularyFilterName);
            this.languageCode(model.languageCode);
            this.words(model.words);
            this.vocabularyFilterFileUri(model.vocabularyFilterFileUri);
            this.tags(model.tags);
        }

        public final String getVocabularyFilterName() {
            return this.vocabularyFilterName;
        }

        public final void setVocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
        }

        @Override
        public final Builder vocabularyFilterName(String vocabularyFilterName) {
            this.vocabularyFilterName = vocabularyFilterName;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Collection<String> getWords() {
            if (this.words instanceof SdkAutoConstructList) {
                return null;
            }
            return this.words;
        }

        public final void setWords(Collection<String> words) {
            this.words = WordsCopier.copy(words);
        }

        @Override
        public final Builder words(Collection<String> words) {
            this.words = WordsCopier.copy(words);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder words(String ... words) {
            this.words(Arrays.asList(words));
            return this;
        }

        public final String getVocabularyFilterFileUri() {
            return this.vocabularyFilterFileUri;
        }

        public final void setVocabularyFilterFileUri(String vocabularyFilterFileUri) {
            this.vocabularyFilterFileUri = vocabularyFilterFileUri;
        }

        @Override
        public final Builder vocabularyFilterFileUri(String vocabularyFilterFileUri) {
            this.vocabularyFilterFileUri = vocabularyFilterFileUri;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVocabularyFilterRequest build() {
            return new CreateVocabularyFilterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranscribeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVocabularyFilterRequest> {
        public Builder vocabularyFilterName(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder words(Collection<String> var1);

        public Builder words(String ... var1);

        public Builder vocabularyFilterFileUri(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

