/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.transcribe.model.LanguageCode;
import software.amazon.awssdk.services.transcribe.model.VocabularyState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VocabularyInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VocabularyInfo> {
    private static final SdkField<String> VOCABULARY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyName").getter(VocabularyInfo.getter(VocabularyInfo::vocabularyName)).setter(VocabularyInfo.setter(Builder::vocabularyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyName").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(VocabularyInfo.getter(VocabularyInfo::languageCodeAsString)).setter(VocabularyInfo.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(VocabularyInfo.getter(VocabularyInfo::lastModifiedTime)).setter(VocabularyInfo.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> VOCABULARY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VocabularyState").getter(VocabularyInfo.getter(VocabularyInfo::vocabularyStateAsString)).setter(VocabularyInfo.setter(Builder::vocabularyState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VocabularyState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOCABULARY_NAME_FIELD, LANGUAGE_CODE_FIELD, LAST_MODIFIED_TIME_FIELD, VOCABULARY_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String vocabularyName;
    private final String languageCode;
    private final Instant lastModifiedTime;
    private final String vocabularyState;

    private VocabularyInfo(BuilderImpl builder) {
        this.vocabularyName = builder.vocabularyName;
        this.languageCode = builder.languageCode;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.vocabularyState = builder.vocabularyState;
    }

    public final String vocabularyName() {
        return this.vocabularyName;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final VocabularyState vocabularyState() {
        return VocabularyState.fromValue(this.vocabularyState);
    }

    public final String vocabularyStateAsString() {
        return this.vocabularyState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.vocabularyStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VocabularyInfo)) {
            return false;
        }
        VocabularyInfo other = (VocabularyInfo)obj;
        return Objects.equals(this.vocabularyName(), other.vocabularyName()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.vocabularyStateAsString(), other.vocabularyStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VocabularyInfo").add("VocabularyName", (Object)this.vocabularyName()).add("LanguageCode", (Object)this.languageCodeAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("VocabularyState", (Object)this.vocabularyStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VocabularyName": {
                return Optional.ofNullable(clazz.cast(this.vocabularyName()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "VocabularyState": {
                return Optional.ofNullable(clazz.cast(this.vocabularyStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VocabularyInfo, T> g) {
        return obj -> g.apply((VocabularyInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vocabularyName;
        private String languageCode;
        private Instant lastModifiedTime;
        private String vocabularyState;

        private BuilderImpl() {
        }

        private BuilderImpl(VocabularyInfo model) {
            this.vocabularyName(model.vocabularyName);
            this.languageCode(model.languageCode);
            this.lastModifiedTime(model.lastModifiedTime);
            this.vocabularyState(model.vocabularyState);
        }

        public final String getVocabularyName() {
            return this.vocabularyName;
        }

        public final void setVocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
        }

        @Override
        public final Builder vocabularyName(String vocabularyName) {
            this.vocabularyName = vocabularyName;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getVocabularyState() {
            return this.vocabularyState;
        }

        public final void setVocabularyState(String vocabularyState) {
            this.vocabularyState = vocabularyState;
        }

        @Override
        public final Builder vocabularyState(String vocabularyState) {
            this.vocabularyState = vocabularyState;
            return this;
        }

        @Override
        public final Builder vocabularyState(VocabularyState vocabularyState) {
            this.vocabularyState(vocabularyState == null ? null : vocabularyState.toString());
            return this;
        }

        public VocabularyInfo build() {
            return new VocabularyInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VocabularyInfo> {
        public Builder vocabularyName(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder vocabularyState(String var1);

        public Builder vocabularyState(VocabularyState var1);
    }
}

