/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSolNetworkOperationsResponse extends TnbResponse implements
        ToCopyableBuilder<ListSolNetworkOperationsResponse.Builder, ListSolNetworkOperationsResponse> {
    private static final SdkField<List<ListSolNetworkOperationsInfo>> NETWORK_OPERATIONS_FIELD = SdkField
            .<List<ListSolNetworkOperationsInfo>> builder(MarshallingType.LIST)
            .memberName("networkOperations")
            .getter(getter(ListSolNetworkOperationsResponse::networkOperations))
            .setter(setter(Builder::networkOperations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkOperations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListSolNetworkOperationsInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListSolNetworkOperationsInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSolNetworkOperationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_OPERATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ListSolNetworkOperationsInfo> networkOperations;

    private final String nextToken;

    private ListSolNetworkOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.networkOperations = builder.networkOperations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkOperations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkOperations() {
        return networkOperations != null && !(networkOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists network operation occurrences. Lifecycle management operations are deploy, update, or delete operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkOperations} method.
     * </p>
     * 
     * @return Lists network operation occurrences. Lifecycle management operations are deploy, update, or delete
     *         operations.
     */
    public final List<ListSolNetworkOperationsInfo> networkOperations() {
        return networkOperations;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkOperations() ? networkOperations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolNetworkOperationsResponse)) {
            return false;
        }
        ListSolNetworkOperationsResponse other = (ListSolNetworkOperationsResponse) obj;
        return hasNetworkOperations() == other.hasNetworkOperations()
                && Objects.equals(networkOperations(), other.networkOperations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSolNetworkOperationsResponse")
                .add("NetworkOperations", hasNetworkOperations() ? networkOperations() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "networkOperations":
            return Optional.ofNullable(clazz.cast(networkOperations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("networkOperations", NETWORK_OPERATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSolNetworkOperationsResponse, T> g) {
        return obj -> g.apply((ListSolNetworkOperationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TnbResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSolNetworkOperationsResponse> {
        /**
         * <p>
         * Lists network operation occurrences. Lifecycle management operations are deploy, update, or delete
         * operations.
         * </p>
         * 
         * @param networkOperations
         *        Lists network operation occurrences. Lifecycle management operations are deploy, update, or delete
         *        operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkOperations(Collection<ListSolNetworkOperationsInfo> networkOperations);

        /**
         * <p>
         * Lists network operation occurrences. Lifecycle management operations are deploy, update, or delete
         * operations.
         * </p>
         * 
         * @param networkOperations
         *        Lists network operation occurrences. Lifecycle management operations are deploy, update, or delete
         *        operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkOperations(ListSolNetworkOperationsInfo... networkOperations);

        /**
         * <p>
         * Lists network operation occurrences. Lifecycle management operations are deploy, update, or delete
         * operations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsInfo.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #networkOperations(List<ListSolNetworkOperationsInfo>)}.
         * 
         * @param networkOperations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkOperations(java.util.Collection<ListSolNetworkOperationsInfo>)
         */
        Builder networkOperations(Consumer<ListSolNetworkOperationsInfo.Builder>... networkOperations);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends TnbResponse.BuilderImpl implements Builder {
        private List<ListSolNetworkOperationsInfo> networkOperations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolNetworkOperationsResponse model) {
            super(model);
            networkOperations(model.networkOperations);
            nextToken(model.nextToken);
        }

        public final List<ListSolNetworkOperationsInfo.Builder> getNetworkOperations() {
            List<ListSolNetworkOperationsInfo.Builder> result = ListSolNetworkOperationsResourcesCopier
                    .copyToBuilder(this.networkOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkOperations(Collection<ListSolNetworkOperationsInfo.BuilderImpl> networkOperations) {
            this.networkOperations = ListSolNetworkOperationsResourcesCopier.copyFromBuilder(networkOperations);
        }

        @Override
        public final Builder networkOperations(Collection<ListSolNetworkOperationsInfo> networkOperations) {
            this.networkOperations = ListSolNetworkOperationsResourcesCopier.copy(networkOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkOperations(ListSolNetworkOperationsInfo... networkOperations) {
            networkOperations(Arrays.asList(networkOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkOperations(Consumer<ListSolNetworkOperationsInfo.Builder>... networkOperations) {
            networkOperations(Stream.of(networkOperations)
                    .map(c -> ListSolNetworkOperationsInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSolNetworkOperationsResponse build() {
            return new ListSolNetworkOperationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
