/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a network function.
 * </p>
 * <p>
 * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
 * life-cycle operations (like terminate, update, and delete) can be performed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolInstantiatedVnfInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<GetSolInstantiatedVnfInfo.Builder, GetSolInstantiatedVnfInfo> {
    private static final SdkField<String> VNF_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfState").getter(getter(GetSolInstantiatedVnfInfo::vnfStateAsString)).setter(setter(Builder::vnfState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VNF_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vnfState;

    private GetSolInstantiatedVnfInfo(BuilderImpl builder) {
        this.vnfState = builder.vnfState;
    }

    /**
     * <p>
     * State of the network function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vnfState} will
     * return {@link VnfOperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vnfStateAsString}.
     * </p>
     * 
     * @return State of the network function.
     * @see VnfOperationalState
     */
    public final VnfOperationalState vnfState() {
        return VnfOperationalState.fromValue(vnfState);
    }

    /**
     * <p>
     * State of the network function.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vnfState} will
     * return {@link VnfOperationalState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #vnfStateAsString}.
     * </p>
     * 
     * @return State of the network function.
     * @see VnfOperationalState
     */
    public final String vnfStateAsString() {
        return vnfState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vnfStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolInstantiatedVnfInfo)) {
            return false;
        }
        GetSolInstantiatedVnfInfo other = (GetSolInstantiatedVnfInfo) obj;
        return Objects.equals(vnfStateAsString(), other.vnfStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolInstantiatedVnfInfo").add("VnfState", vnfStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vnfState":
            return Optional.ofNullable(clazz.cast(vnfStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vnfState", VNF_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolInstantiatedVnfInfo, T> g) {
        return obj -> g.apply((GetSolInstantiatedVnfInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GetSolInstantiatedVnfInfo> {
        /**
         * <p>
         * State of the network function.
         * </p>
         * 
         * @param vnfState
         *        State of the network function.
         * @see VnfOperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VnfOperationalState
         */
        Builder vnfState(String vnfState);

        /**
         * <p>
         * State of the network function.
         * </p>
         * 
         * @param vnfState
         *        State of the network function.
         * @see VnfOperationalState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VnfOperationalState
         */
        Builder vnfState(VnfOperationalState vnfState);
    }

    static final class BuilderImpl implements Builder {
        private String vnfState;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolInstantiatedVnfInfo model) {
            vnfState(model.vnfState);
        }

        public final String getVnfState() {
            return vnfState;
        }

        public final void setVnfState(String vnfState) {
            this.vnfState = vnfState;
        }

        @Override
        public final Builder vnfState(String vnfState) {
            this.vnfState = vnfState;
            return this;
        }

        @Override
        public final Builder vnfState(VnfOperationalState vnfState) {
            this.vnfState(vnfState == null ? null : vnfState.toString());
            return this;
        }

        @Override
        public GetSolInstantiatedVnfInfo build() {
            return new GetSolInstantiatedVnfInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
