/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSolFunctionPackageContentRequest extends TnbRequest implements
        ToCopyableBuilder<GetSolFunctionPackageContentRequest.Builder, GetSolFunctionPackageContentRequest> {
    private static final SdkField<String> ACCEPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("accept")
            .getter(getter(GetSolFunctionPackageContentRequest::acceptAsString)).setter(setter(Builder::accept))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()).build();

    private static final SdkField<String> VNF_PKG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vnfPkgId").getter(getter(GetSolFunctionPackageContentRequest::vnfPkgId))
            .setter(setter(Builder::vnfPkgId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("vnfPkgId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACCEPT_FIELD, VNF_PKG_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accept;

    private final String vnfPkgId;

    private GetSolFunctionPackageContentRequest(BuilderImpl builder) {
        super(builder);
        this.accept = builder.accept;
        this.vnfPkgId = builder.vnfPkgId;
    }

    /**
     * <p>
     * The format of the package that you want to download from the function packages.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accept} will
     * return {@link PackageContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceptAsString}.
     * </p>
     * 
     * @return The format of the package that you want to download from the function packages.
     * @see PackageContentType
     */
    public final PackageContentType accept() {
        return PackageContentType.fromValue(accept);
    }

    /**
     * <p>
     * The format of the package that you want to download from the function packages.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accept} will
     * return {@link PackageContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceptAsString}.
     * </p>
     * 
     * @return The format of the package that you want to download from the function packages.
     * @see PackageContentType
     */
    public final String acceptAsString() {
        return accept;
    }

    /**
     * <p>
     * ID of the function package.
     * </p>
     * 
     * @return ID of the function package.
     */
    public final String vnfPkgId() {
        return vnfPkgId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vnfPkgId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolFunctionPackageContentRequest)) {
            return false;
        }
        GetSolFunctionPackageContentRequest other = (GetSolFunctionPackageContentRequest) obj;
        return Objects.equals(acceptAsString(), other.acceptAsString()) && Objects.equals(vnfPkgId(), other.vnfPkgId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSolFunctionPackageContentRequest").add("Accept", acceptAsString())
                .add("VnfPkgId", vnfPkgId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accept":
            return Optional.ofNullable(clazz.cast(acceptAsString()));
        case "vnfPkgId":
            return Optional.ofNullable(clazz.cast(vnfPkgId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Accept", ACCEPT_FIELD);
        map.put("vnfPkgId", VNF_PKG_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolFunctionPackageContentRequest, T> g) {
        return obj -> g.apply((GetSolFunctionPackageContentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TnbRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSolFunctionPackageContentRequest> {
        /**
         * <p>
         * The format of the package that you want to download from the function packages.
         * </p>
         * 
         * @param accept
         *        The format of the package that you want to download from the function packages.
         * @see PackageContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageContentType
         */
        Builder accept(String accept);

        /**
         * <p>
         * The format of the package that you want to download from the function packages.
         * </p>
         * 
         * @param accept
         *        The format of the package that you want to download from the function packages.
         * @see PackageContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageContentType
         */
        Builder accept(PackageContentType accept);

        /**
         * <p>
         * ID of the function package.
         * </p>
         * 
         * @param vnfPkgId
         *        ID of the function package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vnfPkgId(String vnfPkgId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TnbRequest.BuilderImpl implements Builder {
        private String accept;

        private String vnfPkgId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolFunctionPackageContentRequest model) {
            super(model);
            accept(model.accept);
            vnfPkgId(model.vnfPkgId);
        }

        public final String getAccept() {
            return accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        @Override
        public final Builder accept(PackageContentType accept) {
            this.accept(accept == null ? null : accept.toString());
            return this;
        }

        public final String getVnfPkgId() {
            return vnfPkgId;
        }

        public final void setVnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
        }

        @Override
        public final Builder vnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSolFunctionPackageContentRequest build() {
            return new GetSolFunctionPackageContentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
