/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.tnb;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.tnb.model.CancelSolNetworkOperationRequest;
import software.amazon.awssdk.services.tnb.model.CancelSolNetworkOperationResponse;
import software.amazon.awssdk.services.tnb.model.CreateSolFunctionPackageRequest;
import software.amazon.awssdk.services.tnb.model.CreateSolFunctionPackageResponse;
import software.amazon.awssdk.services.tnb.model.CreateSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.CreateSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.CreateSolNetworkPackageRequest;
import software.amazon.awssdk.services.tnb.model.CreateSolNetworkPackageResponse;
import software.amazon.awssdk.services.tnb.model.DeleteSolFunctionPackageRequest;
import software.amazon.awssdk.services.tnb.model.DeleteSolFunctionPackageResponse;
import software.amazon.awssdk.services.tnb.model.DeleteSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.DeleteSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.DeleteSolNetworkPackageRequest;
import software.amazon.awssdk.services.tnb.model.DeleteSolNetworkPackageResponse;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionInstanceRequest;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionInstanceResponse;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageDescriptorRequest;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageDescriptorResponse;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageRequest;
import software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageDescriptorRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageDescriptorResponse;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageRequest;
import software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageResponse;
import software.amazon.awssdk.services.tnb.model.InstantiateSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.InstantiateSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesResponse;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesResponse;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesResponse;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsResponse;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesResponse;
import software.amazon.awssdk.services.tnb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.tnb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.tnb.model.PutSolFunctionPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.PutSolFunctionPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.PutSolNetworkPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.PutSolNetworkPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.TagResourceRequest;
import software.amazon.awssdk.services.tnb.model.TagResourceResponse;
import software.amazon.awssdk.services.tnb.model.TerminateSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.TerminateSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.UntagResourceRequest;
import software.amazon.awssdk.services.tnb.model.UntagResourceResponse;
import software.amazon.awssdk.services.tnb.model.UpdateSolFunctionPackageRequest;
import software.amazon.awssdk.services.tnb.model.UpdateSolFunctionPackageResponse;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkInstanceRequest;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkInstanceResponse;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkPackageRequest;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkPackageResponse;
import software.amazon.awssdk.services.tnb.model.ValidateSolFunctionPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.ValidateSolFunctionPackageContentResponse;
import software.amazon.awssdk.services.tnb.model.ValidateSolNetworkPackageContentRequest;
import software.amazon.awssdk.services.tnb.model.ValidateSolNetworkPackageContentResponse;
import software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesPublisher;
import software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesPublisher;
import software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesPublisher;
import software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsPublisher;
import software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesPublisher;

/**
 * Service client for accessing AWS Telco Network Builder asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon Web Services Telco Network Builder (TNB) is a network automation service that helps you deploy and manage
 * telecom networks. AWS TNB helps you with the lifecycle management of your telecommunication network functions
 * throughout planning, deployment, and post-deployment activities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TnbAsyncClient extends AwsClient {
    String SERVICE_NAME = "tnb";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "tnb";

    /**
     * <p>
     * Cancels a network operation.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     *
     * @param cancelSolNetworkOperationRequest
     * @return A Java Future containing the result of the CancelSolNetworkOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.CancelSolNetworkOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CancelSolNetworkOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSolNetworkOperationResponse> cancelSolNetworkOperation(
            CancelSolNetworkOperationRequest cancelSolNetworkOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a network operation.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSolNetworkOperationRequest.Builder} avoiding
     * the need to create one manually via {@link CancelSolNetworkOperationRequest#builder()}
     * </p>
     *
     * @param cancelSolNetworkOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.CancelSolNetworkOperationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelSolNetworkOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.CancelSolNetworkOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CancelSolNetworkOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelSolNetworkOperationResponse> cancelSolNetworkOperation(
            Consumer<CancelSolNetworkOperationRequest.Builder> cancelSolNetworkOperationRequest) {
        return cancelSolNetworkOperation(CancelSolNetworkOperationRequest.builder()
                .applyMutation(cancelSolNetworkOperationRequest).build());
    }

    /**
     * <p>
     * Creates a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network. For more information, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html">Function packages</a> in the <i>Amazon
     * Web Services Telco Network Builder User Guide</i>.
     * </p>
     * <p>
     * Creating a function package is the first step for creating a network in AWS TNB. This request creates an empty
     * container with an ID. The next step is to upload the actual CSAR zip file into that empty container. To upload
     * function package content, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html"
     * >PutSolFunctionPackageContent</a>.
     * </p>
     *
     * @param createSolFunctionPackageRequest
     * @return A Java Future containing the result of the CreateSolFunctionPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ServiceQuotaExceededException Service quotas have been exceeded.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.CreateSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolFunctionPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSolFunctionPackageResponse> createSolFunctionPackage(
            CreateSolFunctionPackageRequest createSolFunctionPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network. For more information, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/ug/function-packages.html">Function packages</a> in the <i>Amazon
     * Web Services Telco Network Builder User Guide</i>.
     * </p>
     * <p>
     * Creating a function package is the first step for creating a network in AWS TNB. This request creates an empty
     * container with an ID. The next step is to upload the actual CSAR zip file into that empty container. To upload
     * function package content, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html"
     * >PutSolFunctionPackageContent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSolFunctionPackageRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSolFunctionPackageRequest#builder()}
     * </p>
     *
     * @param createSolFunctionPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.CreateSolFunctionPackageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSolFunctionPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ServiceQuotaExceededException Service quotas have been exceeded.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.CreateSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolFunctionPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSolFunctionPackageResponse> createSolFunctionPackage(
            Consumer<CreateSolFunctionPackageRequest.Builder> createSolFunctionPackageRequest) {
        return createSolFunctionPackage(CreateSolFunctionPackageRequest.builder().applyMutation(createSolFunctionPackageRequest)
                .build());
    }

    /**
     * <p>
     * Creates a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed. Creating a network instance is the
     * third step after creating a network package. For more information about network instances, <a
     * href="https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html">Network instances</a> in the <i>Amazon
     * Web Services Telco Network Builder User Guide</i>.
     * </p>
     * <p>
     * Once you create a network instance, you can instantiate it. To instantiate a network, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_InstantiateSolNetworkInstance.html"
     * >InstantiateSolNetworkInstance</a>.
     * </p>
     *
     * @param createSolNetworkInstanceRequest
     * @return A Java Future containing the result of the CreateSolNetworkInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ServiceQuotaExceededException Service quotas have been exceeded.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.CreateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolNetworkInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSolNetworkInstanceResponse> createSolNetworkInstance(
            CreateSolNetworkInstanceRequest createSolNetworkInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed. Creating a network instance is the
     * third step after creating a network package. For more information about network instances, <a
     * href="https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html">Network instances</a> in the <i>Amazon
     * Web Services Telco Network Builder User Guide</i>.
     * </p>
     * <p>
     * Once you create a network instance, you can instantiate it. To instantiate a network, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_InstantiateSolNetworkInstance.html"
     * >InstantiateSolNetworkInstance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSolNetworkInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSolNetworkInstanceRequest#builder()}
     * </p>
     *
     * @param createSolNetworkInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.CreateSolNetworkInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSolNetworkInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ServiceQuotaExceededException Service quotas have been exceeded.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.CreateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolNetworkInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSolNetworkInstanceResponse> createSolNetworkInstance(
            Consumer<CreateSolNetworkInstanceRequest.Builder> createSolNetworkInstanceRequest) {
        return createSolNetworkInstance(CreateSolNetworkInstanceRequest.builder().applyMutation(createSolNetworkInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Creates a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on. For more information, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html">Network instances</a> in the <i>Amazon
     * Web Services Telco Network Builder User Guide</i>.
     * </p>
     * <p>
     * A network package consists of a network service descriptor (NSD) file (required) and any additional files
     * (optional), such as scripts specific to your needs. For example, if you have multiple function packages in your
     * network package, you can use the NSD to define which network functions should run in certain VPCs, subnets, or
     * EKS clusters.
     * </p>
     * <p>
     * This request creates an empty network package container with an ID. Once you create a network package, you can
     * upload the network package content using <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html"
     * >PutSolNetworkPackageContent</a>.
     * </p>
     *
     * @param createSolNetworkPackageRequest
     * @return A Java Future containing the result of the CreateSolNetworkPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ServiceQuotaExceededException Service quotas have been exceeded.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.CreateSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolNetworkPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSolNetworkPackageResponse> createSolNetworkPackage(
            CreateSolNetworkPackageRequest createSolNetworkPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on. For more information, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/ug/network-instances.html">Network instances</a> in the <i>Amazon
     * Web Services Telco Network Builder User Guide</i>.
     * </p>
     * <p>
     * A network package consists of a network service descriptor (NSD) file (required) and any additional files
     * (optional), such as scripts specific to your needs. For example, if you have multiple function packages in your
     * network package, you can use the NSD to define which network functions should run in certain VPCs, subnets, or
     * EKS clusters.
     * </p>
     * <p>
     * This request creates an empty network package container with an ID. Once you create a network package, you can
     * upload the network package content using <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html"
     * >PutSolNetworkPackageContent</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSolNetworkPackageRequest.Builder} avoiding
     * the need to create one manually via {@link CreateSolNetworkPackageRequest#builder()}
     * </p>
     *
     * @param createSolNetworkPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.CreateSolNetworkPackageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSolNetworkPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ServiceQuotaExceededException Service quotas have been exceeded.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.CreateSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/CreateSolNetworkPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateSolNetworkPackageResponse> createSolNetworkPackage(
            Consumer<CreateSolNetworkPackageRequest.Builder> createSolNetworkPackageRequest) {
        return createSolNetworkPackage(CreateSolNetworkPackageRequest.builder().applyMutation(createSolNetworkPackageRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <p>
     * To delete a function package, the package must be in a disabled state. To disable a function package, see <a
     * href=
     * "https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolFunctionPackage.html">UpdateSolFunctionPackage
     * </a>.
     * </p>
     *
     * @param deleteSolFunctionPackageRequest
     * @return A Java Future containing the result of the DeleteSolFunctionPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.DeleteSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolFunctionPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSolFunctionPackageResponse> deleteSolFunctionPackage(
            DeleteSolFunctionPackageRequest deleteSolFunctionPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <p>
     * To delete a function package, the package must be in a disabled state. To disable a function package, see <a
     * href=
     * "https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolFunctionPackage.html">UpdateSolFunctionPackage
     * </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSolFunctionPackageRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSolFunctionPackageRequest#builder()}
     * </p>
     *
     * @param deleteSolFunctionPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.DeleteSolFunctionPackageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSolFunctionPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.DeleteSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolFunctionPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSolFunctionPackageResponse> deleteSolFunctionPackage(
            Consumer<DeleteSolFunctionPackageRequest.Builder> deleteSolFunctionPackageRequest) {
        return deleteSolFunctionPackage(DeleteSolFunctionPackageRequest.builder().applyMutation(deleteSolFunctionPackageRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * To delete a network instance, the instance must be in a stopped or terminated state. To terminate a network
     * instance, see <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_TerminateSolNetworkInstance.html">
     * TerminateSolNetworkInstance</a>.
     * </p>
     *
     * @param deleteSolNetworkInstanceRequest
     * @return A Java Future containing the result of the DeleteSolNetworkInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.DeleteSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolNetworkInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSolNetworkInstanceResponse> deleteSolNetworkInstance(
            DeleteSolNetworkInstanceRequest deleteSolNetworkInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * To delete a network instance, the instance must be in a stopped or terminated state. To terminate a network
     * instance, see <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_TerminateSolNetworkInstance.html">
     * TerminateSolNetworkInstance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSolNetworkInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSolNetworkInstanceRequest#builder()}
     * </p>
     *
     * @param deleteSolNetworkInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.DeleteSolNetworkInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSolNetworkInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.DeleteSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolNetworkInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSolNetworkInstanceResponse> deleteSolNetworkInstance(
            Consumer<DeleteSolNetworkInstanceRequest.Builder> deleteSolNetworkInstanceRequest) {
        return deleteSolNetworkInstance(DeleteSolNetworkInstanceRequest.builder().applyMutation(deleteSolNetworkInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <p>
     * To delete a network package, the package must be in a disable state. To disable a network package, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkPackage.html"
     * >UpdateSolNetworkPackage</a>.
     * </p>
     *
     * @param deleteSolNetworkPackageRequest
     * @return A Java Future containing the result of the DeleteSolNetworkPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.DeleteSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolNetworkPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSolNetworkPackageResponse> deleteSolNetworkPackage(
            DeleteSolNetworkPackageRequest deleteSolNetworkPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <p>
     * To delete a network package, the package must be in a disable state. To disable a network package, see <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_UpdateSolNetworkPackage.html"
     * >UpdateSolNetworkPackage</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSolNetworkPackageRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteSolNetworkPackageRequest#builder()}
     * </p>
     *
     * @param deleteSolNetworkPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.DeleteSolNetworkPackageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSolNetworkPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.DeleteSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/DeleteSolNetworkPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteSolNetworkPackageResponse> deleteSolNetworkPackage(
            Consumer<DeleteSolNetworkPackageRequest.Builder> deleteSolNetworkPackageRequest) {
        return deleteSolNetworkPackage(DeleteSolNetworkPackageRequest.builder().applyMutation(deleteSolNetworkPackageRequest)
                .build());
    }

    /**
     * <p>
     * Gets the details of a network function instance, including the instantiation state and metadata from the function
     * package descriptor in the network function package.
     * </p>
     * <p>
     * A network function instance is a function in a function package .
     * </p>
     *
     * @param getSolFunctionInstanceRequest
     * @return A Java Future containing the result of the GetSolFunctionInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolFunctionInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSolFunctionInstanceResponse> getSolFunctionInstance(
            GetSolFunctionInstanceRequest getSolFunctionInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a network function instance, including the instantiation state and metadata from the function
     * package descriptor in the network function package.
     * </p>
     * <p>
     * A network function instance is a function in a function package .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolFunctionInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link GetSolFunctionInstanceRequest#builder()}
     * </p>
     *
     * @param getSolFunctionInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.GetSolFunctionInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSolFunctionInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolFunctionInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSolFunctionInstanceResponse> getSolFunctionInstance(
            Consumer<GetSolFunctionInstanceRequest.Builder> getSolFunctionInstanceRequest) {
        return getSolFunctionInstance(GetSolFunctionInstanceRequest.builder().applyMutation(getSolFunctionInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Gets the details of an individual function package, such as the operational state and whether the package is in
     * use.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network..
     * </p>
     *
     * @param getSolFunctionPackageRequest
     * @return A Java Future containing the result of the GetSolFunctionPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSolFunctionPackageResponse> getSolFunctionPackage(
            GetSolFunctionPackageRequest getSolFunctionPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of an individual function package, such as the operational state and whether the package is in
     * use.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolFunctionPackageRequest.Builder} avoiding the
     * need to create one manually via {@link GetSolFunctionPackageRequest#builder()}
     * </p>
     *
     * @param getSolFunctionPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSolFunctionPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSolFunctionPackageResponse> getSolFunctionPackage(
            Consumer<GetSolFunctionPackageRequest.Builder> getSolFunctionPackageRequest) {
        return getSolFunctionPackage(GetSolFunctionPackageRequest.builder().applyMutation(getSolFunctionPackageRequest).build());
    }

    /**
     * <p>
     * Gets the contents of a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     *
     * @param getSolFunctionPackageContentRequest
     * @return A Java Future containing the result of the GetSolFunctionPackageContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolFunctionPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSolFunctionPackageContentResponse> getSolFunctionPackageContent(
            GetSolFunctionPackageContentRequest getSolFunctionPackageContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the contents of a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolFunctionPackageContentRequest.Builder}
     * avoiding the need to create one manually via {@link GetSolFunctionPackageContentRequest#builder()}
     * </p>
     *
     * @param getSolFunctionPackageContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageContentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSolFunctionPackageContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolFunctionPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSolFunctionPackageContentResponse> getSolFunctionPackageContent(
            Consumer<GetSolFunctionPackageContentRequest.Builder> getSolFunctionPackageContentRequest) {
        return getSolFunctionPackageContent(GetSolFunctionPackageContentRequest.builder()
                .applyMutation(getSolFunctionPackageContentRequest).build());
    }

    /**
     * <p>
     * Gets a function package descriptor in a function package.
     * </p>
     * <p>
     * A function package descriptor is a .yaml file in a function package that uses the TOSCA standard to describe how
     * the network function in the function package should run on your network.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     *
     * @param getSolFunctionPackageDescriptorRequest
     * @return A Java Future containing the result of the GetSolFunctionPackageDescriptor operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolFunctionPackageDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackageDescriptor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSolFunctionPackageDescriptorResponse> getSolFunctionPackageDescriptor(
            GetSolFunctionPackageDescriptorRequest getSolFunctionPackageDescriptorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a function package descriptor in a function package.
     * </p>
     * <p>
     * A function package descriptor is a .yaml file in a function package that uses the TOSCA standard to describe how
     * the network function in the function package should run on your network.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolFunctionPackageDescriptorRequest.Builder}
     * avoiding the need to create one manually via {@link GetSolFunctionPackageDescriptorRequest#builder()}
     * </p>
     *
     * @param getSolFunctionPackageDescriptorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.GetSolFunctionPackageDescriptorRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetSolFunctionPackageDescriptor operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolFunctionPackageDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolFunctionPackageDescriptor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSolFunctionPackageDescriptorResponse> getSolFunctionPackageDescriptor(
            Consumer<GetSolFunctionPackageDescriptorRequest.Builder> getSolFunctionPackageDescriptorRequest) {
        return getSolFunctionPackageDescriptor(GetSolFunctionPackageDescriptorRequest.builder()
                .applyMutation(getSolFunctionPackageDescriptorRequest).build());
    }

    /**
     * <p>
     * Gets the details of the network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     *
     * @param getSolNetworkInstanceRequest
     * @return A Java Future containing the result of the GetSolNetworkInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSolNetworkInstanceResponse> getSolNetworkInstance(
            GetSolNetworkInstanceRequest getSolNetworkInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolNetworkInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link GetSolNetworkInstanceRequest#builder()}
     * </p>
     *
     * @param getSolNetworkInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.GetSolNetworkInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSolNetworkInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkInstance" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSolNetworkInstanceResponse> getSolNetworkInstance(
            Consumer<GetSolNetworkInstanceRequest.Builder> getSolNetworkInstanceRequest) {
        return getSolNetworkInstance(GetSolNetworkInstanceRequest.builder().applyMutation(getSolNetworkInstanceRequest).build());
    }

    /**
     * <p>
     * Gets the details of a network operation, including the tasks involved in the network operation and the status of
     * the tasks.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     *
     * @param getSolNetworkOperationRequest
     * @return A Java Future containing the result of the GetSolNetworkOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolNetworkOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSolNetworkOperationResponse> getSolNetworkOperation(
            GetSolNetworkOperationRequest getSolNetworkOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a network operation, including the tasks involved in the network operation and the status of
     * the tasks.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolNetworkOperationRequest.Builder} avoiding the
     * need to create one manually via {@link GetSolNetworkOperationRequest#builder()}
     * </p>
     *
     * @param getSolNetworkOperationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.GetSolNetworkOperationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSolNetworkOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolNetworkOperation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetSolNetworkOperationResponse> getSolNetworkOperation(
            Consumer<GetSolNetworkOperationRequest.Builder> getSolNetworkOperationRequest) {
        return getSolNetworkOperation(GetSolNetworkOperationRequest.builder().applyMutation(getSolNetworkOperationRequest)
                .build());
    }

    /**
     * <p>
     * Gets the details of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     *
     * @param getSolNetworkPackageRequest
     * @return A Java Future containing the result of the GetSolNetworkPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSolNetworkPackageResponse> getSolNetworkPackage(
            GetSolNetworkPackageRequest getSolNetworkPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolNetworkPackageRequest.Builder} avoiding the
     * need to create one manually via {@link GetSolNetworkPackageRequest#builder()}
     * </p>
     *
     * @param getSolNetworkPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSolNetworkPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackage" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSolNetworkPackageResponse> getSolNetworkPackage(
            Consumer<GetSolNetworkPackageRequest.Builder> getSolNetworkPackageRequest) {
        return getSolNetworkPackage(GetSolNetworkPackageRequest.builder().applyMutation(getSolNetworkPackageRequest).build());
    }

    /**
     * <p>
     * Gets the contents of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     *
     * @param getSolNetworkPackageContentRequest
     * @return A Java Future containing the result of the GetSolNetworkPackageContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolNetworkPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSolNetworkPackageContentResponse> getSolNetworkPackageContent(
            GetSolNetworkPackageContentRequest getSolNetworkPackageContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the contents of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolNetworkPackageContentRequest.Builder}
     * avoiding the need to create one manually via {@link GetSolNetworkPackageContentRequest#builder()}
     * </p>
     *
     * @param getSolNetworkPackageContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageContentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetSolNetworkPackageContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolNetworkPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSolNetworkPackageContentResponse> getSolNetworkPackageContent(
            Consumer<GetSolNetworkPackageContentRequest.Builder> getSolNetworkPackageContentRequest) {
        return getSolNetworkPackageContent(GetSolNetworkPackageContentRequest.builder()
                .applyMutation(getSolNetworkPackageContentRequest).build());
    }

    /**
     * <p>
     * Gets the content of the network service descriptor.
     * </p>
     * <p>
     * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the
     * network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network
     * functions on.
     * </p>
     *
     * @param getSolNetworkPackageDescriptorRequest
     * @return A Java Future containing the result of the GetSolNetworkPackageDescriptor operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolNetworkPackageDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackageDescriptor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSolNetworkPackageDescriptorResponse> getSolNetworkPackageDescriptor(
            GetSolNetworkPackageDescriptorRequest getSolNetworkPackageDescriptorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the content of the network service descriptor.
     * </p>
     * <p>
     * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the
     * network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network
     * functions on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSolNetworkPackageDescriptorRequest.Builder}
     * avoiding the need to create one manually via {@link GetSolNetworkPackageDescriptorRequest#builder()}
     * </p>
     *
     * @param getSolNetworkPackageDescriptorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.GetSolNetworkPackageDescriptorRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetSolNetworkPackageDescriptor operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.GetSolNetworkPackageDescriptor
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/GetSolNetworkPackageDescriptor"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSolNetworkPackageDescriptorResponse> getSolNetworkPackageDescriptor(
            Consumer<GetSolNetworkPackageDescriptorRequest.Builder> getSolNetworkPackageDescriptorRequest) {
        return getSolNetworkPackageDescriptor(GetSolNetworkPackageDescriptorRequest.builder()
                .applyMutation(getSolNetworkPackageDescriptorRequest).build());
    }

    /**
     * <p>
     * Instantiates a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * Before you can instantiate a network instance, you have to create a network instance. For more information, see
     * <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkInstance.html">
     * CreateSolNetworkInstance</a>.
     * </p>
     *
     * @param instantiateSolNetworkInstanceRequest
     * @return A Java Future containing the result of the InstantiateSolNetworkInstance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ServiceQuotaExceededException Service quotas have been exceeded.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.InstantiateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/InstantiateSolNetworkInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InstantiateSolNetworkInstanceResponse> instantiateSolNetworkInstance(
            InstantiateSolNetworkInstanceRequest instantiateSolNetworkInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Instantiates a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * Before you can instantiate a network instance, you have to create a network instance. For more information, see
     * <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_CreateSolNetworkInstance.html">
     * CreateSolNetworkInstance</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InstantiateSolNetworkInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link InstantiateSolNetworkInstanceRequest#builder()}
     * </p>
     *
     * @param instantiateSolNetworkInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.InstantiateSolNetworkInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the InstantiateSolNetworkInstance operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ServiceQuotaExceededException Service quotas have been exceeded.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.InstantiateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/InstantiateSolNetworkInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<InstantiateSolNetworkInstanceResponse> instantiateSolNetworkInstance(
            Consumer<InstantiateSolNetworkInstanceRequest.Builder> instantiateSolNetworkInstanceRequest) {
        return instantiateSolNetworkInstance(InstantiateSolNetworkInstanceRequest.builder()
                .applyMutation(instantiateSolNetworkInstanceRequest).build());
    }

    /**
     * <p>
     * Lists network function instances.
     * </p>
     * <p>
     * A network function instance is a function in a function package .
     * </p>
     *
     * @param listSolFunctionInstancesRequest
     * @return A Java Future containing the result of the ListSolFunctionInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolFunctionInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSolFunctionInstancesResponse> listSolFunctionInstances(
            ListSolFunctionInstancesRequest listSolFunctionInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists network function instances.
     * </p>
     * <p>
     * A network function instance is a function in a function package .
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolFunctionInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolFunctionInstancesRequest#builder()}
     * </p>
     *
     * @param listSolFunctionInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSolFunctionInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolFunctionInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSolFunctionInstancesResponse> listSolFunctionInstances(
            Consumer<ListSolFunctionInstancesRequest.Builder> listSolFunctionInstancesRequest) {
        return listSolFunctionInstances(ListSolFunctionInstancesRequest.builder().applyMutation(listSolFunctionInstancesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSolFunctionInstances(software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesPublisher publisher = client.listSolFunctionInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesPublisher publisher = client.listSolFunctionInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolFunctionInstances(software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSolFunctionInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolFunctionInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolFunctionInstancesPublisher listSolFunctionInstancesPaginator(
            ListSolFunctionInstancesRequest listSolFunctionInstancesRequest) {
        return new ListSolFunctionInstancesPublisher(this, listSolFunctionInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSolFunctionInstances(software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesPublisher publisher = client.listSolFunctionInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionInstancesPublisher publisher = client.listSolFunctionInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolFunctionInstances(software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolFunctionInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolFunctionInstancesRequest#builder()}
     * </p>
     *
     * @param listSolFunctionInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolFunctionInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolFunctionInstancesPublisher listSolFunctionInstancesPaginator(
            Consumer<ListSolFunctionInstancesRequest.Builder> listSolFunctionInstancesRequest) {
        return listSolFunctionInstancesPaginator(ListSolFunctionInstancesRequest.builder()
                .applyMutation(listSolFunctionInstancesRequest).build());
    }

    /**
     * <p>
     * Lists information about function packages.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     *
     * @param listSolFunctionPackagesRequest
     * @return A Java Future containing the result of the ListSolFunctionPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolFunctionPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSolFunctionPackagesResponse> listSolFunctionPackages(
            ListSolFunctionPackagesRequest listSolFunctionPackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists information about function packages.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolFunctionPackagesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolFunctionPackagesRequest#builder()}
     * </p>
     *
     * @param listSolFunctionPackagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSolFunctionPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolFunctionPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSolFunctionPackagesResponse> listSolFunctionPackages(
            Consumer<ListSolFunctionPackagesRequest.Builder> listSolFunctionPackagesRequest) {
        return listSolFunctionPackages(ListSolFunctionPackagesRequest.builder().applyMutation(listSolFunctionPackagesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSolFunctionPackages(software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesPublisher publisher = client.listSolFunctionPackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesPublisher publisher = client.listSolFunctionPackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolFunctionPackages(software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSolFunctionPackagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolFunctionPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolFunctionPackagesPublisher listSolFunctionPackagesPaginator(
            ListSolFunctionPackagesRequest listSolFunctionPackagesRequest) {
        return new ListSolFunctionPackagesPublisher(this, listSolFunctionPackagesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSolFunctionPackages(software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesPublisher publisher = client.listSolFunctionPackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolFunctionPackagesPublisher publisher = client.listSolFunctionPackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolFunctionPackages(software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolFunctionPackagesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolFunctionPackagesRequest#builder()}
     * </p>
     *
     * @param listSolFunctionPackagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ListSolFunctionPackagesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolFunctionPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolFunctionPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolFunctionPackagesPublisher listSolFunctionPackagesPaginator(
            Consumer<ListSolFunctionPackagesRequest.Builder> listSolFunctionPackagesRequest) {
        return listSolFunctionPackagesPaginator(ListSolFunctionPackagesRequest.builder()
                .applyMutation(listSolFunctionPackagesRequest).build());
    }

    /**
     * <p>
     * Lists your network instances.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     *
     * @param listSolNetworkInstancesRequest
     * @return A Java Future containing the result of the ListSolNetworkInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolNetworkInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSolNetworkInstancesResponse> listSolNetworkInstances(
            ListSolNetworkInstancesRequest listSolNetworkInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your network instances.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolNetworkInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolNetworkInstancesRequest#builder()}
     * </p>
     *
     * @param listSolNetworkInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSolNetworkInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolNetworkInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSolNetworkInstancesResponse> listSolNetworkInstances(
            Consumer<ListSolNetworkInstancesRequest.Builder> listSolNetworkInstancesRequest) {
        return listSolNetworkInstances(ListSolNetworkInstancesRequest.builder().applyMutation(listSolNetworkInstancesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSolNetworkInstances(software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesPublisher publisher = client.listSolNetworkInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesPublisher publisher = client.listSolNetworkInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolNetworkInstances(software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSolNetworkInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolNetworkInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkInstancesPublisher listSolNetworkInstancesPaginator(
            ListSolNetworkInstancesRequest listSolNetworkInstancesRequest) {
        return new ListSolNetworkInstancesPublisher(this, listSolNetworkInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSolNetworkInstances(software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesPublisher publisher = client.listSolNetworkInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkInstancesPublisher publisher = client.listSolNetworkInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolNetworkInstances(software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolNetworkInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolNetworkInstancesRequest#builder()}
     * </p>
     *
     * @param listSolNetworkInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolNetworkInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkInstancesPublisher listSolNetworkInstancesPaginator(
            Consumer<ListSolNetworkInstancesRequest.Builder> listSolNetworkInstancesRequest) {
        return listSolNetworkInstancesPaginator(ListSolNetworkInstancesRequest.builder()
                .applyMutation(listSolNetworkInstancesRequest).build());
    }

    /**
     * <p>
     * Lists details for a network operation, including when the operation started and the status of the operation.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     *
     * @param listSolNetworkOperationsRequest
     * @return A Java Future containing the result of the ListSolNetworkOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolNetworkOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSolNetworkOperationsResponse> listSolNetworkOperations(
            ListSolNetworkOperationsRequest listSolNetworkOperationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details for a network operation, including when the operation started and the status of the operation.
     * </p>
     * <p>
     * A network operation is any operation that is done to your network, such as network instance instantiation or
     * termination.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolNetworkOperationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolNetworkOperationsRequest#builder()}
     * </p>
     *
     * @param listSolNetworkOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSolNetworkOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolNetworkOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSolNetworkOperationsResponse> listSolNetworkOperations(
            Consumer<ListSolNetworkOperationsRequest.Builder> listSolNetworkOperationsRequest) {
        return listSolNetworkOperations(ListSolNetworkOperationsRequest.builder().applyMutation(listSolNetworkOperationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSolNetworkOperations(software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsPublisher publisher = client.listSolNetworkOperationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsPublisher publisher = client.listSolNetworkOperationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolNetworkOperations(software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSolNetworkOperationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolNetworkOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkOperationsPublisher listSolNetworkOperationsPaginator(
            ListSolNetworkOperationsRequest listSolNetworkOperationsRequest) {
        return new ListSolNetworkOperationsPublisher(this, listSolNetworkOperationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSolNetworkOperations(software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsPublisher publisher = client.listSolNetworkOperationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkOperationsPublisher publisher = client.listSolNetworkOperationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolNetworkOperations(software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolNetworkOperationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSolNetworkOperationsRequest#builder()}
     * </p>
     *
     * @param listSolNetworkOperationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolNetworkOperations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkOperations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkOperationsPublisher listSolNetworkOperationsPaginator(
            Consumer<ListSolNetworkOperationsRequest.Builder> listSolNetworkOperationsRequest) {
        return listSolNetworkOperationsPaginator(ListSolNetworkOperationsRequest.builder()
                .applyMutation(listSolNetworkOperationsRequest).build());
    }

    /**
     * <p>
     * Lists network packages.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     *
     * @param listSolNetworkPackagesRequest
     * @return A Java Future containing the result of the ListSolNetworkPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolNetworkPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSolNetworkPackagesResponse> listSolNetworkPackages(
            ListSolNetworkPackagesRequest listSolNetworkPackagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists network packages.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolNetworkPackagesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSolNetworkPackagesRequest#builder()}
     * </p>
     *
     * @param listSolNetworkPackagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSolNetworkPackages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolNetworkPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSolNetworkPackagesResponse> listSolNetworkPackages(
            Consumer<ListSolNetworkPackagesRequest.Builder> listSolNetworkPackagesRequest) {
        return listSolNetworkPackages(ListSolNetworkPackagesRequest.builder().applyMutation(listSolNetworkPackagesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSolNetworkPackages(software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesPublisher publisher = client.listSolNetworkPackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesPublisher publisher = client.listSolNetworkPackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolNetworkPackages(software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSolNetworkPackagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolNetworkPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkPackagesPublisher listSolNetworkPackagesPaginator(
            ListSolNetworkPackagesRequest listSolNetworkPackagesRequest) {
        return new ListSolNetworkPackagesPublisher(this, listSolNetworkPackagesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSolNetworkPackages(software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesPublisher publisher = client.listSolNetworkPackagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.tnb.paginators.ListSolNetworkPackagesPublisher publisher = client.listSolNetworkPackagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolNetworkPackages(software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolNetworkPackagesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSolNetworkPackagesRequest#builder()}
     * </p>
     *
     * @param listSolNetworkPackagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ListSolNetworkPackagesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListSolNetworkPackages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListSolNetworkPackages" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSolNetworkPackagesPublisher listSolNetworkPackagesPaginator(
            Consumer<ListSolNetworkPackagesRequest.Builder> listSolNetworkPackagesRequest) {
        return listSolNetworkPackagesPaginator(ListSolNetworkPackagesRequest.builder()
                .applyMutation(listSolNetworkPackagesRequest).build());
    }

    /**
     * <p>
     * Lists tags for AWS TNB resources.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for AWS TNB resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ListTagsForResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Uploads the contents of a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     *
     * @param putSolFunctionPackageContentRequest
     * @return A Java Future containing the result of the PutSolFunctionPackageContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.PutSolFunctionPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/PutSolFunctionPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSolFunctionPackageContentResponse> putSolFunctionPackageContent(
            PutSolFunctionPackageContentRequest putSolFunctionPackageContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads the contents of a function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSolFunctionPackageContentRequest.Builder}
     * avoiding the need to create one manually via {@link PutSolFunctionPackageContentRequest#builder()}
     * </p>
     *
     * @param putSolFunctionPackageContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.PutSolFunctionPackageContentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutSolFunctionPackageContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.PutSolFunctionPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/PutSolFunctionPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSolFunctionPackageContentResponse> putSolFunctionPackageContent(
            Consumer<PutSolFunctionPackageContentRequest.Builder> putSolFunctionPackageContentRequest) {
        return putSolFunctionPackageContent(PutSolFunctionPackageContentRequest.builder()
                .applyMutation(putSolFunctionPackageContentRequest).build());
    }

    /**
     * <p>
     * Uploads the contents of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     *
     * @param putSolNetworkPackageContentRequest
     * @return A Java Future containing the result of the PutSolNetworkPackageContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.PutSolNetworkPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/PutSolNetworkPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSolNetworkPackageContentResponse> putSolNetworkPackageContent(
            PutSolNetworkPackageContentRequest putSolNetworkPackageContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads the contents of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSolNetworkPackageContentRequest.Builder}
     * avoiding the need to create one manually via {@link PutSolNetworkPackageContentRequest#builder()}
     * </p>
     *
     * @param putSolNetworkPackageContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.PutSolNetworkPackageContentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutSolNetworkPackageContent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.PutSolNetworkPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/PutSolNetworkPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutSolNetworkPackageContentResponse> putSolNetworkPackageContent(
            Consumer<PutSolNetworkPackageContentRequest.Builder> putSolNetworkPackageContentRequest) {
        return putSolNetworkPackageContent(PutSolNetworkPackageContentRequest.builder()
                .applyMutation(putSolNetworkPackageContentRequest).build());
    }

    /**
     * <p>
     * Tags an AWS TNB resource.
     * </p>
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags an AWS TNB resource.
     * </p>
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Terminates a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * You must terminate a network instance before you can delete it.
     * </p>
     *
     * @param terminateSolNetworkInstanceRequest
     * @return A Java Future containing the result of the TerminateSolNetworkInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ServiceQuotaExceededException Service quotas have been exceeded.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.TerminateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/TerminateSolNetworkInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateSolNetworkInstanceResponse> terminateSolNetworkInstance(
            TerminateSolNetworkInstanceRequest terminateSolNetworkInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Terminates a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * You must terminate a network instance before you can delete it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateSolNetworkInstanceRequest.Builder}
     * avoiding the need to create one manually via {@link TerminateSolNetworkInstanceRequest#builder()}
     * </p>
     *
     * @param terminateSolNetworkInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.TerminateSolNetworkInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TerminateSolNetworkInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ServiceQuotaExceededException Service quotas have been exceeded.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.TerminateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/TerminateSolNetworkInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TerminateSolNetworkInstanceResponse> terminateSolNetworkInstance(
            Consumer<TerminateSolNetworkInstanceRequest.Builder> terminateSolNetworkInstanceRequest) {
        return terminateSolNetworkInstance(TerminateSolNetworkInstanceRequest.builder()
                .applyMutation(terminateSolNetworkInstanceRequest).build());
    }

    /**
     * <p>
     * Untags an AWS TNB resource.
     * </p>
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags an AWS TNB resource.
     * </p>
     * <p>
     * A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional
     * value. You can use tags to search and filter your resources or track your Amazon Web Services costs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the operational state of function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     *
     * @param updateSolFunctionPackageRequest
     * @return A Java Future containing the result of the UpdateSolFunctionPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.UpdateSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolFunctionPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSolFunctionPackageResponse> updateSolFunctionPackage(
            UpdateSolFunctionPackageRequest updateSolFunctionPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the operational state of function package.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSolFunctionPackageRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSolFunctionPackageRequest#builder()}
     * </p>
     *
     * @param updateSolFunctionPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.UpdateSolFunctionPackageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSolFunctionPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.UpdateSolFunctionPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolFunctionPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSolFunctionPackageResponse> updateSolFunctionPackage(
            Consumer<UpdateSolFunctionPackageRequest.Builder> updateSolFunctionPackageRequest) {
        return updateSolFunctionPackage(UpdateSolFunctionPackageRequest.builder().applyMutation(updateSolFunctionPackageRequest)
                .build());
    }

    /**
     * <p>
     * Update a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * Choose the <i>updateType</i> parameter to target the necessary update of the network instance.
     * </p>
     *
     * @param updateSolNetworkInstanceRequest
     * @return A Java Future containing the result of the UpdateSolNetworkInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ServiceQuotaExceededException Service quotas have been exceeded.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.UpdateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolNetworkInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSolNetworkInstanceResponse> updateSolNetworkInstance(
            UpdateSolNetworkInstanceRequest updateSolNetworkInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a network instance.
     * </p>
     * <p>
     * A network instance is a single network created in Amazon Web Services TNB that can be deployed and on which
     * life-cycle operations (like terminate, update, and delete) can be performed.
     * </p>
     * <p>
     * Choose the <i>updateType</i> parameter to target the necessary update of the network instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSolNetworkInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSolNetworkInstanceRequest#builder()}
     * </p>
     *
     * @param updateSolNetworkInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.UpdateSolNetworkInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSolNetworkInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ServiceQuotaExceededException Service quotas have been exceeded.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.UpdateSolNetworkInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolNetworkInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSolNetworkInstanceResponse> updateSolNetworkInstance(
            Consumer<UpdateSolNetworkInstanceRequest.Builder> updateSolNetworkInstanceRequest) {
        return updateSolNetworkInstance(UpdateSolNetworkInstanceRequest.builder().applyMutation(updateSolNetworkInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Updates the operational state of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <p>
     * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the
     * network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network
     * functions on.
     * </p>
     *
     * @param updateSolNetworkPackageRequest
     * @return A Java Future containing the result of the UpdateSolNetworkPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.UpdateSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolNetworkPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSolNetworkPackageResponse> updateSolNetworkPackage(
            UpdateSolNetworkPackageRequest updateSolNetworkPackageRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the operational state of a network package.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <p>
     * A network service descriptor is a .yaml file in a network package that uses the TOSCA standard to describe the
     * network functions you want to deploy and the Amazon Web Services infrastructure you want to deploy the network
     * functions on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSolNetworkPackageRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSolNetworkPackageRequest#builder()}
     * </p>
     *
     * @param updateSolNetworkPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.UpdateSolNetworkPackageRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSolNetworkPackage operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.UpdateSolNetworkPackage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/UpdateSolNetworkPackage" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateSolNetworkPackageResponse> updateSolNetworkPackage(
            Consumer<UpdateSolNetworkPackageRequest.Builder> updateSolNetworkPackageRequest) {
        return updateSolNetworkPackage(UpdateSolNetworkPackageRequest.builder().applyMutation(updateSolNetworkPackageRequest)
                .build());
    }

    /**
     * <p>
     * Validates function package content. This can be used as a dry run before uploading function package content with
     * <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html">
     * PutSolFunctionPackageContent</a>.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     *
     * @param validateSolFunctionPackageContentRequest
     * @return A Java Future containing the result of the ValidateSolFunctionPackageContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ValidateSolFunctionPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ValidateSolFunctionPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateSolFunctionPackageContentResponse> validateSolFunctionPackageContent(
            ValidateSolFunctionPackageContentRequest validateSolFunctionPackageContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates function package content. This can be used as a dry run before uploading function package content with
     * <a href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolFunctionPackageContent.html">
     * PutSolFunctionPackageContent</a>.
     * </p>
     * <p>
     * A function package is a .zip file in CSAR (Cloud Service Archive) format that contains a network function (an
     * ETSI standard telecommunication application) and function package descriptor that uses the TOSCA standard to
     * describe how the network functions should run on your network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateSolFunctionPackageContentRequest.Builder}
     * avoiding the need to create one manually via {@link ValidateSolFunctionPackageContentRequest#builder()}
     * </p>
     *
     * @param validateSolFunctionPackageContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ValidateSolFunctionPackageContentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ValidateSolFunctionPackageContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ValidateSolFunctionPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ValidateSolFunctionPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateSolFunctionPackageContentResponse> validateSolFunctionPackageContent(
            Consumer<ValidateSolFunctionPackageContentRequest.Builder> validateSolFunctionPackageContentRequest) {
        return validateSolFunctionPackageContent(ValidateSolFunctionPackageContentRequest.builder()
                .applyMutation(validateSolFunctionPackageContentRequest).build());
    }

    /**
     * <p>
     * Validates network package content. This can be used as a dry run before uploading network package content with <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html">
     * PutSolNetworkPackageContent</a>.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     *
     * @param validateSolNetworkPackageContentRequest
     * @return A Java Future containing the result of the ValidateSolNetworkPackageContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ValidateSolNetworkPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ValidateSolNetworkPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateSolNetworkPackageContentResponse> validateSolNetworkPackageContent(
            ValidateSolNetworkPackageContentRequest validateSolNetworkPackageContentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Validates network package content. This can be used as a dry run before uploading network package content with <a
     * href="https://docs.aws.amazon.com/tnb/latest/APIReference/API_PutSolNetworkPackageContent.html">
     * PutSolNetworkPackageContent</a>.
     * </p>
     * <p>
     * A network package is a .zip file in CSAR (Cloud Service Archive) format defines the function packages you want to
     * deploy and the Amazon Web Services infrastructure you want to deploy them on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ValidateSolNetworkPackageContentRequest.Builder}
     * avoiding the need to create one manually via {@link ValidateSolNetworkPackageContentRequest#builder()}
     * </p>
     *
     * @param validateSolNetworkPackageContentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.tnb.model.ValidateSolNetworkPackageContentRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ValidateSolNetworkPackageContent operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Unexpected error occurred. Problem on the server.</li>
     *         <li>ThrottlingException Exception caused by throttling.</li>
     *         <li>ValidationException Unable to process the request because the client provided input failed to satisfy
     *         request constraints.</li>
     *         <li>ResourceNotFoundException Request references a resource that doesn't exist.</li>
     *         <li>AccessDeniedException Insufficient permissions to make request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TnbException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample TnbAsyncClient.ValidateSolNetworkPackageContent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/tnb-2008-10-21/ValidateSolNetworkPackageContent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ValidateSolNetworkPackageContentResponse> validateSolNetworkPackageContent(
            Consumer<ValidateSolNetworkPackageContentRequest.Builder> validateSolNetworkPackageContentRequest) {
        return validateSolNetworkPackageContent(ValidateSolNetworkPackageContentRequest.builder()
                .applyMutation(validateSolNetworkPackageContentRequest).build());
    }

    @Override
    default TnbServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link TnbAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TnbAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TnbAsyncClient}.
     */
    static TnbAsyncClientBuilder builder() {
        return new DefaultTnbAsyncClientBuilder();
    }
}
