/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.tnb.model.PackageContentType;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSolNetworkPackageContentResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, GetSolNetworkPackageContentResponse> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(GetSolNetworkPackageContentResponse.getter(GetSolNetworkPackageContentResponse::contentTypeAsString)).setter(GetSolNetworkPackageContentResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<SdkBytes> NSD_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("nsdContent").getter(GetSolNetworkPackageContentResponse.getter(GetSolNetworkPackageContentResponse::nsdContent)).setter(GetSolNetworkPackageContentResponse.setter(Builder::nsdContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdContent").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, NSD_CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSolNetworkPackageContentResponse.memberNameToFieldInitializer();
    private final String contentType;
    private final SdkBytes nsdContent;

    private GetSolNetworkPackageContentResponse(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.nsdContent = builder.nsdContent;
    }

    public final PackageContentType contentType() {
        return PackageContentType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public final SdkBytes nsdContent() {
        return this.nsdContent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdContent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSolNetworkPackageContentResponse)) {
            return false;
        }
        GetSolNetworkPackageContentResponse other = (GetSolNetworkPackageContentResponse)((Object)obj);
        return Objects.equals(this.contentTypeAsString(), other.contentTypeAsString()) && Objects.equals(this.nsdContent(), other.nsdContent());
    }

    public final String toString() {
        return ToString.builder((String)"GetSolNetworkPackageContentResponse").add("ContentType", (Object)this.contentTypeAsString()).add("NsdContent", (Object)this.nsdContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
            case "nsdContent": {
                return Optional.ofNullable(clazz.cast(this.nsdContent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("nsdContent", NSD_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSolNetworkPackageContentResponse, T> g) {
        return obj -> g.apply((GetSolNetworkPackageContentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private String contentType;
        private SdkBytes nsdContent;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSolNetworkPackageContentResponse model) {
            super(model);
            this.contentType(model.contentType);
            this.nsdContent(model.nsdContent);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(PackageContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final ByteBuffer getNsdContent() {
            return this.nsdContent == null ? null : this.nsdContent.asByteBuffer();
        }

        public final void setNsdContent(ByteBuffer nsdContent) {
            this.nsdContent(nsdContent == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)nsdContent));
        }

        @Override
        public final Builder nsdContent(SdkBytes nsdContent) {
            this.nsdContent = nsdContent;
            return this;
        }

        @Override
        public GetSolNetworkPackageContentResponse build() {
            return new GetSolNetworkPackageContentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSolNetworkPackageContentResponse> {
        public Builder contentType(String var1);

        public Builder contentType(PackageContentType var1);

        public Builder nsdContent(SdkBytes var1);
    }
}

