/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackageInfo;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkPackageResourcesCopier;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSolNetworkPackagesResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, ListSolNetworkPackagesResponse> {
    private static final SdkField<List<ListSolNetworkPackageInfo>> NETWORK_PACKAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkPackages").getter(ListSolNetworkPackagesResponse.getter(ListSolNetworkPackagesResponse::networkPackages)).setter(ListSolNetworkPackagesResponse.setter(Builder::networkPackages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkPackages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListSolNetworkPackageInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSolNetworkPackagesResponse.getter(ListSolNetworkPackagesResponse::nextToken)).setter(ListSolNetworkPackagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_PACKAGES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSolNetworkPackagesResponse.memberNameToFieldInitializer();
    private final List<ListSolNetworkPackageInfo> networkPackages;
    private final String nextToken;

    private ListSolNetworkPackagesResponse(BuilderImpl builder) {
        super(builder);
        this.networkPackages = builder.networkPackages;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNetworkPackages() {
        return this.networkPackages != null && !(this.networkPackages instanceof SdkAutoConstructList);
    }

    public final List<ListSolNetworkPackageInfo> networkPackages() {
        return this.networkPackages;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkPackages() ? this.networkPackages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolNetworkPackagesResponse)) {
            return false;
        }
        ListSolNetworkPackagesResponse other = (ListSolNetworkPackagesResponse)((Object)obj);
        return this.hasNetworkPackages() == other.hasNetworkPackages() && Objects.equals(this.networkPackages(), other.networkPackages()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSolNetworkPackagesResponse").add("NetworkPackages", this.hasNetworkPackages() ? this.networkPackages() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkPackages": {
                return Optional.ofNullable(clazz.cast(this.networkPackages()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkPackages", NETWORK_PACKAGES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSolNetworkPackagesResponse, T> g) {
        return obj -> g.apply((ListSolNetworkPackagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private List<ListSolNetworkPackageInfo> networkPackages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolNetworkPackagesResponse model) {
            super(model);
            this.networkPackages(model.networkPackages);
            this.nextToken(model.nextToken);
        }

        public final List<ListSolNetworkPackageInfo.Builder> getNetworkPackages() {
            List<ListSolNetworkPackageInfo.Builder> result = ListSolNetworkPackageResourcesCopier.copyToBuilder(this.networkPackages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkPackages(Collection<ListSolNetworkPackageInfo.BuilderImpl> networkPackages) {
            this.networkPackages = ListSolNetworkPackageResourcesCopier.copyFromBuilder(networkPackages);
        }

        @Override
        public final Builder networkPackages(Collection<ListSolNetworkPackageInfo> networkPackages) {
            this.networkPackages = ListSolNetworkPackageResourcesCopier.copy(networkPackages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkPackages(ListSolNetworkPackageInfo ... networkPackages) {
            this.networkPackages(Arrays.asList(networkPackages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkPackages(Consumer<ListSolNetworkPackageInfo.Builder> ... networkPackages) {
            this.networkPackages(Stream.of(networkPackages).map(c -> (ListSolNetworkPackageInfo)((ListSolNetworkPackageInfo.Builder)ListSolNetworkPackageInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSolNetworkPackagesResponse build() {
            return new ListSolNetworkPackagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSolNetworkPackagesResponse> {
        public Builder networkPackages(Collection<ListSolNetworkPackageInfo> var1);

        public Builder networkPackages(ListSolNetworkPackageInfo ... var1);

        public Builder networkPackages(Consumer<ListSolNetworkPackageInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

