/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.tnb.TnbAsyncClient;
import software.amazon.awssdk.services.tnb.internal.UserAgentUtils;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstanceInfo;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstancesResponse;

public class ListSolNetworkInstancesPublisher
implements SdkPublisher<ListSolNetworkInstancesResponse> {
    private final TnbAsyncClient client;
    private final ListSolNetworkInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSolNetworkInstancesPublisher(TnbAsyncClient client, ListSolNetworkInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSolNetworkInstancesPublisher(TnbAsyncClient client, ListSolNetworkInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSolNetworkInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSolNetworkInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListSolNetworkInstanceInfo> networkInstances() {
        Function<ListSolNetworkInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkInstances() != null) {
                return response.networkInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSolNetworkInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSolNetworkInstancesResponseFetcher
    implements AsyncPageFetcher<ListSolNetworkInstancesResponse> {
        private ListSolNetworkInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListSolNetworkInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSolNetworkInstancesResponse> nextPage(ListSolNetworkInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListSolNetworkInstancesPublisher.this.client.listSolNetworkInstances(ListSolNetworkInstancesPublisher.this.firstRequest);
            }
            return ListSolNetworkInstancesPublisher.this.client.listSolNetworkInstances((ListSolNetworkInstancesRequest)((Object)ListSolNetworkInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

