/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.tnb.TnbClient;
import software.amazon.awssdk.services.tnb.internal.UserAgentUtils;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionInstanceInfo;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesRequest;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionInstancesResponse;

public class ListSolFunctionInstancesIterable
implements SdkIterable<ListSolFunctionInstancesResponse> {
    private final TnbClient client;
    private final ListSolFunctionInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSolFunctionInstancesIterable(TnbClient client, ListSolFunctionInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSolFunctionInstancesResponseFetcher();
    }

    public Iterator<ListSolFunctionInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListSolFunctionInstanceInfo> functionInstances() {
        Function<ListSolFunctionInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.functionInstances() != null) {
                return response.functionInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSolFunctionInstancesResponseFetcher
    implements SyncPageFetcher<ListSolFunctionInstancesResponse> {
        private ListSolFunctionInstancesResponseFetcher() {
        }

        public boolean hasNextPage(ListSolFunctionInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSolFunctionInstancesResponse nextPage(ListSolFunctionInstancesResponse previousPage) {
            if (previousPage == null) {
                return ListSolFunctionInstancesIterable.this.client.listSolFunctionInstances(ListSolFunctionInstancesIterable.this.firstRequest);
            }
            return ListSolFunctionInstancesIterable.this.client.listSolFunctionInstances((ListSolFunctionInstancesRequest)((Object)ListSolFunctionInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

