/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PackageContentType {
    APPLICATION_ZIP("application/zip"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PackageContentType> VALUE_MAP;
    private final String value;

    private PackageContentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageContentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageContentType> knownValues() {
        EnumSet<PackageContentType> knownValues = EnumSet.allOf(PackageContentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PackageContentType.class, PackageContentType::toString);
    }
}

