/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.tnb.model.LcmOperationType;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsMetadata;
import software.amazon.awssdk.services.tnb.model.NsLcmOperationState;
import software.amazon.awssdk.services.tnb.model.ProblemDetails;
import software.amazon.awssdk.services.tnb.model.UpdateSolNetworkType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSolNetworkOperationsInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListSolNetworkOperationsInfo> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ListSolNetworkOperationsInfo.getter(ListSolNetworkOperationsInfo::arn)).setter(ListSolNetworkOperationsInfo.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<ProblemDetails> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(ListSolNetworkOperationsInfo.getter(ListSolNetworkOperationsInfo::error)).setter(ListSolNetworkOperationsInfo.setter(Builder::error)).constructor(ProblemDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ListSolNetworkOperationsInfo.getter(ListSolNetworkOperationsInfo::id)).setter(ListSolNetworkOperationsInfo.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> LCM_OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lcmOperationType").getter(ListSolNetworkOperationsInfo.getter(ListSolNetworkOperationsInfo::lcmOperationTypeAsString)).setter(ListSolNetworkOperationsInfo.setter(Builder::lcmOperationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lcmOperationType").build()}).build();
    private static final SdkField<ListSolNetworkOperationsMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(ListSolNetworkOperationsInfo.getter(ListSolNetworkOperationsInfo::metadata)).setter(ListSolNetworkOperationsInfo.setter(Builder::metadata)).constructor(ListSolNetworkOperationsMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<String> NS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsInstanceId").getter(ListSolNetworkOperationsInfo.getter(ListSolNetworkOperationsInfo::nsInstanceId)).setter(ListSolNetworkOperationsInfo.setter(Builder::nsInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceId").build()}).build();
    private static final SdkField<String> OPERATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationState").getter(ListSolNetworkOperationsInfo.getter(ListSolNetworkOperationsInfo::operationStateAsString)).setter(ListSolNetworkOperationsInfo.setter(Builder::operationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationState").build()}).build();
    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updateType").getter(ListSolNetworkOperationsInfo.getter(ListSolNetworkOperationsInfo::updateTypeAsString)).setter(ListSolNetworkOperationsInfo.setter(Builder::updateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ERROR_FIELD, ID_FIELD, LCM_OPERATION_TYPE_FIELD, METADATA_FIELD, NS_INSTANCE_ID_FIELD, OPERATION_STATE_FIELD, UPDATE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSolNetworkOperationsInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final ProblemDetails error;
    private final String id;
    private final String lcmOperationType;
    private final ListSolNetworkOperationsMetadata metadata;
    private final String nsInstanceId;
    private final String operationState;
    private final String updateType;

    private ListSolNetworkOperationsInfo(BuilderImpl builder) {
        this.arn = builder.arn;
        this.error = builder.error;
        this.id = builder.id;
        this.lcmOperationType = builder.lcmOperationType;
        this.metadata = builder.metadata;
        this.nsInstanceId = builder.nsInstanceId;
        this.operationState = builder.operationState;
        this.updateType = builder.updateType;
    }

    public final String arn() {
        return this.arn;
    }

    public final ProblemDetails error() {
        return this.error;
    }

    public final String id() {
        return this.id;
    }

    public final LcmOperationType lcmOperationType() {
        return LcmOperationType.fromValue(this.lcmOperationType);
    }

    public final String lcmOperationTypeAsString() {
        return this.lcmOperationType;
    }

    public final ListSolNetworkOperationsMetadata metadata() {
        return this.metadata;
    }

    public final String nsInstanceId() {
        return this.nsInstanceId;
    }

    public final NsLcmOperationState operationState() {
        return NsLcmOperationState.fromValue(this.operationState);
    }

    public final String operationStateAsString() {
        return this.operationState;
    }

    public final UpdateSolNetworkType updateType() {
        return UpdateSolNetworkType.fromValue(this.updateType);
    }

    public final String updateTypeAsString() {
        return this.updateType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lcmOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolNetworkOperationsInfo)) {
            return false;
        }
        ListSolNetworkOperationsInfo other = (ListSolNetworkOperationsInfo)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lcmOperationTypeAsString(), other.lcmOperationTypeAsString()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.nsInstanceId(), other.nsInstanceId()) && Objects.equals(this.operationStateAsString(), other.operationStateAsString()) && Objects.equals(this.updateTypeAsString(), other.updateTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListSolNetworkOperationsInfo").add("Arn", (Object)this.arn()).add("Error", (Object)this.error()).add("Id", (Object)this.id()).add("LcmOperationType", (Object)this.lcmOperationTypeAsString()).add("Metadata", (Object)this.metadata()).add("NsInstanceId", (Object)this.nsInstanceId()).add("OperationState", (Object)this.operationStateAsString()).add("UpdateType", (Object)this.updateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lcmOperationType": {
                return Optional.ofNullable(clazz.cast(this.lcmOperationTypeAsString()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "nsInstanceId": {
                return Optional.ofNullable(clazz.cast(this.nsInstanceId()));
            }
            case "operationState": {
                return Optional.ofNullable(clazz.cast(this.operationStateAsString()));
            }
            case "updateType": {
                return Optional.ofNullable(clazz.cast(this.updateTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("id", ID_FIELD);
        map.put("lcmOperationType", LCM_OPERATION_TYPE_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("nsInstanceId", NS_INSTANCE_ID_FIELD);
        map.put("operationState", OPERATION_STATE_FIELD);
        map.put("updateType", UPDATE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSolNetworkOperationsInfo, T> g) {
        return obj -> g.apply((ListSolNetworkOperationsInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private ProblemDetails error;
        private String id;
        private String lcmOperationType;
        private ListSolNetworkOperationsMetadata metadata;
        private String nsInstanceId;
        private String operationState;
        private String updateType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolNetworkOperationsInfo model) {
            this.arn(model.arn);
            this.error(model.error);
            this.id(model.id);
            this.lcmOperationType(model.lcmOperationType);
            this.metadata(model.metadata);
            this.nsInstanceId(model.nsInstanceId);
            this.operationState(model.operationState);
            this.updateType(model.updateType);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ProblemDetails.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ProblemDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ProblemDetails error) {
            this.error = error;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getLcmOperationType() {
            return this.lcmOperationType;
        }

        public final void setLcmOperationType(String lcmOperationType) {
            this.lcmOperationType = lcmOperationType;
        }

        @Override
        public final Builder lcmOperationType(String lcmOperationType) {
            this.lcmOperationType = lcmOperationType;
            return this;
        }

        @Override
        public final Builder lcmOperationType(LcmOperationType lcmOperationType) {
            this.lcmOperationType(lcmOperationType == null ? null : lcmOperationType.toString());
            return this;
        }

        public final ListSolNetworkOperationsMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(ListSolNetworkOperationsMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ListSolNetworkOperationsMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsInstanceId() {
            return this.nsInstanceId;
        }

        public final void setNsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
        }

        @Override
        public final Builder nsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
            return this;
        }

        public final String getOperationState() {
            return this.operationState;
        }

        public final void setOperationState(String operationState) {
            this.operationState = operationState;
        }

        @Override
        public final Builder operationState(String operationState) {
            this.operationState = operationState;
            return this;
        }

        @Override
        public final Builder operationState(NsLcmOperationState operationState) {
            this.operationState(operationState == null ? null : operationState.toString());
            return this;
        }

        public final String getUpdateType() {
            return this.updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(UpdateSolNetworkType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public ListSolNetworkOperationsInfo build() {
            return new ListSolNetworkOperationsInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListSolNetworkOperationsInfo> {
        public Builder arn(String var1);

        public Builder error(ProblemDetails var1);

        default public Builder error(Consumer<ProblemDetails.Builder> error) {
            return this.error((ProblemDetails)((ProblemDetails.Builder)ProblemDetails.builder().applyMutation(error)).build());
        }

        public Builder id(String var1);

        public Builder lcmOperationType(String var1);

        public Builder lcmOperationType(LcmOperationType var1);

        public Builder metadata(ListSolNetworkOperationsMetadata var1);

        default public Builder metadata(Consumer<ListSolNetworkOperationsMetadata.Builder> metadata) {
            return this.metadata((ListSolNetworkOperationsMetadata)((ListSolNetworkOperationsMetadata.Builder)ListSolNetworkOperationsMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder nsInstanceId(String var1);

        public Builder operationState(String var1);

        public Builder operationState(NsLcmOperationState var1);

        public Builder updateType(String var1);

        public Builder updateType(UpdateSolNetworkType var1);
    }
}

